/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ComponentPostMetadata;
import org.kuali.rice.krad.web.bind.UifEncryptionPropertyEditorWrapper;

public class ViewPostMetadata
implements Serializable {
    private static final long serialVersionUID = -515221881981451818L;
    private static final Logger LOG = Logger.getLogger(ViewPostMetadata.class);
    private String id;
    private Map<String, ComponentPostMetadata> componentPostMetadataMap;
    private Map<String, PropertyEditor> fieldPropertyEditors = Collections.synchronizedMap(new HashMap());
    private Map<String, PropertyEditor> secureFieldPropertyEditors = Collections.synchronizedMap(new HashMap());
    private Set<String> inputFieldIds = Collections.synchronizedSet(new HashSet());
    private Set<String> allRenderedPropertyPaths = Collections.synchronizedSet(new HashSet());
    private Map<String, List<Object>> addedCollectionObjects = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Object>> lookupCriteria = Collections.synchronizedMap(new HashMap());
    private Set<String> accessibleBindingPaths = Collections.synchronizedSet(new HashSet());
    private Set<String> accessibleMethodToCalls = Collections.synchronizedSet(new HashSet());
    private Set<String> availableMethodToCalls = Collections.synchronizedSet(new HashSet());

    public ViewPostMetadata() {
    }

    public ViewPostMetadata(String id) {
        this();
        this.id = id;
    }

    public void cleanAfterLifecycle() {
        this.allRenderedPropertyPaths = Collections.synchronizedSet(new HashSet());
        this.addedCollectionObjects = Collections.synchronizedMap(new HashMap());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, ComponentPostMetadata> getComponentPostMetadataMap() {
        return this.componentPostMetadataMap;
    }

    public void setComponentPostMetadataMap(Map<String, ComponentPostMetadata> componentPostMetadataMap) {
        this.componentPostMetadataMap = componentPostMetadataMap;
    }

    public ComponentPostMetadata getComponentPostMetadata(String componentId) {
        ComponentPostMetadata componentPostMetadata = null;
        if (this.componentPostMetadataMap != null && this.componentPostMetadataMap.containsKey(componentId)) {
            componentPostMetadata = this.componentPostMetadataMap.get(componentId);
        }
        return componentPostMetadata;
    }

    public void addComponentPostData(Component component, String key, Object value) {
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null for adding post data");
        }
        this.addComponentPostData(component.getId(), key, value);
    }

    public void addComponentPostData(String componentId, String key, Object value) {
        if (value == null) {
            return;
        }
        ComponentPostMetadata componentPostMetadata = this.initializeComponentPostMetadata(componentId);
        componentPostMetadata.addData(key, value);
    }

    public Object getComponentPostData(String componentId, String key) {
        ComponentPostMetadata componentPostMetadata = this.getComponentPostMetadata(componentId);
        if (componentPostMetadata != null) {
            return componentPostMetadata.getData(key);
        }
        return null;
    }

    public ComponentPostMetadata initializeComponentPostMetadata(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Component must not be null to initialize post metadata");
        }
        return this.initializeComponentPostMetadata(component.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentPostMetadata initializeComponentPostMetadata(String componentId) {
        ComponentPostMetadata componentPostMetadata;
        if (this.componentPostMetadataMap == null) {
            ViewPostMetadata viewPostMetadata = this;
            synchronized (viewPostMetadata) {
                if (this.componentPostMetadataMap == null) {
                    this.componentPostMetadataMap = new HashMap<String, ComponentPostMetadata>();
                }
            }
        }
        if (this.componentPostMetadataMap.containsKey(componentId)) {
            componentPostMetadata = this.componentPostMetadataMap.get(componentId);
        } else {
            Map<String, ComponentPostMetadata> map = this.componentPostMetadataMap;
            synchronized (map) {
                componentPostMetadata = new ComponentPostMetadata(componentId);
                this.componentPostMetadataMap.put(componentId, componentPostMetadata);
            }
        }
        return componentPostMetadata;
    }

    public ComponentPostMetadata getComponentPostMetadataForPath(String path) {
        if (this.componentPostMetadataMap == null) {
            return null;
        }
        Collection<ComponentPostMetadata> componentPostMetadataCollection = this.componentPostMetadataMap.values();
        for (ComponentPostMetadata metadata : componentPostMetadataCollection) {
            if (metadata.getPath() == null || !metadata.getPath().equals(path)) continue;
            return metadata;
        }
        return null;
    }

    public Map<String, PropertyEditor> getFieldPropertyEditors() {
        return this.fieldPropertyEditors;
    }

    public void addFieldPropertyEditor(String propertyPath, PropertyEditor propertyEditor) {
        if (this.fieldPropertyEditors == null) {
            this.fieldPropertyEditors = new HashMap<String, PropertyEditor>();
        }
        this.fieldPropertyEditors.put(propertyPath, propertyEditor);
    }

    public Map<String, PropertyEditor> getSecureFieldPropertyEditors() {
        return this.secureFieldPropertyEditors;
    }

    public void addSecureFieldPropertyEditor(String propertyPath, PropertyEditor propertyEditor) {
        if (this.secureFieldPropertyEditors == null) {
            this.secureFieldPropertyEditors = new HashMap<String, PropertyEditor>();
        }
        this.secureFieldPropertyEditors.put(propertyPath, propertyEditor);
    }

    public Set<String> getInputFieldIds() {
        return this.inputFieldIds;
    }

    public void setInputFieldIds(Set<String> inputFieldIds) {
        this.inputFieldIds = inputFieldIds;
    }

    public Set<String> getAllRenderedPropertyPaths() {
        return this.allRenderedPropertyPaths;
    }

    public void setAllRenderedPropertyPaths(Set<String> allRenderedPropertyPaths) {
        this.allRenderedPropertyPaths = allRenderedPropertyPaths;
    }

    public void addRenderedPropertyPath(String propertyPath) {
        if (this.allRenderedPropertyPaths == null) {
            this.allRenderedPropertyPaths = new HashSet<String>();
        }
        this.allRenderedPropertyPaths.add(propertyPath);
    }

    public Map<String, List<Object>> getAddedCollectionObjects() {
        return this.addedCollectionObjects;
    }

    public void setAddedCollectionObjects(Map<String, List<Object>> addedCollectionObjects) {
        this.addedCollectionObjects = addedCollectionObjects;
    }

    public Map<String, Map<String, Object>> getLookupCriteria() {
        return this.lookupCriteria;
    }

    public void setLookupCriteria(Map<String, Map<String, Object>> lookupCriteria) {
        this.lookupCriteria = lookupCriteria;
    }

    public Set<String> getAccessibleBindingPaths() {
        return this.accessibleBindingPaths;
    }

    public void setAccessibleBindingPaths(Set<String> accessibleBindingPaths) {
        this.accessibleBindingPaths = accessibleBindingPaths;
    }

    public void addAccessibleBindingPath(String accessibleBindingPath) {
        if (this.accessibleBindingPaths == null) {
            this.accessibleBindingPaths = Collections.synchronizedSet(new HashSet());
        }
        this.accessibleBindingPaths.add(accessibleBindingPath);
    }

    public Set<String> getAccessibleMethodToCalls() {
        return this.accessibleMethodToCalls;
    }

    public void setAccessibleMethodToCalls(Set<String> accessibleMethodToCalls) {
        this.accessibleMethodToCalls = accessibleMethodToCalls;
    }

    public void addAccessibleMethodToCall(String methodToCall) {
        if (this.accessibleMethodToCalls == null) {
            this.accessibleMethodToCalls = Collections.synchronizedSet(new HashSet());
        }
        this.accessibleMethodToCalls.add(methodToCall);
    }

    public Set<String> getAvailableMethodToCalls() {
        return this.availableMethodToCalls;
    }

    public void setAvailableMethodToCalls(Set<String> availableMethodToCalls) {
        this.availableMethodToCalls = availableMethodToCalls;
    }

    public void addAvailableMethodToCall(String methodToCall) {
        if (this.availableMethodToCalls == null) {
            this.availableMethodToCalls = Collections.synchronizedSet(new HashSet());
        }
        this.availableMethodToCalls.add(methodToCall);
    }

    public PropertyEditor getFieldEditor(String propertyName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to find property editor for property '" + propertyName + "'"));
        }
        PropertyEditor propertyEditor = null;
        boolean requiresEncryption = false;
        if (this.fieldPropertyEditors != null && this.fieldPropertyEditors.containsKey(propertyName)) {
            propertyEditor = this.fieldPropertyEditors.get(propertyName);
        } else if (this.secureFieldPropertyEditors != null && this.secureFieldPropertyEditors.containsKey(propertyName)) {
            propertyEditor = this.secureFieldPropertyEditors.get(propertyName);
            requiresEncryption = true;
        }
        if (propertyEditor != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Registering custom editor for property path '" + propertyName + "' and property editor class '" + propertyEditor.getClass().getName() + "'"));
            }
            if (requiresEncryption) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Enabling encryption for custom editor '" + propertyName + "' and property editor class '" + propertyEditor.getClass().getName() + "'"));
                }
                return new UifEncryptionPropertyEditorWrapper(propertyEditor);
            }
        }
        return propertyEditor;
    }
}

