/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.model;

import java.util.List;
import java.util.UUID;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.lifecycle.ApplyModelComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.modifier.ComponentModifier;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

public class EvaluateExpressionsTask
extends ViewLifecycleTaskBase<Component> {
    public EvaluateExpressionsTask() {
        super(Component.class);
    }

    public String adjustIdIfNecessary(LifecycleElement element) {
        ApplyModelComponentPhase phase = (ApplyModelComponentPhase)this.getElementState();
        String id = element.getId();
        if (phase.visit(element)) {
            element.setId(id + '-' + UUID.randomUUID());
            boolean visitedAfter = phase.visit(element);
            assert (!visitedAfter);
        }
        return id;
    }

    @Override
    protected void performLifecycleTask() {
        LayoutManager layoutManager;
        List<ComponentModifier> componentModifiers;
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        View view = ViewLifecycle.getView();
        Component component = (Component)this.getElementState().getElement();
        List<PropertyReplacer> componentPropertyReplacers = component.getPropertyReplacers();
        if (componentPropertyReplacers != null) {
            for (PropertyReplacer propertyReplacer : componentPropertyReplacers) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, propertyReplacer, component.getContext());
            }
        }
        if ((componentModifiers = component.getComponentModifiers()) != null) {
            for (ComponentModifier modifier : componentModifiers) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, modifier, component.getContext());
            }
        }
        expressionEvaluator.evaluateExpressionsOnConfigurable(view, component, component.getContext());
        ComponentSecurity componentSecurity = component.getComponentSecurity();
        expressionEvaluator.evaluateExpressionsOnConfigurable(view, componentSecurity, component.getContext());
        if (component instanceof DataBinding) {
            BindingInfo bindingInfo = ((DataBinding)component).getBindingInfo();
            expressionEvaluator.evaluateExpressionsOnConfigurable(view, bindingInfo, component.getContext());
        }
        if (component instanceof Container && (layoutManager = ((Container)component).getLayoutManager()) != null) {
            expressionEvaluator.evaluateExpressionsOnConfigurable(view, layoutManager, layoutManager.getContext());
            this.adjustIdIfNecessary(layoutManager);
        }
    }
}

