/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.RequestParameter;
import org.kuali.rice.krad.uif.view.DocumentView;

@BeanTag(name="maintenanceView", parent="Uif-MaintenanceView")
public class MaintenanceDocumentView
extends DocumentView {
    private static final long serialVersionUID = -3382802967703882341L;
    private static final Logger LOG = Logger.getLogger(MaintenanceDocumentView.class);
    private Class<?> dataObjectClassName;
    private String docTypeName;
    private String oldObjectBindingPath;
    @RequestParameter
    private String maintenanceAction;

    public MaintenanceDocumentView() {
        this.setViewTypeName(UifConstants.ViewType.MAINTENANCE);
    }

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        this.getObjectPathToConcreteClassMapping().put(this.getDefaultBindingObjectPath(), this.getDataObjectClassName());
        this.getObjectPathToConcreteClassMapping().put(this.getOldObjectBindingPath(), this.getDataObjectClassName());
    }

    @Override
    protected MaintenanceDocumentEntry getDocumentEntryForView() {
        MaintenanceDocumentEntry documentEntry = null;
        String docTypeName = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentTypeName(this.getDataObjectClassName());
        if (StringUtils.isNotBlank((String)docTypeName)) {
            documentEntry = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentEntry(docTypeName);
        }
        if (documentEntry == null) {
            throw new RuntimeException("Unable to find maintenance document entry for data object class: " + this.getDataObjectClassName().getName());
        }
        return documentEntry;
    }

    @BeanTagAttribute
    public Class<?> getDataObjectClassName() {
        return this.dataObjectClassName;
    }

    public void setDataObjectClassName(Class<?> dataObjectClassName) {
        this.dataObjectClassName = dataObjectClassName;
    }

    @BeanTagAttribute(name="docTypeName")
    public String getDocTypeName() {
        return this.docTypeName;
    }

    public void setDocTypeName(String docTypeName) {
        this.docTypeName = docTypeName;
    }

    @BeanTagAttribute
    public String getOldObjectBindingPath() {
        return this.oldObjectBindingPath;
    }

    public void setOldObjectBindingPath(String oldObjectBindingPath) {
        this.oldObjectBindingPath = oldObjectBindingPath;
    }

    @BeanTagAttribute
    public String getMaintenanceAction() {
        return this.maintenanceAction;
    }

    public void setMaintenanceAction(String maintenanceAction) {
        this.maintenanceAction = maintenanceAction;
    }
}

