/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DataObjectAuthorizerBase;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.ComponentSecurity;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.DataFieldSecurity;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldSecurity;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.RequestAuthorizationCache;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewAuthorizer;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.widget.Widget;
import org.kuali.rice.krad.util.KRADUtils;

@BeanTag(name="viewAuthorizer")
public class ViewAuthorizerBase
extends DataObjectAuthorizerBase
implements ViewAuthorizer {
    private static final long serialVersionUID = -2687378084630965412L;
    private static final Logger LOG = Logger.getLogger(ViewAuthorizerBase.class);
    private ConfigurationService configurationService;
    private RequestAuthorizationCache requestAuthorizationCache;

    @Override
    public Set<String> getActionFlags(View view, ViewModel model, Person user, Set<String> actions) {
        if (actions.contains("canEdit") && !this.canEditView(view, model, user)) {
            actions.remove("canEdit");
        }
        return actions;
    }

    @Override
    public Set<String> getEditModes(View view, ViewModel model, Person user, Set<String> editModes) {
        HashSet<String> unauthorizedEditModes = new HashSet<String>();
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        for (String editMode : editModes) {
            boolean authorized;
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("editMode", editMode);
            additionalPermissionDetails.put("viewId", view.getId());
            boolean exists = this.permissionExistsByTemplate(dataObjectForContext, "KR-KRAD", "Use View", additionalPermissionDetails);
            if (!exists || (authorized = this.isAuthorizedByTemplate(dataObjectForContext, "KR-KRAD", "Use View", user.getPrincipalId(), additionalPermissionDetails, null))) continue;
            unauthorizedEditModes.add(editMode);
        }
        editModes.removeAll(unauthorizedEditModes);
        return editModes;
    }

    @Override
    public boolean canOpenView(View view, ViewModel model, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", view.getNamespaceCode());
        additionalPermissionDetails.put("viewId", model.getViewId());
        if (this.permissionExistsByTemplate(model, "KR-KRAD", "Open View", additionalPermissionDetails)) {
            return this.isAuthorizedByTemplate(model, "KR-KRAD", "Open View", user.getPrincipalId(), additionalPermissionDetails, null);
        }
        return true;
    }

    @Override
    public boolean canEditView(View view, ViewModel model, Person user) {
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("namespaceCode", view.getNamespaceCode());
        additionalPermissionDetails.put("viewId", model.getViewId());
        if (this.permissionExistsByTemplate(model, "KR-KRAD", "Edit View", additionalPermissionDetails)) {
            return this.isAuthorizedByTemplate(model, "KR-KRAD", "Edit View", user.getPrincipalId(), additionalPermissionDetails, null);
        }
        return true;
    }

    @Override
    public boolean canUnmaskField(View view, ViewModel model, DataField field, String propertyName, Person user) {
        if (field.getDataFieldSecurity() == null) {
            return true;
        }
        AttributeSecurity attributeSecurity = field.getDataFieldSecurity().getAttributeSecurity();
        if (attributeSecurity == null || !attributeSecurity.isMask()) {
            return true;
        }
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        Map<Object, Object> permissionDetails = new HashMap();
        permissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(dataObjectForContext.getClass());
        permissionDetails.put("propertyName", propertyName);
        if (field.getComponentSecurity().getAdditionalPermissionDetails() != null) {
            permissionDetails.putAll(field.getComponentSecurity().getAdditionalPermissionDetails());
        }
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (field.getComponentSecurity().getAdditionalRoleQualifiers() != null) {
            roleQualifications.putAll(field.getComponentSecurity().getAdditionalRoleQualifiers());
        }
        return this.isAuthorizedByTemplate(dataObjectForContext, "KR-NS", "Full Unmask Field", user.getPrincipalId(), permissionDetails, roleQualifications);
    }

    @Override
    public boolean canPartialUnmaskField(View view, ViewModel model, DataField field, String propertyName, Person user) {
        if (field.getDataFieldSecurity() == null) {
            return true;
        }
        AttributeSecurity attributeSecurity = field.getDataFieldSecurity().getAttributeSecurity();
        if (attributeSecurity == null || !attributeSecurity.isPartialMask()) {
            return true;
        }
        if (this.isNonProductionEnvAndUnmaskingTurnedOff()) {
            return false;
        }
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        Map<Object, Object> permissionDetails = new HashMap();
        permissionDetails = KRADUtils.getNamespaceAndComponentSimpleName(dataObjectForContext.getClass());
        permissionDetails.put("propertyName", propertyName);
        if (field.getComponentSecurity().getAdditionalPermissionDetails() != null) {
            permissionDetails.putAll(field.getComponentSecurity().getAdditionalPermissionDetails());
        }
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (field.getComponentSecurity().getAdditionalRoleQualifiers() != null) {
            roleQualifications.putAll(field.getComponentSecurity().getAdditionalRoleQualifiers());
        }
        return this.isAuthorizedByTemplate(dataObjectForContext, "KR-NS", "Partial Unmask Field", user.getPrincipalId(), permissionDetails, roleQualifications);
    }

    @Override
    public boolean canEditField(View view, ViewModel model, Field field, String propertyName, Person user) {
        ComponentSecurity componentSecurity = field.getComponentSecurity();
        if (componentSecurity == null) {
            return true;
        }
        if (componentSecurity.isEditAuthz() == null && !this.isDataFieldAttributeSecurityHide(field)) {
            return true;
        }
        if (componentSecurity.isEditAuthz() != null && !componentSecurity.isEditAuthz().booleanValue()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, field, model, "Edit Field", user, null, null, false);
    }

    @Override
    public boolean canViewField(View view, ViewModel model, Field field, String propertyName, Person user) {
        ComponentSecurity componentSecurity = field.getComponentSecurity();
        if (componentSecurity == null) {
            return true;
        }
        if (componentSecurity.isViewAuthz() == null && !this.isDataFieldAttributeSecurityHide(field)) {
            return true;
        }
        if (componentSecurity.isViewAuthz() != null && !componentSecurity.isViewAuthz().booleanValue()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, field, model, "View Field", user, null, null, false);
    }

    @Override
    public boolean canEditGroup(View view, ViewModel model, Group group, String groupId, Person user) {
        ComponentSecurity componentSecurity = group.getComponentSecurity();
        if (componentSecurity == null) {
            return true;
        }
        if (componentSecurity.isEditAuthz() == null || !componentSecurity.isEditAuthz().booleanValue()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, group, model, "Edit Group", user, null, null, false);
    }

    @Override
    public boolean canViewGroup(View view, ViewModel model, Group group, String groupId, Person user) {
        ComponentSecurity componentSecurity = group.getComponentSecurity();
        if (componentSecurity == null) {
            return true;
        }
        if (componentSecurity.isViewAuthz() == null || !componentSecurity.isViewAuthz().booleanValue()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, group, model, "View Group", user, null, null, false);
    }

    @Override
    public boolean canEditWidget(View view, ViewModel model, Widget widget, String widgetId, Person user) {
        ComponentSecurity componentSecurity = widget.getComponentSecurity();
        if (componentSecurity == null) {
            return true;
        }
        if (componentSecurity.isEditAuthz() == null || !componentSecurity.isEditAuthz().booleanValue()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, widget, model, "Edit Widget", user, null, null, false);
    }

    @Override
    public boolean canViewWidget(View view, ViewModel model, Widget widget, String widgetId, Person user) {
        ComponentSecurity componentSecurity = widget.getComponentSecurity();
        if (componentSecurity == null) {
            return true;
        }
        if (componentSecurity.isViewAuthz() == null || !componentSecurity.isViewAuthz().booleanValue()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, widget, model, "View Widget", user, null, null, false);
    }

    @Override
    public boolean canPerformAction(View view, ViewModel model, Action action, String actionEvent, String actionId, Person user) {
        if (action.getActionSecurity() == null || !action.getActionSecurity().isPerformActionAuthz()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)actionEvent)) {
            additionalPermissionDetails.put("actionEvent", actionEvent);
        }
        return this.isAuthorizedByTemplate(view, action, model, "Perform Action", user, additionalPermissionDetails, null, false);
    }

    @Override
    public boolean canEditLine(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Person user) {
        if (collectionGroup.getCollectionGroupSecurity() == null || !collectionGroup.getCollectionGroupSecurity().isEditLineAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, collectionGroup, model, "Edit Line", user, null, null, false);
    }

    @Override
    public boolean canViewLine(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Person user) {
        if (collectionGroup.getCollectionGroupSecurity() == null || !collectionGroup.getCollectionGroupSecurity().isViewLineAuthz()) {
            return true;
        }
        return this.isAuthorizedByTemplate(view, collectionGroup, model, "View Line", user, null, null, false);
    }

    @Override
    public boolean canEditLineField(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Field field, String propertyName, Person user) {
        FieldSecurity fieldSecurity = field.getFieldSecurity();
        if (fieldSecurity == null) {
            return true;
        }
        if (fieldSecurity.isEditInLineAuthz() == null && !this.isDataFieldAttributeSecurityHide(field)) {
            return true;
        }
        if (fieldSecurity.isEditInLineAuthz() != null && !fieldSecurity.isEditInLineAuthz().booleanValue()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("groupId", collectionGroup.getId());
        additionalPermissionDetails.put("collectionPropertyName", collectionGroup.getPropertyName());
        return this.isAuthorizedByTemplate(view, field, model, "Edit Line Field", user, additionalPermissionDetails, null, false);
    }

    @Override
    public boolean canViewLineField(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Field field, String propertyName, Person user) {
        FieldSecurity fieldSecurity = field.getFieldSecurity();
        if (fieldSecurity == null) {
            return true;
        }
        if (fieldSecurity.isViewInLineAuthz() == null && !this.isDataFieldAttributeSecurityHide(field)) {
            return true;
        }
        if (fieldSecurity.isViewInLineAuthz() != null && !fieldSecurity.isViewInLineAuthz().booleanValue()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("groupId", collectionGroup.getId());
        additionalPermissionDetails.put("collectionPropertyName", collectionGroup.getPropertyName());
        return this.isAuthorizedByTemplate(view, field, model, "View Line Field", user, additionalPermissionDetails, null, false);
    }

    @Override
    public boolean canPerformLineAction(View view, ViewModel model, CollectionGroup collectionGroup, String collectionPropertyName, Object line, Action action, String actionEvent, String actionId, Person user) {
        if (action.getActionSecurity() == null || !action.getActionSecurity().isPerformLineActionAuthz()) {
            return true;
        }
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("groupId", collectionGroup.getId());
        additionalPermissionDetails.put("collectionPropertyName", collectionGroup.getPropertyName());
        if (StringUtils.isNotBlank((String)actionEvent)) {
            additionalPermissionDetails.put("actionEvent", actionEvent);
        }
        return this.isAuthorizedByTemplate(view, action, model, "Perform Line Action", user, additionalPermissionDetails, null, false);
    }

    protected Object getDataObjectContext(View view, ViewModel model) {
        Object defaultObject;
        ViewModel dataObject = model;
        if (StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) && (defaultObject = ObjectPropertyUtils.getPropertyValue(model, view.getDefaultBindingObjectPath())) != null) {
            dataObject = defaultObject;
        }
        return dataObject;
    }

    protected Map<String, String> getFieldPermissionDetails(View view, Object dataObject, Field field) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("fieldId", field.getId());
        if (field instanceof DataBinding) {
            permissionDetails.put("propertyName", ((DataBinding)((Object)field)).getPropertyName());
        }
        return permissionDetails;
    }

    protected Map<String, String> getGroupPermissionDetails(View view, Object dataObject, Group group) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("groupId", group.getId());
        if (group instanceof CollectionGroup) {
            permissionDetails.put("collectionPropertyName", ((CollectionGroup)group).getPropertyName());
        }
        return permissionDetails;
    }

    protected Map<String, String> getWidgetPermissionDetails(View view, Object dataObject, Widget widget) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("widgetId", widget.getId());
        return permissionDetails;
    }

    protected Map<String, String> getActionPermissionDetails(View view, Object dataObject, Action action) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("namespaceCode", view.getNamespaceCode());
        permissionDetails.put("viewId", view.getId());
        permissionDetails.put("fieldId", action.getId());
        return permissionDetails;
    }

    protected boolean isAuthorizedByTemplate(View view, Component component, ViewModel model, String permissionTemplateName, Person user, Map<String, String> additionalPermissionDetails, Map<String, String> additionalRoleQualifications, boolean checkPermissionExistence) {
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        HashMap<String, String> roleQualifications = new HashMap<String, String>();
        if (additionalPermissionDetails != null) {
            permissionDetails.putAll(additionalPermissionDetails);
        }
        if (additionalRoleQualifications != null) {
            roleQualifications.putAll(additionalRoleQualifications);
        }
        Object dataObjectForContext = this.getDataObjectContext(view, model);
        if (component instanceof Field) {
            permissionDetails.putAll(this.getFieldPermissionDetails(view, dataObjectForContext, (Field)component));
        } else if (component instanceof Group) {
            permissionDetails.putAll(this.getGroupPermissionDetails(view, dataObjectForContext, (Group)component));
        } else if (component instanceof Widget) {
            permissionDetails.putAll(this.getWidgetPermissionDetails(view, dataObjectForContext, (Widget)component));
        } else if (component instanceof Action) {
            permissionDetails.putAll(this.getActionPermissionDetails(view, dataObjectForContext, (Action)component));
        }
        ComponentSecurity componentSecurity = component.getComponentSecurity();
        if (componentSecurity != null) {
            if (StringUtils.isNotBlank((String)componentSecurity.getNamespaceAttribute())) {
                permissionDetails.put("namespaceCode", componentSecurity.getNamespaceAttribute());
            }
            if (StringUtils.isNotBlank((String)componentSecurity.getComponentAttribute())) {
                permissionDetails.put("componentName", componentSecurity.getComponentAttribute());
            }
            if (StringUtils.isNotBlank((String)componentSecurity.getIdAttribute())) {
                if (component instanceof Field) {
                    permissionDetails.put("fieldId", componentSecurity.getIdAttribute());
                } else if (component instanceof Group) {
                    permissionDetails.put("groupId", componentSecurity.getIdAttribute());
                } else if (component instanceof Widget) {
                    permissionDetails.put("widgetId", componentSecurity.getIdAttribute());
                }
            }
            if (componentSecurity.getAdditionalPermissionDetails() != null) {
                permissionDetails.putAll(componentSecurity.getAdditionalPermissionDetails());
            }
            if (componentSecurity.getAdditionalRoleQualifiers() != null) {
                roleQualifications.putAll(componentSecurity.getAdditionalRoleQualifiers());
            }
        }
        boolean result = true;
        if (!checkPermissionExistence || checkPermissionExistence && this.permissionExistsByTemplate(dataObjectForContext, "KR-KRAD", permissionTemplateName, permissionDetails)) {
            result = this.isAuthorizedByTemplate(dataObjectForContext, "KR-KRAD", permissionTemplateName, user.getPrincipalId(), permissionDetails, roleQualifications);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Performed permission check for: " + permissionTemplateName + " and got result: " + result));
            }
        }
        return result;
    }

    private boolean isNonProductionEnvAndUnmaskingTurnedOff() {
        return !this.getConfigurationService().getPropertyValueAsString("production.environment.code").equalsIgnoreCase(this.getConfigurationService().getPropertyValueAsString("environment")) && !this.getConfigurationService().getPropertyValueAsBoolean("enable.nonproduction.data.unmasking");
    }

    private boolean isDataFieldAttributeSecurityHide(Field field) {
        if (field instanceof DataField) {
            DataField dataField = (DataField)field;
            DataFieldSecurity dataFieldSecurity = dataField.getDataFieldSecurity();
            if (dataFieldSecurity == null) {
                return false;
            }
            return dataFieldSecurity.getAttributeSecurity() != null && dataFieldSecurity.getAttributeSecurity().isHide();
        }
        return false;
    }

    @BeanTagAttribute(name="configurationService", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            return CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected RequestAuthorizationCache getRequestAuthorizationCache() {
        return this.requestAuthorizationCache;
    }

    @Override
    public void setRequestAuthorizationCache(RequestAuthorizationCache requestAuthorizationCache) {
        this.requestAuthorizationCache = requestAuthorizationCache;
    }
}

