/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.bind;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.web.format.FormatException;

public class UifCurrencyEditor
extends PropertyEditorSupport
implements Serializable {
    private static final long serialVersionUID = 6692868638156609014L;
    private static Logger LOG = Logger.getLogger(UifCurrencyEditor.class);

    @Override
    public String getAsText() {
        Object obj = this.getValue();
        LOG.debug((Object)("format '" + obj + "'"));
        if (obj == null) {
            return null;
        }
        NumberFormat formatter = this.getCurrencyInstanceUsingParseBigDecimal();
        String string = null;
        try {
            Number number = (Number)obj;
            if (obj instanceof KualiInteger) {
                formatter.setMaximumFractionDigits(0);
            }
            string = formatter.format(number.doubleValue());
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("formatting", "error.currency", obj.toString(), (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new FormatException("formatting", "error.currency", obj.toString(), (Throwable)e);
        }
        return string;
    }

    private NumberFormat getCurrencyInstanceUsingParseBigDecimal() {
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).setParseBigDecimal(true);
        }
        return formatter;
    }

    @Override
    public void setAsText(String text) {
        this.setValue(this.convertToObject(text));
    }

    protected Object convertToObject(String text) {
        KualiDecimal value = null;
        LOG.debug((Object)("convertToObject '" + text + "'"));
        if (text != null) {
            text = text.trim();
            NumberFormat formatter = this.getCurrencyInstanceUsingParseBigDecimal();
            if (formatter instanceof DecimalFormat) {
                String prefix = ((DecimalFormat)formatter).getPositivePrefix();
                String suffix = ((DecimalFormat)formatter).getPositiveSuffix();
                if (!prefix.equals("") && !text.startsWith(prefix)) {
                    text = prefix.concat(text);
                }
                if (!suffix.equals("") && !text.endsWith(suffix)) {
                    text = text.concat(suffix);
                }
            }
            try {
                Number parsedNumber = formatter.parse(text);
                value = new KualiDecimal(parsedNumber.toString());
            }
            catch (NumberFormatException e) {
                throw new FormatException("parsing", "error.currency", text, (Throwable)e);
            }
            catch (ParseException e) {
                throw new FormatException("parsing", "error.currency", text, (Throwable)e);
            }
        }
        return value;
    }
}

