/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.util.SessionTransient;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.CsrfValidator;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.form.DialogResponse;
import org.kuali.rice.krad.web.form.HistoryFlow;
import org.kuali.rice.krad.web.form.HistoryManager;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.web.multipart.MultipartFile;

public class UifFormBase
implements ViewModel {
    private static final long serialVersionUID = 8432543267099454434L;
    @RequestAccessible
    protected String viewId;
    @RequestAccessible
    protected String viewName;
    @RequestAccessible
    protected UifConstants.ViewType viewTypeName;
    @RequestAccessible
    protected String pageId;
    @RequestAccessible
    protected String methodToCall;
    @RequestAccessible
    protected String formKey;
    @RequestAccessible
    @SessionTransient
    protected String requestedFormKey;
    @RequestAccessible
    protected String flowKey;
    protected String sessionId;
    protected int sessionTimeoutInterval;
    @SessionTransient
    protected HistoryFlow historyFlow;
    @SessionTransient
    protected HistoryManager historyManager;
    @RequestAccessible
    @SessionTransient
    protected String jumpToId;
    @SessionTransient
    protected String jumpToName;
    @RequestAccessible
    @SessionTransient
    protected String focusId;
    @RequestAccessible
    @SessionTransient
    protected boolean dirtyForm;
    protected String formPostUrl;
    protected String controllerMapping;
    @SessionTransient
    private String requestUrl;
    private Map<String, String[]> initialRequestParameters;
    protected String state;
    @RequestAccessible
    protected boolean renderedInDialog = false;
    @RequestAccessible
    protected boolean renderedInIframe = false;
    @SessionTransient
    protected String growlScript;
    @SessionTransient
    protected View view;
    protected ViewPostMetadata viewPostMetadata;
    protected Map<String, String> viewRequestParameters;
    protected List<String> readOnlyFieldsList = new ArrayList<String>();
    protected Map<String, Object> newCollectionLines;
    @RequestAccessible
    @SessionTransient
    protected String triggerActionId;
    @RequestAccessible
    @SessionTransient
    protected Map<String, String> actionParameters;
    protected Map<String, Object> clientStateForSyncing;
    @SessionTransient
    protected Map<String, Set<String>> selectedCollectionLines;
    protected Set<String> selectedLookupResultsCache;
    protected List<Object> addedCollectionItems;
    @SessionTransient
    protected MultipartFile attachmentFile;
    @RequestAccessible
    protected String returnLocation;
    @RequestAccessible
    protected String returnFormKey;
    @RequestAccessible
    @SessionTransient
    protected boolean ajaxRequest;
    @RequestAccessible
    @SessionTransient
    protected String ajaxReturnType;
    @SessionTransient
    private String requestJsonTemplate;
    @SessionTransient
    private boolean collectionPagingRequest;
    @RequestAccessible
    @SessionTransient
    protected String showDialogId;
    @RequestAccessible
    @SessionTransient
    protected String returnDialogId;
    @RequestAccessible
    @SessionTransient
    protected String returnDialogResponse;
    @RequestAccessible
    protected Map<String, String> dialogExplanations;
    protected Map<String, DialogResponse> dialogResponses;
    @SessionTransient
    protected boolean requestRedirected = false;
    @RequestAccessible
    @SessionTransient
    protected String updateComponentId;
    @SessionTransient
    private Component updateComponent;
    @RequestAccessible
    protected Map<String, Object> extensionData;
    protected boolean applyDefaultValues = true;
    protected boolean evaluateFlagsAndModes = true;
    protected Boolean canEditView;
    protected Map<String, Boolean> actionFlags;
    protected Map<String, Boolean> editModes;
    protected String csrfToken;
    protected HttpServletRequest request;
    private Object dialogDataObject;

    public UifFormBase() {
        this.viewRequestParameters = new HashMap<String, String>();
        this.newCollectionLines = new HashMap<String, Object>();
        this.actionParameters = new HashMap<String, String>();
        this.clientStateForSyncing = new HashMap<String, Object>();
        this.selectedCollectionLines = new HashMap<String, Set<String>>();
        this.selectedLookupResultsCache = new HashSet<String>();
        this.addedCollectionItems = new ArrayList<Object>();
        this.dialogExplanations = new HashMap<String, String>();
        this.dialogResponses = new HashMap<String, DialogResponse>();
        this.extensionData = new HashMap<String, Object>();
    }

    @Override
    public void preBind(HttpServletRequest request) {
        String requestedFormKey;
        String formKeyParam = request.getParameter("formKey");
        if (StringUtils.isNotBlank((String)formKeyParam)) {
            UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
            uifFormManager.updateFormWithSession(this, formKeyParam);
        }
        if (StringUtils.isNotBlank((String)(requestedFormKey = request.getParameter("requestedFormKey")))) {
            this.setRequestedFormKey(requestedFormKey);
        } else {
            this.setRequestedFormKey(formKeyParam);
        }
        String csrfToken = CsrfValidator.getSessionToken(request);
        this.setCsrfToken(csrfToken);
        this.request = request;
    }

    @Override
    public void postBind(HttpServletRequest request) {
        String clientStateJSON;
        UifFormManager uifFormManager = (UifFormManager)request.getSession().getAttribute("formManager");
        if (StringUtils.isBlank((String)this.formKey) || !uifFormManager.hasSessionForm(this.formKey)) {
            this.formKey = this.generateFormKey();
        }
        this.formPostUrl = request.getRequestURL().toString();
        this.controllerMapping = request.getPathInfo();
        if (request.getSession() != null) {
            this.sessionId = request.getSession().getId();
            this.sessionTimeoutInterval = request.getSession().getMaxInactiveInterval();
        }
        if (request.getParameterMap().containsKey("clientViewState") && StringUtils.isNotBlank((String)(clientStateJSON = request.getParameter("clientViewState")))) {
            clientStateJSON = StringUtils.replace((String)clientStateJSON, (String)"\\'", (String)"\"");
            clientStateJSON = StringUtils.replace((String)clientStateJSON, (String)"\\[", (String)"[");
            clientStateJSON = StringUtils.replace((String)clientStateJSON, (String)"\\]", (String)"]");
            clientStateJSON = StringUtils.replace((String)clientStateJSON, (String)"'", (String)"\"");
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.clientStateForSyncing = (Map)mapper.readValue(clientStateJSON, Map.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to decode client side state JSON: " + clientStateJSON, e);
            }
        }
        String requestUrl = KRADUtils.stripXSSPatterns(KRADUtils.getFullURL(request));
        this.setRequestUrl(requestUrl);
        String referer = request.getHeader("Referer");
        if (StringUtils.isBlank((String)referer) && StringUtils.isBlank((String)this.getReturnLocation())) {
            this.setReturnLocation("");
        } else if (StringUtils.isBlank((String)this.getReturnLocation())) {
            this.setReturnLocation(referer);
        }
        if (this.getInitialRequestParameters() == null) {
            HashMap<String, String[]> requestParams = new HashMap<String, String[]>();
            Enumeration names = request.getParameterNames();
            while (names != null && names.hasMoreElements()) {
                String name = KRADUtils.stripXSSPatterns((String)names.nextElement());
                String[] values = KRADUtils.stripXSSPatterns(request.getParameterValues(name));
                requestParams.put(name, values);
            }
            requestParams.remove("__login_user");
            this.setInitialRequestParameters(requestParams);
        }
        if (request.getParameter("readOnlyFields") != null) {
            String readOnlyFields = request.getParameter("readOnlyFields");
            this.setReadOnlyFieldsList(KRADUtils.convertStringParameterToList(readOnlyFields));
        }
        if (request.getParameter("returnFromDialog") != null) {
            String dialogExplanation = null;
            if (this.dialogExplanations != null && this.dialogExplanations.containsKey(this.returnDialogId)) {
                dialogExplanation = this.dialogExplanations.get(this.returnDialogId);
            }
            DialogResponse response = new DialogResponse(this.returnDialogId, this.returnDialogResponse, dialogExplanation);
            this.dialogResponses.put(this.returnDialogId, response);
        } else {
            this.dialogResponses = new HashMap<String, DialogResponse>();
        }
        Object historyManager = request.getSession().getAttribute("historyManager");
        if (historyManager != null && historyManager instanceof HistoryManager) {
            this.setHistoryManager((HistoryManager)historyManager);
            String flowKey = request.getParameter("flow");
            this.setFlowKey(flowKey);
        }
        this.pageId = KRADUtils.stripXSSPatterns(this.pageId);
        this.methodToCall = KRADUtils.stripXSSPatterns(this.methodToCall);
        this.formKey = KRADUtils.stripXSSPatterns(this.formKey);
        this.requestedFormKey = KRADUtils.stripXSSPatterns(this.requestedFormKey);
        this.flowKey = KRADUtils.stripXSSPatterns(this.flowKey);
        this.sessionId = KRADUtils.stripXSSPatterns(this.sessionId);
        this.formPostUrl = KRADUtils.stripXSSPatterns(this.formPostUrl);
        this.returnLocation = KRADUtils.stripXSSPatterns(this.returnLocation);
        this.returnFormKey = KRADUtils.stripXSSPatterns(this.returnFormKey);
        this.requestUrl = KRADUtils.stripXSSPatterns(this.requestUrl);
    }

    @Override
    public void preRender(HttpServletRequest request) {
        this.returnDialogId = null;
        this.returnDialogResponse = null;
        this.dialogExplanations = new HashMap<String, String>();
    }

    protected String generateFormKey() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }

    @Override
    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public UifConstants.ViewType getViewTypeName() {
        return this.viewTypeName;
    }

    @Override
    public void setViewTypeName(UifConstants.ViewType viewTypeName) {
        this.viewTypeName = viewTypeName;
    }

    @Override
    public String getPageId() {
        return this.pageId;
    }

    @Override
    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    @Override
    public String getFormPostUrl() {
        return this.formPostUrl;
    }

    @Override
    public void setFormPostUrl(String formPostUrl) {
        this.formPostUrl = formPostUrl;
    }

    public String getControllerMapping() {
        return this.controllerMapping;
    }

    public HistoryFlow getHistoryFlow() {
        return this.historyFlow;
    }

    public void setHistoryFlow(HistoryFlow historyFlow) {
        this.historyFlow = historyFlow;
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public void setHistoryManager(HistoryManager historyManager) {
        this.historyManager = historyManager;
    }

    public String getFlowKey() {
        return this.flowKey;
    }

    public void setFlowKey(String flowKey) {
        this.flowKey = flowKey;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Map<String, String[]> getInitialRequestParameters() {
        return this.initialRequestParameters;
    }

    public void setInitialRequestParameters(Map<String, String[]> requestParameters) {
        this.initialRequestParameters = requestParameters;
    }

    public String getReturnLocation() {
        return this.returnLocation;
    }

    public void setReturnLocation(String returnLocation) {
        this.returnLocation = returnLocation;
    }

    public String getReturnFormKey() {
        return this.returnFormKey;
    }

    public void setReturnFormKey(String returnFormKey) {
        this.returnFormKey = returnFormKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getSessionTimeoutInterval() {
        return this.sessionTimeoutInterval;
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    @Override
    public Map<String, String> getViewRequestParameters() {
        return this.viewRequestParameters;
    }

    @Override
    public void setViewRequestParameters(Map<String, String> viewRequestParameters) {
        this.viewRequestParameters = viewRequestParameters;
    }

    @Override
    public List<String> getReadOnlyFieldsList() {
        return this.readOnlyFieldsList;
    }

    @Override
    public void setReadOnlyFieldsList(List<String> readOnlyFieldsList) {
        this.readOnlyFieldsList = readOnlyFieldsList;
    }

    @Override
    public Map<String, Object> getNewCollectionLines() {
        return this.newCollectionLines;
    }

    @Override
    public void setNewCollectionLines(Map<String, Object> newCollectionLines) {
        this.newCollectionLines = newCollectionLines;
    }

    @Override
    public String getTriggerActionId() {
        return this.triggerActionId;
    }

    @Override
    public void setTriggerActionId(String triggerActionId) {
        this.triggerActionId = triggerActionId;
    }

    @Override
    public Map<String, String> getActionParameters() {
        return this.actionParameters;
    }

    public Properties getActionParametersAsProperties() {
        return KRADUtils.convertMapToProperties(this.actionParameters);
    }

    @Override
    public void setActionParameters(Map<String, String> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public String getActionParamaterValue(String actionParameterName) {
        if (this.actionParameters != null && this.actionParameters.containsKey(actionParameterName)) {
            return this.actionParameters.get(actionParameterName);
        }
        return "";
    }

    public String getActionEvent() {
        if (this.actionParameters != null && this.actionParameters.containsKey("actionEvent")) {
            return this.actionParameters.get("actionEvent");
        }
        return "";
    }

    @Override
    public Map<String, Object> getClientStateForSyncing() {
        return this.clientStateForSyncing;
    }

    public void setClientStateForSyncing(Map<String, Object> clientStateForSyncing) {
        this.clientStateForSyncing = clientStateForSyncing;
    }

    @Override
    public Map<String, Set<String>> getSelectedCollectionLines() {
        return this.selectedCollectionLines;
    }

    @Override
    public void setSelectedCollectionLines(Map<String, Set<String>> selectedCollectionLines) {
        this.selectedCollectionLines = selectedCollectionLines;
    }

    public Set<String> getSelectedLookupResultsCache() {
        return this.selectedLookupResultsCache;
    }

    public void setSelectedLookupResultsCache(Set<String> selectedLookupResultsCache) {
        this.selectedLookupResultsCache = selectedLookupResultsCache;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getRequestedFormKey() {
        return this.requestedFormKey;
    }

    public void setRequestedFormKey(String requestedFormKey) {
        this.requestedFormKey = requestedFormKey;
    }

    public boolean isRequestRedirected() {
        return this.requestRedirected;
    }

    public void setRequestRedirected(boolean requestRedirected) {
        this.requestRedirected = requestRedirected;
    }

    public MultipartFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(MultipartFile attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    @Override
    public String getUpdateComponentId() {
        return this.updateComponentId;
    }

    @Override
    public void setUpdateComponentId(String updateComponentId) {
        this.updateComponentId = updateComponentId;
    }

    @Override
    public Component getUpdateComponent() {
        return this.updateComponent;
    }

    @Override
    public void setUpdateComponent(Component updateComponent) {
        this.updateComponent = updateComponent;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void setView(View view) {
        this.view = view;
    }

    @Override
    public ViewHelperService getViewHelperService() {
        Class viewHelperServiceClass;
        if (this.getView() != null && this.getView().getViewHelperService() != null) {
            return this.getView().getViewHelperService();
        }
        String viewId = this.getViewId();
        if (StringUtils.isBlank((String)viewId) && this.getView() != null) {
            viewId = this.getView().getId();
        }
        if (StringUtils.isBlank((String)viewId)) {
            return null;
        }
        ViewHelperService viewHelperService = (ViewHelperService)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBeanProperty(viewId, "viewHelperService");
        if (viewHelperService == null && (viewHelperServiceClass = (Class)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBeanProperty(viewId, "viewHelperServiceClass")) != null) {
            try {
                viewHelperService = (ViewHelperService)viewHelperServiceClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate view helper class: " + viewHelperServiceClass, e);
            }
        }
        return viewHelperService;
    }

    @Override
    public ViewPostMetadata getViewPostMetadata() {
        return this.viewPostMetadata;
    }

    @Override
    public void setViewPostMetadata(ViewPostMetadata viewPostMetadata) {
        this.viewPostMetadata = viewPostMetadata;
    }

    protected ViewService getViewService() {
        return KRADServiceLocatorWeb.getViewService();
    }

    public String getJumpToId() {
        return this.jumpToId;
    }

    public void setJumpToId(String jumpToId) {
        this.jumpToId = jumpToId;
    }

    public String getJumpToName() {
        return this.jumpToName;
    }

    public void setJumpToName(String jumpToName) {
        this.jumpToName = jumpToName;
    }

    public String getFocusId() {
        return this.focusId;
    }

    public void setFocusId(String focusId) {
        this.focusId = focusId;
    }

    public boolean isDirtyForm() {
        return this.dirtyForm;
    }

    public void setDirtyForm(boolean dirtyForm) {
        this.dirtyForm = dirtyForm;
    }

    public void setDirtyForm(String dirtyForm) {
        if (dirtyForm != null) {
            this.dirtyForm = Boolean.parseBoolean(dirtyForm);
        }
    }

    public boolean isRenderedInDialog() {
        return this.renderedInDialog;
    }

    public void setRenderedInDialog(boolean renderedInDialog) {
        this.renderedInDialog = renderedInDialog;
    }

    public boolean isRenderedInIframe() {
        return this.renderedInIframe;
    }

    public void setRenderedInIframe(boolean renderedInIframe) {
        this.renderedInIframe = renderedInIframe;
    }

    @Override
    public boolean isApplyDefaultValues() {
        return this.applyDefaultValues;
    }

    @Override
    public void setApplyDefaultValues(boolean applyDefaultValues) {
        this.applyDefaultValues = applyDefaultValues;
    }

    @Override
    public boolean isEvaluateFlagsAndModes() {
        return this.evaluateFlagsAndModes;
    }

    @Override
    public void setEvaluateFlagsAndModes(boolean evaluateFlagsAndModes) {
        this.evaluateFlagsAndModes = evaluateFlagsAndModes;
    }

    @Override
    public Boolean isCanEditView() {
        return this.canEditView;
    }

    @Override
    public void setCanEditView(Boolean canEditView) {
        this.canEditView = canEditView;
    }

    @Override
    public Map<String, Boolean> getActionFlags() {
        return this.actionFlags;
    }

    @Override
    public void setActionFlags(Map<String, Boolean> actionFlags) {
        this.actionFlags = actionFlags;
    }

    @Override
    public Map<String, Boolean> getEditModes() {
        return this.editModes;
    }

    @Override
    public void setEditModes(Map<String, Boolean> editModes) {
        this.editModes = editModes;
    }

    @Override
    public String getGrowlScript() {
        return this.growlScript;
    }

    @Override
    public void setGrowlScript(String growlScript) {
        this.growlScript = growlScript;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public boolean isAjaxRequest() {
        return this.ajaxRequest;
    }

    @Override
    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    @Override
    public String getAjaxReturnType() {
        return this.ajaxReturnType;
    }

    @Override
    public void setAjaxReturnType(String ajaxReturnType) {
        this.ajaxReturnType = ajaxReturnType;
    }

    @Override
    public boolean isUpdateComponentRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
    }

    @Override
    public boolean isUpdateDialogRequest() {
        return this.isAjaxRequest() && StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATEDIALOG.getKey());
    }

    @Override
    public boolean isUpdatePageRequest() {
        return StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATEPAGE.getKey());
    }

    @Override
    public boolean isUpdateNoneRequest() {
        return StringUtils.isNotBlank((String)this.getAjaxReturnType()) && this.getAjaxReturnType().equals(UifConstants.AjaxReturnTypes.UPDATENONE.getKey());
    }

    @Override
    public boolean isJsonRequest() {
        return StringUtils.isNotBlank((String)this.getRequestJsonTemplate());
    }

    @Override
    public String getRequestJsonTemplate() {
        return this.requestJsonTemplate;
    }

    @Override
    public void setRequestJsonTemplate(String requestJsonTemplate) {
        this.requestJsonTemplate = requestJsonTemplate;
    }

    @Override
    public boolean isCollectionPagingRequest() {
        return this.collectionPagingRequest;
    }

    @Override
    public void setCollectionPagingRequest(boolean collectionPagingRequest) {
        this.collectionPagingRequest = collectionPagingRequest;
    }

    public String getShowDialogId() {
        return this.showDialogId;
    }

    public void setShowDialogId(String dialogId) {
        this.showDialogId = dialogId;
    }

    public String getReturnDialogId() {
        return this.returnDialogId;
    }

    public void setReturnDialogId(String returnDialogId) {
        this.returnDialogId = returnDialogId;
    }

    public String getReturnDialogResponse() {
        return this.returnDialogResponse;
    }

    public void setReturnDialogResponse(String returnDialogResponse) {
        this.returnDialogResponse = returnDialogResponse;
    }

    @Override
    public Map<String, String> getDialogExplanations() {
        return this.dialogExplanations;
    }

    @Override
    public void setDialogExplanations(Map<String, String> dialogExplanations) {
        this.dialogExplanations = dialogExplanations;
    }

    @Override
    public Map<String, DialogResponse> getDialogResponses() {
        return this.dialogResponses;
    }

    @Override
    public DialogResponse getDialogResponse(String dialogId) {
        if (this.dialogResponses != null && this.dialogResponses.containsKey(dialogId)) {
            return this.dialogResponses.get(dialogId);
        }
        return null;
    }

    @Override
    public void setDialogResponses(Map<String, DialogResponse> dialogResponses) {
        this.dialogResponses = dialogResponses;
    }

    @Override
    public Map<String, Object> getExtensionData() {
        return this.extensionData;
    }

    @Override
    public void setExtensionData(Map<String, Object> extensionData) {
        this.extensionData = extensionData;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public List getAddedCollectionItems() {
        return this.addedCollectionItems;
    }

    public void setAddedCollectionItems(List addedCollectionItems) {
        this.addedCollectionItems = addedCollectionItems;
    }

    public boolean isAddedCollectionItem(Object item) {
        return this.addedCollectionItems.contains(item);
    }

    public Object getDialogDataObject() {
        return this.dialogDataObject;
    }

    public void setDialogDataObject(Object dataObject) {
        this.dialogDataObject = dataObject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [viewId=").append(this.viewId).append(", viewName=").append(this.viewName).append(", viewTypeName=").append((Object)this.viewTypeName).append(", pageId=").append(this.pageId).append(", methodToCall=").append(this.methodToCall).append(", formKey=").append(this.formKey).append(", requestedFormKey=").append(this.requestedFormKey).append("]");
        return builder.toString();
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    public void setCsrfToken(String csrfToken) {
        this.csrfToken = csrfToken;
    }
}

