/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class TimestampPatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.timestamp";
    private AttributeDefinition timestampDefinition;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private String validTimestamp;
    private String validTimestamp1;
    private String invalidTimestampEmpty;
    private String invalidTimestamp;
    private String invalidTimestamp1;
    private String invalidTimestamp2;
    private String invalidTimestamp3;
    private ConfigurationBasedRegexPatternConstraint timestampPatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.timestamp");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.validTimestamp = "2011-07-28 15:10:36.300";
        this.validTimestamp1 = "1936-07-28 15:10:36.9999999";
        this.invalidTimestampEmpty = "";
        this.invalidTimestamp = "2011/07/28 15:10:36.300";
        this.invalidTimestamp1 = "2011-07-28 15:10:36.300 IST";
        this.invalidTimestamp2 = "2011-07-28";
        this.invalidTimestamp3 = "28-07-2011 15:10:36.300";
        this.timestampPatternConstraint = new ConfigurationBasedRegexPatternConstraint();
        this.timestampPatternConstraint.setMessageKey("validate.dummykey");
        this.timestampPatternConstraint.setValidationMessageParams(new ArrayList());
        this.timestampPatternConstraint.setValue(regex);
        this.timestampDefinition = new AttributeDefinition();
        this.timestampDefinition.setName("timestamp");
        this.timestampDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.timestampPatternConstraint);
    }

    @Test
    public void testValueInvalidTimestampEmpty() {
        ConstraintValidationResult result = this.process(this.invalidTimestampEmpty, "timestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidTimestamp() {
        ConstraintValidationResult result = this.process(this.validTimestamp, "timestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidTimestamp1() {
        ConstraintValidationResult result = this.process(this.validTimestamp1, "Mtimestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidTimestamp() {
        ConstraintValidationResult result = this.process(this.invalidTimestamp, "timestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidTimestamp1() {
        ConstraintValidationResult result = this.process(this.invalidTimestamp1, "timestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidTimestamp2() {
        ConstraintValidationResult result = this.process(this.invalidTimestamp2, "timestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidTimestamp3() {
        ConstraintValidationResult result = this.process(this.invalidTimestamp3, "timestamp", (ValidCharactersConstraint)this.timestampPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", attributeName, this.timestampDefinition);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

