/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.PrerequisiteConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.PrerequisiteConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class PrerequisiteConstraintProcessorTest {
    private AttributeDefinition street1Definition;
    private AttributeDefinition street2Definition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private PrerequisiteConstraintProcessor processor;
    private Address street1PostalCodeCityStateAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "", "USA", null);
    private Address noStreet1PostalCodeAddress = new Address("", "Suite 800", "Washington", "DC", "", "USA", null);
    private Address noStreet1CityStateAddress = new Address("", "Suite 800", "", "", "12340", "USA", null);
    private Address noStreet2Address = new Address("893 Presidential Ave", null, "Washington", "DC", "12340", "USA", null);
    private PrerequisiteConstraint street1Constraint;
    private PrerequisiteConstraint cityConstraint;
    private PrerequisiteConstraint stateConstraint;

    @Before
    public void setUp() throws Exception {
        this.processor = new PrerequisiteConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        this.street1Constraint = new PrerequisiteConstraint();
        this.street1Constraint.setPropertyName("street1");
        this.cityConstraint = new PrerequisiteConstraint();
        this.cityConstraint.setPropertyName("city");
        this.stateConstraint = new PrerequisiteConstraint();
        this.stateConstraint.setPropertyName("state");
        ArrayList<PrerequisiteConstraint> prerequisiteConstraints = new ArrayList<PrerequisiteConstraint>();
        prerequisiteConstraints.add(this.street1Constraint);
        prerequisiteConstraints.add(this.cityConstraint);
        prerequisiteConstraints.add(this.stateConstraint);
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.street1Definition = new AttributeDefinition();
        this.street1Definition.setName("street1");
        attributes.add(this.street1Definition);
        this.street2Definition = new AttributeDefinition();
        this.street2Definition.setName("street2");
        this.street2Definition.setPrerequisiteConstraints(prerequisiteConstraints);
        attributes.add(this.street2Definition);
        AttributeDefinition cityDefinition = new AttributeDefinition();
        cityDefinition.setName("city");
        attributes.add(cityDefinition);
        AttributeDefinition stateDefinition = new AttributeDefinition();
        stateDefinition.setName("state");
        attributes.add(stateDefinition);
        AttributeDefinition postalCodeDefinition = new AttributeDefinition();
        postalCodeDefinition.setName("postalCode");
        attributes.add(postalCodeDefinition);
        AttributeDefinition countryDefinition = new AttributeDefinition();
        countryDefinition.setName("country");
        attributes.add(countryDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testAllPrerequisitesSatisfiedSuccess() {
        ConstraintValidationResult result = this.process(this.street1PostalCodeCityStateAddress, "street2", this.street1Constraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new PrerequisiteConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testOnePrerequisiteMissingFailure() {
        ConstraintValidationResult result = this.process(this.noStreet1PostalCodeAddress, "street2", this.street1Constraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new PrerequisiteConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testAllPrerequisitesMissingFailure() {
        ConstraintValidationResult result = this.process(this.noStreet1CityStateAddress, "street2", this.street1Constraint);
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        result = this.process(this.noStreet1CityStateAddress, "street2", this.cityConstraint);
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        result = this.process(this.noStreet1CityStateAddress, "street2", this.stateConstraint);
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)3L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)new PrerequisiteConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testAttributeEmptySkipped() {
        ConstraintValidationResult result = this.process(this.noStreet2Address, "street2", this.street1Constraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new PrerequisiteConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testAttributeWithoutConstraintNoConstraint() {
        ConstraintValidationResult result = this.process(this.noStreet2Address, "street1", null);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.NOCONSTRAINT, (Object)result.getStatus());
        Assert.assertEquals((Object)new PrerequisiteConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, PrerequisiteConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

