/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.initialize;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.lifecycle.LifecycleElementState;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.initialize.InitializeDataFieldFromDictionaryTask;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;
import org.kuali.rice.krad.uif.util.UifUnitTestUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.mock.web.MockHttpServletRequest;

public class InitializeDataFieldFromDictionaryTest
extends ProcessLoggingUnitTest {
    @BeforeClass
    public static void setUpClass() throws Throwable {
        UifUnitTestUtils.establishMockConfig("KRAD-InitializeDataFieldFromDictionaryTest");
    }

    @Before
    public void setUp() throws Throwable {
        UifUnitTestUtils.establishMockUserSession("admin");
    }

    @After
    public void tearDown() throws Throwable {
        UifUnitTestUtils.tearDownMockUserSession();
    }

    @AfterClass
    public static void tearDownClass() throws Throwable {
        UifUnitTestUtils.tearDownMockConfig();
    }

    @Test
    public void testAttribute() throws Throwable {
        ViewLifecycle.encapsulateLifecycle((View)KRADServiceLocatorWeb.getViewService().getViewById("TestView"), (Object)((Object)new TestForm()), (HttpServletRequest)new MockHttpServletRequest(), (Runnable)new TestAttributeProcess());
    }

    public static class TestAttributeProcess
    implements Runnable {
        @Override
        public void run() {
            View view = ViewLifecycle.getView();
            String parentPath = "currentPage.items[0]";
            Component parent = (Component)ObjectPropertyUtils.getPropertyValue((Object)view, (String)parentPath);
            String foopath = "items[0]";
            DataField foofield = (DataField)ObjectPropertyUtils.getPropertyValue((Object)parent, (String)foopath);
            ViewLifecyclePhase foophase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase("INITIALIZE", (LifecycleElement)foofield, parent, foopath, null);
            InitializeDataFieldFromDictionaryTask footask = new InitializeDataFieldFromDictionaryTask();
            footask.setElementState((LifecycleElementState)foophase);
            String barpath = "items[1]";
            DataField barfield = (DataField)ObjectPropertyUtils.getPropertyValue((Object)parent, (String)barpath);
            ViewLifecyclePhase barphase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase("INITIALIZE", (LifecycleElement)barfield, parent, barpath, null);
            InitializeDataFieldFromDictionaryTask bartask = new InitializeDataFieldFromDictionaryTask();
            bartask.setElementState((LifecycleElementState)barphase);
            AttributeDefinition fooattribute = footask.findNestedDictionaryAttribute(foofield.getPropertyName());
            Assert.assertTrue((boolean)fooattribute.isRequired());
            AttributeDefinition barattribute = bartask.findNestedDictionaryAttribute(barfield.getPropertyName());
            Assert.assertFalse((boolean)barattribute.isRequired());
        }
    }

    public static class TestForm
    extends UifFormBase {
        private static final long serialVersionUID = 8726078766779752200L;
        private Foo foo;
        private Bar bar;

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            this.foo = foo;
        }

        public Bar getBar() {
            return this.bar;
        }

        public void setBar(Bar bar) {
            this.bar = bar;
        }
    }

    public static class Foo
    implements Serializable {
        private static final long serialVersionUID = -8018713299377638909L;
        private Bar descr;

        public Bar getDescr() {
            return this.descr;
        }

        public void setDescr(Bar descr) {
            this.descr = descr;
        }
    }

    public static class Bar
    implements Serializable {
        private static final long serialVersionUID = 1275816843240407178L;
        private String text;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

