/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.bo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.framework.resourceloader.BeanFactoryResourceLoader;
import org.kuali.rice.krad.bo.ModuleConfiguration;
import org.kuali.rice.krad.bo.test.TestEBOAbstract;
import org.kuali.rice.krad.bo.test.TestEBOConcrete;
import org.kuali.rice.krad.bo.test.TestEBOInterface;
import org.kuali.rice.krad.bo.test.TestEBOInterfaceSub;
import org.kuali.rice.krad.data.provider.Provider;
import org.kuali.rice.krad.data.provider.ProviderRegistry;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ModuleConfigurationTest {
    private ModuleConfiguration config = new ModuleConfiguration();
    @Mock
    private DataDictionaryService ddsMock;
    @Mock
    private ProviderRegistry prMock;
    private List<String> ddPackages = Arrays.asList("package1", "package2");
    private List<Provider> providers = Arrays.asList((Provider)Mockito.mock(Provider.class), (Provider)Mockito.mock(Provider.class));

    @Before
    public void initGRL() throws Exception {
        GlobalResourceLoader.stop();
        SimpleConfig config = new SimpleConfig();
        config.putProperty("application.id", "APPID");
        ConfigContext.init((Config)config);
        StaticListableBeanFactory testBf = new StaticListableBeanFactory();
        testBf.addBean("providerRegistry", (Object)this.prMock);
        BeanFactoryResourceLoader rl = new BeanFactoryResourceLoader(new QName("moduleconfiguration-unittest"), (BeanFactory)testBf);
        GlobalResourceLoader.addResourceLoader((ResourceLoader)rl);
        GlobalResourceLoader.start();
    }

    @Before
    public void setup() {
        this.config.setDataDictionaryService(this.ddsMock);
    }

    protected void initModuleConfiguration() {
        this.config.setNamespaceCode("moduleconfiguration-unittest");
        this.config.setDataDictionaryPackages(this.ddPackages);
        this.config.setProviders(this.providers);
    }

    @Test
    public void testInitializationWithoutDD() throws Exception {
        this.initModuleConfiguration();
        this.config.afterPropertiesSet();
        ((DataDictionaryService)Mockito.verify((Object)this.ddsMock, (VerificationMode)Mockito.never())).addDataDictionaryLocations(this.config.getNamespaceCode(), this.ddPackages);
    }

    @Test
    public void testInitialization() throws Exception {
        this.initModuleConfiguration();
        this.config.setInitializeDataDictionary(true);
        this.config.afterPropertiesSet();
        ((DataDictionaryService)Mockito.verify((Object)this.ddsMock)).addDataDictionaryLocations(this.config.getNamespaceCode(), this.ddPackages);
        ((ProviderRegistry)Mockito.verify((Object)this.prMock)).registerProvider(this.providers.get(0));
        ((ProviderRegistry)Mockito.verify((Object)this.prMock)).registerProvider(this.providers.get(1));
    }

    @Test
    public void testConcreteEBOIsValid() {
        HashMap<Class<TestEBOInterface>, Class<TestEBOConcrete>> ebos = new HashMap<Class<TestEBOInterface>, Class<TestEBOConcrete>>();
        ebos.put(TestEBOInterface.class, TestEBOConcrete.class);
        this.config.setExternalizableBusinessObjectImplementations(ebos);
    }

    @Test(expected=RuntimeException.class)
    public void testAbstractEBOIsInvalid() {
        HashMap<Class<TestEBOInterface>, Class<TestEBOAbstract>> ebos = new HashMap<Class<TestEBOInterface>, Class<TestEBOAbstract>>();
        ebos.put(TestEBOInterface.class, TestEBOAbstract.class);
        this.config.setExternalizableBusinessObjectImplementations(ebos);
    }

    @Test(expected=RuntimeException.class)
    public void testInterfaceEBOIsInvalid() {
        HashMap<Class<TestEBOInterface>, Class<TestEBOInterfaceSub>> ebos = new HashMap<Class<TestEBOInterface>, Class<TestEBOInterfaceSub>>();
        ebos.put(TestEBOInterface.class, TestEBOInterfaceSub.class);
        this.config.setExternalizableBusinessObjectImplementations(ebos);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetEBOsImmutability() {
        HashMap<Class<TestEBOInterface>, Class<TestEBOConcrete>> ebos = new HashMap<Class<TestEBOInterface>, Class<TestEBOConcrete>>();
        ebos.put(TestEBOInterface.class, TestEBOConcrete.class);
        this.config.setExternalizableBusinessObjectImplementations(ebos);
        Map returnedEbos = this.config.getExternalizableBusinessObjectImplementations();
        returnedEbos.put(TestEBOInterface.class, TestEBOConcrete.class);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetProvidersImmutability() {
        this.initModuleConfiguration();
        List providers = this.config.getProviders();
        providers.add(Mockito.mock(Provider.class));
    }
}

