/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.Employee;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class PhoneNumberPatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.phoneNumber";
    private AttributeDefinition contactPhoneDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Employee validPhoneEmployee = new Employee();
    private Employee invalidPhoneEmployeeEmpty = new Employee();
    private Employee invalidPhoneEmployee = new Employee();
    private Employee invalidPhoneEmployee1 = new Employee();
    private Employee invalidPhoneEmployee2 = new Employee();
    private Employee invalidPhoneEmployee3 = new Employee();
    private Employee invalidPhoneEmployee4 = new Employee();
    private Employee invalidPhoneEmployee5 = new Employee();
    private Employee invalidPhoneEmployee6 = new Employee();
    private ConfigurationBasedRegexPatternConstraint contactPhoneNumberPatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.phoneNumber");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.validPhoneEmployee.setContactPhone("056-012-1200");
        this.invalidPhoneEmployeeEmpty.setContactPhone("");
        this.invalidPhoneEmployee.setContactPhone("09712248474");
        this.invalidPhoneEmployee1.setContactPhone("+19712248474");
        this.invalidPhoneEmployee2.setContactPhone("+1-972-232-3333");
        this.invalidPhoneEmployee3.setContactPhone("+1-(972)-23334444");
        this.invalidPhoneEmployee4.setContactPhone("+1-(972)-1223444 xtn.222");
        this.invalidPhoneEmployee5.setContactPhone("+1 056 012 1200");
        this.invalidPhoneEmployee6.setContactPhone("056\\-012\\-1200");
        this.contactPhoneNumberPatternConstraint = new ConfigurationBasedRegexPatternConstraint();
        this.contactPhoneNumberPatternConstraint.setMessageKey("validate.dummykey");
        this.contactPhoneNumberPatternConstraint.setValidationMessageParams(new ArrayList());
        this.contactPhoneNumberPatternConstraint.setValue(regex);
        this.contactPhoneDefinition = new AttributeDefinition();
        this.contactPhoneDefinition.setName("contactPhone");
        this.contactPhoneDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        attributes.add(this.contactPhoneDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueInvalidPhoneNumberEmpty() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployeeEmpty, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidPhoneNumber() {
        ConstraintValidationResult result = this.process(this.validPhoneEmployee, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber1() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee1, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber2() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee2, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber3() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee3, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber4() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee4, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber5() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee5, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidPhoneNumber6() {
        ConstraintValidationResult result = this.process(this.invalidPhoneEmployee6, "contactPhone", (ValidCharactersConstraint)this.contactPhoneNumberPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

