/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.messages;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.messages.Message;
import org.kuali.rice.krad.messages.MessageServiceImpl;

public class MessageServiceImplTest {
    @Test
    public void testMergeMessages() {
        ArrayList<Message> messages1 = new ArrayList<Message>();
        ArrayList<Message> messages2 = new ArrayList<Message>();
        MessageBuilder builder = MessageBuilder.create("Default", "All", "Test Message");
        Message message1 = builder.build();
        builder.setKey("Test Message 2");
        Message message2 = builder.build();
        builder.setComponentCode("TestView");
        Message message3 = builder.build();
        builder.setNamespaceCode("KR-SAP");
        Message message4 = builder.build();
        Message message5 = builder.build();
        messages1.add(message1);
        messages1.add(message2);
        messages1.add(message4);
        messages2.add(message1);
        messages2.add(message3);
        messages2.add(message4);
        messages2.add(message5);
        MessageServiceImpl messageServiceImpl = new MessageServiceImpl();
        messageServiceImpl.mergeMessages(messages1, messages2);
        Assert.assertEquals((String)"Merged map is not correct size", (long)5L, (long)messages1.size());
    }

    public static class MessageBuilder {
        private String namespaceCode;
        private String componentCode;
        private String key;
        private String locale;
        private String description;
        private String text;

        public MessageBuilder(String namespaceCode, String componentCode, String key) {
            this.setNamespaceCode(namespaceCode);
            this.setComponentCode(componentCode);
            this.setKey(key);
        }

        public static MessageBuilder create(String namespaceCode, String componentCode, String key) {
            return new MessageBuilder(namespaceCode, componentCode, key);
        }

        public Message build() {
            Message message = new Message();
            message.setNamespaceCode(this.getNamespaceCode());
            message.setComponentCode(this.getComponentCode());
            message.setKey(this.getKey());
            message.setText(this.getText());
            message.setDescription(this.getDescription());
            message.setLocale(this.getLocale());
            return message;
        }

        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setNamespaceCode(String namespaceCode) {
            this.namespaceCode = namespaceCode;
        }

        public String getComponentCode() {
            return this.componentCode;
        }

        public void setComponentCode(String componentCode) {
            this.componentCode = componentCode;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLocale() {
            return this.locale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

