/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.Collection;
import java.util.Collections;
import org.kuali.rice.krad.messages.Message;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.messages.MessageServiceImpl;
import org.kuali.rice.krad.messages.providers.ResourceMessageProvider;

public class MockMessageService
implements MessageService {
    private MessageService delegate;

    private MessageService getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        ResourceMessageProvider provider = new ResourceMessageProvider();
        MessageServiceImpl messageServiceDelegate = new MessageServiceImpl();
        messageServiceDelegate.setMessageProviders(Collections.singletonList(provider));
        this.delegate = messageServiceDelegate;
        return this.delegate;
    }

    public Message getMessage(String namespace, String component, String key) {
        Message rv = this.getDelegate().getMessage(namespace, component, key);
        if (rv != null) {
            return rv;
        }
        rv = new Message();
        rv.setNamespaceCode(namespace);
        rv.setComponentCode(component);
        rv.setKey(key);
        rv.setText(this.getMessageText(namespace, component, key));
        return rv;
    }

    public Message getMessage(String namespace, String component, String key, String locale) {
        Message rv = this.getDelegate().getMessage(namespace, component, key, locale);
        if (rv != null) {
            return rv;
        }
        rv = new Message();
        rv.setNamespaceCode(namespace);
        rv.setComponentCode(component);
        rv.setKey(key);
        rv.setLocale(locale);
        rv.setText(namespace + ":" + component + ":" + key + ":" + locale);
        return rv;
    }

    public String getMessageText(String namespace, String component, String key) {
        String rv = this.getDelegate().getMessageText(namespace, component, key);
        if (rv != null) {
            return rv;
        }
        return namespace + ":" + component + ":" + key;
    }

    public String getMessageText(String namespace, String component, String key, String locale) {
        String rv = this.getDelegate().getMessageText(namespace, component, key, locale);
        if (rv != null) {
            return rv;
        }
        return namespace + ":" + component + ":" + key + ":" + locale;
    }

    public String getMessageText(String key) {
        String rv = this.getDelegate().getMessageText(key);
        if (rv != null) {
            return rv;
        }
        return key;
    }

    public String getMessageText(String key, String locale) {
        String rv = this.getDelegate().getMessageText(key, locale);
        if (rv != null) {
            return rv;
        }
        return key + ":" + locale;
    }

    public Collection<Message> getAllMessagesForComponent(String namespace, String component) {
        Collection rv = this.getDelegate().getAllMessagesForComponent(namespace, component);
        if (rv != null) {
            return rv;
        }
        Message rm = new Message();
        rm.setNamespaceCode(namespace);
        rm.setComponentCode(component);
        rm.setText(namespace + ":" + component);
        return Collections.singletonList(rm);
    }

    public Collection<Message> getAllMessagesForComponent(String namespace, String component, String locale) {
        Collection rv = this.getDelegate().getAllMessagesForComponent(namespace, component, locale);
        if (rv != null) {
            return rv;
        }
        Message rm = new Message();
        rm.setNamespaceCode(namespace);
        rm.setComponentCode(component);
        rm.setLocale(locale);
        rm.setText(namespace + ":" + component + ":" + locale);
        return Collections.singletonList(rm);
    }
}

