/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.uif.util.ObjectPathExpressionParser;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;

public class ObjectPathExpressionParserTest
extends ProcessLoggingUnitTest {
    @Test
    public void testParsePathExpression() {
        Assert.assertEquals((Object)"foo+bar", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo.bar", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo+bar", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar]", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo+bar+baz", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar].baz", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo+bar[baz]", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar[baz]]", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
        Assert.assertEquals((Object)"foo+bar-bar.baz+fez", (Object)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar-bar.baz]+fez", (ObjectPathExpressionParser.PathEntry)new DoIt()).toString());
    }

    @Test
    public void testJoinParsePathExpression() {
        List l1 = (List)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo.bar", (ObjectPathExpressionParser.PathEntry)new JoinIt());
        Assert.assertEquals((long)2L, (long)l1.size());
        Assert.assertEquals((Object)"foo", l1.get(0));
        Assert.assertEquals((Object)"bar", l1.get(1));
        List l2 = (List)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar]", (ObjectPathExpressionParser.PathEntry)new JoinIt());
        Assert.assertEquals((long)2L, (long)l2.size());
        Assert.assertEquals((Object)"foo", l2.get(0));
        Assert.assertEquals((Object)"bar", l2.get(1));
        List l3 = (List)ObjectPathExpressionParser.parsePathExpression(null, (String)"foo[bar-bar.baz].fez", (ObjectPathExpressionParser.PathEntry)new JoinIt());
        Assert.assertEquals((long)3L, (long)l3.size());
        Assert.assertEquals((Object)"foo", l3.get(0));
        Assert.assertEquals((Object)"bar-bar.baz", l3.get(1));
        Assert.assertEquals((Object)"fez", l3.get(2));
    }

    private static class JoinIt
    implements ObjectPathExpressionParser.PathEntry {
        private JoinIt() {
        }

        public List<String> parse(String parentPath, Object node, String next) {
            if (next == null) {
                return new ArrayList<String>();
            }
            List rv = (List)node;
            rv.add(next);
            return rv;
        }
    }

    private static class DoIt
    implements ObjectPathExpressionParser.PathEntry {
        private DoIt() {
        }

        public String parse(String parentPath, Object node, String next) {
            if (next == null) {
                return "";
            }
            String snode = (String)node;
            StringBuilder rv = new StringBuilder();
            if (snode != null && snode.length() > 0) {
                rv.append(snode);
            }
            if (rv.length() > 0) {
                rv.append('+');
            }
            rv.append(next);
            return rv.toString();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
        public String afoo();
    }
}

