/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.SingleAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.constraint.ConfigurationBasedRegexPatternConstraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class JavaClassPatternConstraintTest {
    private final String PATTERN_CONSTRAINT = "validationPatternRegex.javaClass";
    private AttributeDefinition javaClassDefinition;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private String validJavaClass;
    private String validJavaClass1;
    private String validJavaClass2;
    private String invalidJavaClassEmpty;
    private String invalidJavaClass;
    private String invalidJavaClass1;
    private String invalidJavaClass2;
    private String invalidJavaClass3;
    private ConfigurationBasedRegexPatternConstraint javaClassPatternConstraint;

    @Before
    public void setUp() throws Exception {
        String regex = this.getProperty("validationPatternRegex.javaClass");
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.validJavaClass = Integer.class.getName();
        this.validJavaClass1 = "org.kuali.rice.krad.datadictionary.validation.constraint.JavaClassPattternConstraintTest";
        this.validJavaClass2 = "String";
        this.invalidJavaClassEmpty = "";
        this.invalidJavaClass = "123.mypackage.com";
        this.invalidJavaClass1 = "mypackage.com.";
        this.invalidJavaClass2 = "123 mypackage";
        this.invalidJavaClass3 = "something.mypackage:com";
        this.javaClassPatternConstraint = new ConfigurationBasedRegexPatternConstraint();
        this.javaClassPatternConstraint.setMessageKey("validate.dummykey");
        this.javaClassPatternConstraint.setValidationMessageParams(new ArrayList());
        this.javaClassPatternConstraint.setValue(regex);
        this.javaClassDefinition = new AttributeDefinition();
        this.javaClassDefinition.setName("javaClass");
        this.javaClassDefinition.setValidCharactersConstraint((ValidCharactersConstraint)this.javaClassPatternConstraint);
    }

    @Test
    public void testValueInvalidJavaClassEmpty() {
        ConstraintValidationResult result = this.process(this.invalidJavaClassEmpty, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.INAPPLICABLE, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidJavaClass() {
        ConstraintValidationResult result = this.process(this.validJavaClass, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidJavaClass1() {
        ConstraintValidationResult result = this.process(this.validJavaClass1, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueValidJavaClass2() {
        ConstraintValidationResult result = this.process(this.validJavaClass2, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidJavaClass() {
        ConstraintValidationResult result = this.process(this.invalidJavaClass, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidJavaClass1() {
        ConstraintValidationResult result = this.process(this.invalidJavaClass1, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidJavaClass2() {
        ConstraintValidationResult result = this.process(this.invalidJavaClass2, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueInvalidJavaClass3() {
        ConstraintValidationResult result = this.process(this.invalidJavaClass3, "javaClass", (ValidCharactersConstraint)this.javaClassPatternConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        SingleAttributeValueReader attributeValueReader = new SingleAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", attributeName, this.javaClassDefinition);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }

    private String getProperty(String key) {
        String value = null;
        String filePath = "org/kuali/rice/krad/ApplicationResources.properties";
        Properties properties = new Properties();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            properties.load(in);
            value = properties.getProperty(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }
}

