/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.processor;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.validation.Address;
import org.kuali.rice.krad.datadictionary.validation.AttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.DictionaryObjectAttributeValueReader;
import org.kuali.rice.krad.datadictionary.validation.ErrorLevel;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersConstraint;
import org.kuali.rice.krad.datadictionary.validation.processor.ValidCharactersConstraintProcessor;
import org.kuali.rice.krad.datadictionary.validation.result.ConstraintValidationResult;
import org.kuali.rice.krad.datadictionary.validation.result.DictionaryValidationResult;

public class ValidCharactersConstraintProcessorTest {
    private AttributeDefinition street1Definition;
    private AttributeDefinition street2Definition;
    private AttributeDefinition stateDefinition;
    private BusinessObjectEntry addressEntry;
    private DictionaryValidationResult dictionaryValidationResult;
    private ValidCharactersConstraintProcessor processor;
    private Address washingtonDCAddress = new Address("893 Presidential Ave", "Suite 800", "Washington", "DC", "", "USA", null);
    private Address newYorkNYAddress = new Address("5 Presidential Street", "Suite 800", "New York", "NY", "", "USA", null);
    private ValidCharactersConstraint street1ValidCharactersConstraint;
    private ValidCharactersConstraint stateValidCharactersConstraint;

    @Before
    public void setUp() throws Exception {
        this.processor = new ValidCharactersConstraintProcessor();
        this.dictionaryValidationResult = new DictionaryValidationResult();
        this.dictionaryValidationResult.setErrorLevel(ErrorLevel.NOCONSTRAINT);
        this.addressEntry = new BusinessObjectEntry();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        this.street1ValidCharactersConstraint = new ValidCharactersConstraint();
        this.street1ValidCharactersConstraint.setValue("\\d{3}\\s+\\w+\\s+Ave");
        this.street1Definition = new AttributeDefinition();
        this.street1Definition.setName("street1");
        this.street1Definition.setValidCharactersConstraint(this.street1ValidCharactersConstraint);
        attributes.add(this.street1Definition);
        this.street2Definition = new AttributeDefinition();
        this.street2Definition.setName("street2");
        attributes.add(this.street2Definition);
        AttributeDefinition cityDefinition = new AttributeDefinition();
        cityDefinition.setName("city");
        attributes.add(cityDefinition);
        this.stateValidCharactersConstraint = new ValidCharactersConstraint();
        this.stateValidCharactersConstraint.setValue("[ABCD]{2}");
        this.stateDefinition = new AttributeDefinition();
        this.stateDefinition.setName("state");
        this.stateDefinition.setValidCharactersConstraint(this.stateValidCharactersConstraint);
        attributes.add(this.stateDefinition);
        AttributeDefinition postalCodeDefinition = new AttributeDefinition();
        postalCodeDefinition.setName("postalCode");
        attributes.add(postalCodeDefinition);
        AttributeDefinition countryDefinition = new AttributeDefinition();
        countryDefinition.setName("country");
        attributes.add(countryDefinition);
        this.addressEntry.setAttributes(attributes);
    }

    @Test
    public void testValueAllValidChars() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "state", this.stateValidCharactersConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueNotValidChars() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "state", this.stateValidCharactersConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueMatchingRegex() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "street1", this.street1ValidCharactersConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.OK, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueNotMatchingRegex() {
        ConstraintValidationResult result = this.process(this.newYorkNYAddress, "street1", this.street1ValidCharactersConstraint);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)1L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.ERROR, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    @Test
    public void testValueNotConstrained() {
        ConstraintValidationResult result = this.process(this.washingtonDCAddress, "street2", null);
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfWarnings());
        Assert.assertEquals((long)0L, (long)this.dictionaryValidationResult.getNumberOfErrors());
        Assert.assertEquals((Object)ErrorLevel.NOCONSTRAINT, (Object)result.getStatus());
        Assert.assertEquals((Object)new ValidCharactersConstraintProcessor().getName(), (Object)result.getConstraintName());
    }

    private ConstraintValidationResult process(Object object, String attributeName, ValidCharactersConstraint constraint) {
        DictionaryObjectAttributeValueReader attributeValueReader = new DictionaryObjectAttributeValueReader(object, "org.kuali.rice.kns.datadictionary.validation.MockAddress", (DataDictionaryEntry)this.addressEntry);
        attributeValueReader.setAttributeName(attributeName);
        Object value = attributeValueReader.getValue();
        return this.processor.process(this.dictionaryValidationResult, value, constraint, (AttributeValueReader)attributeValueReader).getFirstConstraintValidationResult();
    }
}

