/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.travel.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.kuali.rice.krad.bo.Exporter;
import org.kuali.rice.krad.demo.travel.dataobject.TravelAccountType;
import org.kuali.rice.krad.exception.ExportNotSupportedException;

public class TravelAccountTypeExporter
implements Exporter {
    public void export(Class<?> dataObjectClass, List<? extends Object> dataObjects, String exportFormat, OutputStream outputStream) throws IOException, ExportNotSupportedException {
        Document document = new Document(new Element("travelAccountTypes"));
        for (Object object : dataObjects) {
            Element travelAccountTypeElement = new Element("travelAccountType");
            TravelAccountType travelAccountType = (TravelAccountType)object;
            Element accountTypeCodeElement = new Element("accountTypeCode");
            accountTypeCodeElement.setText(travelAccountType.getAccountTypeCode());
            travelAccountTypeElement.addContent((Content)accountTypeCodeElement);
            Element nameElement = new Element("name");
            nameElement.setText(travelAccountType.getName());
            travelAccountTypeElement.addContent((Content)nameElement);
            Element activeElement = new Element("active");
            activeElement.setText(Boolean.toString(travelAccountType.isActive()));
            travelAccountTypeElement.addContent((Content)activeElement);
            document.getRootElement().addContent((Content)travelAccountTypeElement);
        }
        XMLOutputter outputer = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputer.output(document, outputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not write XML data export.", iOException);
        }
    }

    public List<String> getSupportedFormats(Class<?> dataObjectClass) {
        return Collections.singletonList("xml");
    }
}

