/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.uif.components;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.demo.uif.components.ComponentExhibit;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.TabGroup;
import org.kuali.rice.krad.uif.control.MultiValueControl;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.widget.SyntaxHighlighter;

public class ComponentLibraryView
extends FormView {
    private static final long serialVersionUID = 3981186175467661843L;
    private String rootJavadocAddress;
    private String rootDocBookAddress;
    private String docBookAnchor;
    private String componentName;
    private String javaFullClassPath;
    private String xmlFilePath;
    private String description;
    private String usage;
    private String largeExampleFieldId;
    private SyntaxHighlighter htmlCodeViewer;
    private ExampleSize exampleSize;
    private Group detailsGroup;
    private ComponentExhibit exhibit;
    private List<Group> demoGroups = new ArrayList<Group>();

    public void performInitialization(Object model) {
        super.performInitialization(model);
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        this.getPage().setHeaderText(this.getComponentName());
        TabGroup tabGroup = ComponentFactory.getTabGroup();
        ArrayList<Component> tabItems = new ArrayList<Component>();
        Group usageGroup = ComponentFactory.getVerticalBoxGroup();
        Header usageHeader = (Header)ComponentFactory.getNewComponentInstance((String)"Uif-SubSectionHeader");
        usageHeader.setHeaderLevel("H3");
        usageHeader.setHeaderText(messageService.getMessageText("KR-SAP", null, "componentLibrary.usage"));
        usageHeader.setRender(false);
        usageGroup.setHeader(usageHeader);
        ArrayList<Object> usageItems = new ArrayList<Object>();
        Message usageMessage = ComponentFactory.getMessage();
        usageMessage.setMessageText(this.usage);
        usageItems.add(usageMessage);
        usageItems.add(this.htmlCodeViewer);
        usageGroup.setItems(usageItems);
        tabItems.add((Component)usageGroup);
        if (this.javaFullClassPath != null) {
            this.processDocumentationTab(tabItems);
        }
        tabGroup.setItems(tabItems);
        tabGroup.addStyleClass("demo-componentDetailsTabs");
        ArrayList<TabGroup> detailsItems = new ArrayList<TabGroup>();
        detailsItems.addAll(this.detailsGroup.getItems());
        detailsItems.add(tabGroup);
        this.detailsGroup.setItems(detailsItems);
        ArrayList<String> sourceCode = new ArrayList<String>();
        this.processXmlSource(sourceCode);
        this.exhibit.setDemoSourceCode(sourceCode);
        this.exhibit.setDemoGroups(this.getDemoGroups());
        if (this.getExampleSize() != null && (this.getExampleSize().equals((Object)ExampleSize.LARGE) || this.getExampleSize().equals((Object)ExampleSize.XLARGE))) {
            this.exhibit.getTabGroup().addStyleClass("demo-noTabs");
            Group headerRightGroup = ViewLifecycle.getView().getPage().getHeader().getRightGroup();
            for (Component item : headerRightGroup.getItems()) {
                if (!(item instanceof InputField) || !(((InputField)item).getControl() instanceof MultiValueControl) || !item.getId().equals(this.getLargeExampleFieldId())) continue;
                ArrayList<ConcreteKeyValue> values = new ArrayList<ConcreteKeyValue>();
                for (Group demoGroup : this.demoGroups) {
                    values.add(new ConcreteKeyValue(demoGroup.getId(), demoGroup.getHeader().getHeaderText()));
                }
                ((MultiValueControl)((InputField)item).getControl()).setOptions(values);
                item.setRender(true);
            }
        }
        if (this.getExampleSize() != null && this.getExampleSize().equals((Object)ExampleSize.XLARGE)) {
            this.addStyleClass("demo-xLargeLibraryView");
        }
        ArrayList<ComponentExhibit> pageItems = new ArrayList<ComponentExhibit>();
        pageItems.addAll(this.getPage().getItems());
        pageItems.add(this.exhibit);
        pageItems.add((ComponentExhibit)this.detailsGroup);
        this.getPage().setItems(pageItems);
    }

    private void processDocumentationTab(List<Component> tabItems) {
        MessageService messageService = KRADServiceLocatorWeb.getMessageService();
        try {
            Class<?> componentClass = Class.forName(this.javaFullClassPath);
            Method[] methodsArray = componentClass.getMethods();
            String classMessage = messageService.getMessageText("KR-SAP", null, this.javaFullClassPath);
            if (classMessage == null) {
                classMessage = "NO DOCUMENTATION AVAILABLE/FOUND... we are working on it!";
            }
            classMessage = classMessage.replaceAll("\\{[@#]link (.*?)\\}", "<i>$1</i>");
            classMessage = classMessage.replaceAll("\\{[@#]code (.*?)\\}", "<i>$1</i>");
            String schemaTable = "<table class='demo-schemaIdDocTable'><tr><th>Schema Name</th><th>Uif Bean Id</th></tr>";
            if (componentClass.isAnnotationPresent(BeanTag.class)) {
                BeanTag beanTag = componentClass.getAnnotation(BeanTag.class);
                schemaTable = schemaTable + "<tr><td>" + beanTag.name() + "</td><td>" + beanTag.parent() + "</td></tr>";
                schemaTable = schemaTable + "</table>";
            } else if (componentClass.isAnnotationPresent(BeanTags.class)) {
                BeanTag[] beanTagArray;
                BeanTags beanTags = componentClass.getAnnotation(BeanTags.class);
                for (BeanTag beanTag : beanTagArray = beanTags.value()) {
                    schemaTable = schemaTable + "<tr><td>" + beanTag.name() + "</td><td>" + beanTag.parent() + "</td></tr>";
                }
                schemaTable = schemaTable + "</table>";
            } else {
                schemaTable = "";
            }
            String componentName = StringUtils.defaultIfBlank((String)(StringUtils.defaultString((String)this.getComponentName()) + " "), (String)"");
            String javadocTitle = messageService.getMessageText("KR-SAP", null, "componentLibrary.javaDoc");
            String kradGuideTitle = messageService.getMessageText("KR-SAP", null, "componentLibrary.kradGuide");
            String devDocumentationTitle = messageService.getMessageText("KR-SAP", null, "componentLibrary.devDocumentation");
            String beanDefsTitle = messageService.getMessageText("KR-SAP", null, "componentLibrary.beanDefs");
            String docLinkDiv = "<div class='demo-docLinks'> <label>Additional Resources:</label><a class='demo-documentationLink' href='" + this.getRootJavadocAddress() + this.javaFullClassPath.replace('.', '/') + ".html' target='_blank'>" + javadocTitle + "</a>" + "<a class='demo-documentationLink'" + " href='" + this.getRootDocBookAddress() + this.getDocBookAnchor() + "' target='_blank'>" + kradGuideTitle + "</a>" + "</div>";
            String documentationMessageContent = "<H3 class=\"uif-documentationHeader\">" + componentName + devDocumentationTitle + "</H3>" + docLinkDiv + classMessage + "<H3>" + beanDefsTitle + "</H3>" + schemaTable;
            ArrayList<Object> propertyDescriptions = new ArrayList<Object>();
            HashMap<String, ArrayList<Object>> inheritedProperties = new HashMap<String, ArrayList<Object>>();
            List<Method> methods = Arrays.asList(methodsArray);
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    String name1 = ComponentLibraryView.this.getPropName(method1);
                    String name2 = ComponentLibraryView.this.getPropName(method2);
                    return name1.compareTo(name2);
                }
            });
            for (Method method : methods) {
                BeanTagAttribute attribute = method.getAnnotation(BeanTagAttribute.class);
                if (attribute == null) continue;
                String name = this.getPropName(method);
                String methodClass = method.getDeclaringClass().getName();
                String returnType = method.getReturnType().getName();
                returnType = returnType.replaceAll("<.*?>", "");
                String returnTypeShort = returnType.substring(returnType.lastIndexOf(".") + 1);
                String key = methodClass + "|" + name + "|" + returnTypeShort;
                Object propertyMessage = messageService.getMessageText("KR-SAP", null, key);
                if (propertyMessage == null) {
                    propertyMessage = "NO DOCUMENTATION AVAILABLE... we are working on it!";
                }
                propertyMessage = ((String)propertyMessage).replaceAll("\\{[@#]link (.*?)\\}", "<i>$1</i>");
                propertyMessage = ((String)propertyMessage).replaceAll("\\{[@#]code (.*?)\\}", "<i>$1</i>");
                if (returnType.startsWith("org.kuali")) {
                    returnTypeShort = "<a href='" + this.getRootJavadocAddress() + returnType.replace('.', '/') + ".html' target='_blank'>" + returnTypeShort + "</a>";
                }
                propertyMessage = "<div class='demo-propertyItem'><h4 class='demo-propertyName'>" + name + "</h4>" + "<div class='demo-propertyType'>" + returnTypeShort + "</div>" + "<div class='demo-propertyDesc'>" + (String)propertyMessage + "</div></div>";
                if (!methodClass.equals(this.javaFullClassPath)) {
                    ArrayList<Object> classProperties = (ArrayList<Object>)inheritedProperties.get(methodClass);
                    if (classProperties == null) {
                        classProperties = new ArrayList<Object>();
                    }
                    classProperties.add(propertyMessage);
                    inheritedProperties.put(methodClass, classProperties);
                    continue;
                }
                propertyDescriptions.add(propertyMessage);
            }
            documentationMessageContent = documentationMessageContent + "<H3>Properties</H3><div class='demo-propertiesContent'>";
            for (String string : propertyDescriptions) {
                documentationMessageContent = documentationMessageContent + string;
            }
            documentationMessageContent = documentationMessageContent + "</div>";
            Group documentationGroup = ComponentFactory.getVerticalBoxGroup();
            Header header = (Header)ComponentFactory.getNewComponentInstance((String)"Uif-SubSectionHeader");
            header.setHeaderLevel("H3");
            header.setHeaderText(messageService.getMessageText("KR-SAP", null, "componentLibrary.documentation"));
            header.setRender(false);
            documentationGroup.setHeader(header);
            ArrayList<Object> propertiesItems = new ArrayList<Object>();
            Message propertiesMessage = ComponentFactory.getMessage();
            propertiesMessage.setParseComponents(false);
            propertiesMessage.setMessageText(documentationMessageContent);
            propertiesItems.add(propertiesMessage);
            if (!inheritedProperties.isEmpty()) {
                for (String className : inheritedProperties.keySet()) {
                    String messageContent = "";
                    List inheritedPropertyDescriptions = (List)inheritedProperties.get(className);
                    for (String desc : inheritedPropertyDescriptions) {
                        messageContent = messageContent + desc;
                    }
                    Group iPropertiesGroup = ComponentFactory.getVerticalBoxGroup();
                    Header iPropHeader = (Header)ComponentFactory.getNewComponentInstance((String)"Uif-SubSectionHeader");
                    iPropHeader.setHeaderLevel("H3");
                    iPropHeader.setHeaderText(messageService.getMessageText("KR-SAP", null, "componentLibrary.inheritedFrom") + " " + className);
                    iPropertiesGroup.setHeader(iPropHeader);
                    iPropertiesGroup.getDisclosure().setRender(true);
                    iPropertiesGroup.getDisclosure().setDefaultOpen(false);
                    ArrayList<Message> iPropertiesItems = new ArrayList<Message>();
                    Message iPropertiesMessage = ComponentFactory.getMessage();
                    iPropertiesMessage.setParseComponents(false);
                    iPropertiesMessage.setMessageText(messageContent);
                    iPropertiesItems.add(iPropertiesMessage);
                    iPropertiesGroup.setItems(iPropertiesItems);
                    propertiesItems.add(iPropertiesGroup);
                }
            }
            documentationGroup.setItems(propertiesItems);
            tabItems.add((Component)documentationGroup);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading class: " + this.javaFullClassPath, e);
        }
    }

    private String getPropName(Method method) {
        String name = method.getName();
        name = name.startsWith("get") ? name.replaceFirst("get", "") : name.replaceFirst("is", "");
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return name;
    }

    private void processXmlSource(List<String> sourceCode) {
        HashMap<String, String> idSourceMap = new HashMap<String, String>();
        if (this.xmlFilePath != null) {
            try {
                URL fileUrl = ComponentLibraryView.class.getClassLoader().getResource(this.xmlFilePath);
                File file = new File(fileUrl.toURI());
                Pattern examplePattern = Pattern.compile("ex:(.*?)(\\s|(-->))");
                boolean readingSource = false;
                String currentSource = "";
                String currentId = "";
                LineIterator lineIt = FileUtils.lineIterator((File)file);
                while (lineIt.hasNext()) {
                    String line = lineIt.next();
                    if (line.contains("ex:") && !readingSource) {
                        readingSource = true;
                        Matcher matcher = examplePattern.matcher(line);
                        if (matcher.find()) {
                            currentId = matcher.group(1);
                        }
                        if ((currentSource = idSourceMap.get(currentId) != null ? (String)idSourceMap.get(currentId) : "").isEmpty()) continue;
                        currentSource = currentSource + "\n";
                        continue;
                    }
                    if (line.contains("ex:") && readingSource) {
                        readingSource = false;
                        idSourceMap.put(currentId, currentSource);
                        continue;
                    }
                    if (!readingSource) continue;
                    currentSource = currentSource + line + "\n";
                }
            }
            catch (Exception e) {
                throw new RuntimeException("file not found or error while reading: " + this.xmlFilePath + " for source reading", e);
            }
        }
        for (Group demoGroup : this.demoGroups) {
            String groupId = demoGroup.getId();
            String source = (String)idSourceMap.get(groupId);
            if (source == null) continue;
            sourceCode.add(this.translateSource(source));
        }
    }

    private String translateSource(String source) {
        source = source.replace("<", "&lt;");
        source = source.replace(">", "&gt;");
        source = source.replaceAll("[ \\t]", "&#32;");
        Pattern linePattern = Pattern.compile("((&#32;)*).*?(\\n)+");
        Matcher matcher = linePattern.matcher(source);
        int toRemove = -1;
        while (matcher.find()) {
            String spaces = matcher.group(1);
            int count = StringUtils.countMatches((String)spaces, (String)"&#32;");
            if (toRemove != -1 && count >= toRemove) continue;
            toRemove = count;
        }
        matcher.reset();
        String newSource = "";
        while (matcher.find()) {
            String line = matcher.group();
            newSource = newSource + line.replaceFirst("(&#32;){" + toRemove + "}", "");
        }
        newSource = newSource.replaceAll("\\n$", "");
        newSource = newSource.replace("\n", "&#010;");
        return newSource;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getJavaFullClassPath() {
        return this.javaFullClassPath;
    }

    public void setJavaFullClassPath(String javaFullClassPath) {
        this.javaFullClassPath = javaFullClassPath;
    }

    public String getXmlFilePath() {
        return this.xmlFilePath;
    }

    public void setXmlFilePath(String xmlFilePath) {
        this.xmlFilePath = xmlFilePath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    @ViewLifecycleRestriction(value={"PRE_PROCESS"})
    public Group getDetailsGroup() {
        return this.detailsGroup;
    }

    public void setDetailsGroup(Group detailsGroup) {
        this.detailsGroup = detailsGroup;
    }

    @ViewLifecycleRestriction(value={"PRE_PROCESS"})
    public ComponentExhibit getExhibit() {
        return this.exhibit;
    }

    public void setExhibit(ComponentExhibit exhibit) {
        this.exhibit = exhibit;
    }

    @ViewLifecycleRestriction(value={"PRE_PROCESS"})
    public List<Group> getDemoGroups() {
        return this.demoGroups;
    }

    public void setDemoGroups(List<Group> demoGroups) {
        this.demoGroups = demoGroups;
    }

    public String getRootJavadocAddress() {
        return this.rootJavadocAddress;
    }

    public void setRootJavadocAddress(String rootJavadocAddress) {
        this.rootJavadocAddress = rootJavadocAddress;
    }

    public String getRootDocBookAddress() {
        return this.rootDocBookAddress;
    }

    public void setRootDocBookAddress(String rootDocBookAddress) {
        this.rootDocBookAddress = rootDocBookAddress;
    }

    public String getDocBookAnchor() {
        if (this.docBookAnchor == null) {
            return "";
        }
        return "#" + this.docBookAnchor;
    }

    public void setDocBookAnchor(String docBookAnchor) {
        this.docBookAnchor = docBookAnchor;
    }

    public ExampleSize getExampleSize() {
        return this.exampleSize;
    }

    public void setExampleSize(ExampleSize exampleSize) {
        this.exampleSize = exampleSize;
    }

    public String getLargeExampleFieldId() {
        return this.largeExampleFieldId;
    }

    public void setLargeExampleFieldId(String largeExampleFieldId) {
        this.largeExampleFieldId = largeExampleFieldId;
    }

    @ViewLifecycleRestriction(value={"PRE_PROCESS"})
    public SyntaxHighlighter getHtmlCodeViewer() {
        return this.htmlCodeViewer;
    }

    public void setHtmlCodeViewer(SyntaxHighlighter htmlCodeViewer) {
        this.htmlCodeViewer = htmlCodeViewer;
    }

    public static enum ExampleSize {
        SMALL,
        LARGE,
        XLARGE,
        WINDOW;

    }
}

