/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.uif.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ComponentSuggestClass {
    public static List<String> getLanguages(String term) {
        ArrayList<String> matchingLanguages = new ArrayList<String>();
        String[] languageArray = new String[]{"ActionScript", "AppleScript", "Asp", "BASIC", "C", "C++", "Clojure", "COBOL", "ColdFusion", "Erlang", "Fortran", "Groovy", "Haskell", "Java", "JavaScript", "Lisp", "Perl", "PHP", "Python", "Ruby", "Scala", "Scheme"};
        for (int i = 0; i < languageArray.length; ++i) {
            String language = languageArray[i];
            if (!language.toLowerCase().startsWith(term.toLowerCase())) continue;
            matchingLanguages.add(language);
        }
        return matchingLanguages;
    }

    public static List<String> getAllLanguages() {
        String[] languageArray = new String[]{"ActionScript", "AppleScript", "Asp", "BASIC", "C", "C++", "Clojure", "COBOL", "ColdFusion", "Erlang", "Fortran", "Groovy", "Haskell", "Java", "JavaScript", "Lisp", "Perl", "PHP", "Python", "Ruby", "Scala", "Scheme"};
        return Arrays.asList(languageArray);
    }

    public static List<TestLabelValue> getRichOptions() {
        ArrayList<TestLabelValue> options = new ArrayList<TestLabelValue>();
        options.add(new TestLabelValue("r1", "<b>Rich Option 1</b><br/><i>this is a desc for option 1</i>"));
        options.add(new TestLabelValue("r1", "<b>Rich Option 2</b><br/><i>this is a desc for option 2</i>"));
        options.add(new TestLabelValue("r1", "<b>Rich Option 3</b><br/><i>this is a desc for option 3</i>"));
        return options;
    }

    public static List<TestSuggestObject> getComplexOptions() {
        ArrayList<TestSuggestObject> options = new ArrayList<TestSuggestObject>();
        options.add(new TestSuggestObject("1", "jhbon", "Bohan, Jack"));
        options.add(new TestSuggestObject("2", "jmcross", "Cross, Jeff"));
        options.add(new TestSuggestObject("3", "jomot", "Mot, Joe"));
        return options;
    }

    public static List<TestViewObject> getViewOptions() {
        ArrayList<TestViewObject> options = new ArrayList<TestViewObject>();
        options.add(new TestViewObject("Input Field", "Demo-InputFieldView"));
        options.add(new TestViewObject("Suggest", "Demo-SuggestView"));
        options.add(new TestViewObject("Select Control", "Demo-SelectControlView"));
        options.add(new TestViewObject("TextControl", "Demo-TextControlView"));
        options.add(new TestViewObject("Sticky Header", "Demo-StickyHeaderView"));
        return options;
    }

    public static class TestViewObject
    extends TestLabelValue {
        private String id;

        public TestViewObject(String value, String id) {
            super(value, value);
            this.id = id;
        }

        public TestViewObject(String value, String label, String id) {
            super(value, label);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class TestSuggestObject
    extends TestLabelValue {
        private String description;

        public TestSuggestObject(String value, String label, String description) {
            super(value, label);
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class TestLabelValue {
        private String label;
        private String value;

        public TestLabelValue() {
        }

        public TestLabelValue(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

