/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.datadictionary.Copyable;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.CollectionGroupBase;
import org.kuali.rice.krad.uif.container.CollectionGroupBuilder;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.element.ViewHeader;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.layout.StackedLayoutManagerBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.service.impl.ViewHelperServiceImpl;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;
import org.kuali.rice.krad.uif.util.UifUnitTestUtils;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewPresentationController;
import org.kuali.rice.krad.uif.view.ViewPresentationControllerBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.bind.RequestAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPropertyUtilsTest
extends ProcessLoggingUnitTest {
    final Logger LOG = LoggerFactory.getLogger(ObjectPropertyUtilsTest.class);

    @BeforeClass
    public static void setup() throws Exception {
        UifUnitTestUtils.establishMockConfig("ObjectPropertyUtilsTest");
    }

    @AfterClass
    public static void teardown() throws Exception {
        UifUnitTestUtils.tearDownMockConfig();
    }

    @Test
    public void testSetBoolean() {
        TestBean tb = new TestBean();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"booleanProp", (Object)"true");
        Assert.assertTrue((boolean)tb.isBooleanProp());
    }

    @Test
    public void testGetPropertyDescriptor() {
        Map pds = ObjectPropertyUtils.getPropertyDescriptors(TestBean.class);
        Assert.assertNotNull(pds.get("rwProp"));
        Assert.assertNotNull(pds.get("roProp"));
        Assert.assertNotNull(pds.get("woProp"));
        Assert.assertNull(pds.get("foobar"));
    }

    @Test
    public void testGet() {
        TestBean tb = new TestBean();
        tb.setRwProp("foobar");
        Assert.assertEquals((Object)"foobar", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"rwProp"));
        tb.roProp = "barbaz";
        Assert.assertEquals((Object)"barbaz", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"roProp"));
        ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"woProp");
    }

    @Test
    public void testLookup() {
        TestBean tb = new TestBean();
        tb.roProp = "barbaz";
        Assert.assertEquals((Object)"barbaz", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"roProp"));
        HashMap<String, Object> tm = new HashMap<String, Object>();
        tb.setMapProp(tm);
        tm.put("barbaz", "hooray!");
        tm.put("bar.baz", "hoorah!");
        tm.put("bar.[baz]", "foobah!");
        tm.put("b'('r.[\"ain)\"s]", "zombie!");
        Assert.assertEquals((Object)"hooray!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp[barbaz]"));
        Assert.assertEquals((Object)"hooray!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp['barbaz']"));
        Assert.assertEquals((Object)"hooray!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp[\"barbaz\"]"));
        Assert.assertEquals((Object)"hoorah!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp[bar.baz]"));
        Assert.assertEquals((Object)"foobah!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp[bar.[baz]]"));
        Assert.assertEquals((Object)"zombie!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp['b'('r.[\"ain)\"s]']"));
        Assert.assertEquals((Object)"zombie!", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"mapProp[b'('r.[\"ain)\"s]]"));
        TestBean tb2 = new TestBean();
        tb2.setRwProp("foodbar");
        tb.setNext(tb2);
        tm.put("blah", new Object[]{"next", "rwProp"});
        tm.put("baz", tb2);
        Assert.assertTrue((boolean)ObjectPropertyUtils.isReadableProperty((Object)tb, (String)"mapProp[\"baz\"].rwProp"));
        Assert.assertEquals((Object)"barbaz", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"roProp"));
        Assert.assertEquals((Object)"foodbar", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"next.rwProp"));
        tb.setStuffs(Arrays.asList("foo", "bar", "baz"));
        Assert.assertEquals((Object)"bar", (Object)ObjectPropertyUtils.getPropertyValue((Object)tb, (String)"stuffs[1]"));
        TestBean rb = new TestBean();
        TestBean nb = new TestBean();
        TestBean lb = new TestBean();
        rb.setNext(nb);
        nb.setNext(lb);
        Assert.assertEquals(String.class, (Object)ObjectPropertyUtils.getPropertyType((Object)rb, (String)"next.next.rwProp"));
        rb.setRwProp("baz");
        nb.setRwProp("bar");
        lb.setRwProp("foo");
        Assert.assertEquals((Object)"foo", (Object)ObjectPropertyUtils.getPropertyValue((Object)rb, (String)"next.next.rwProp"));
    }

    @Test
    public void testSet() throws Throwable {
        TestBean tb = new TestBean();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"rwProp", (Object)"foobar");
        Assert.assertEquals((Object)"foobar", (Object)tb.getRwProp());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"woProp", (Object)"barbaz");
        Assert.assertEquals((Object)"barbaz", (Object)tb.woProp);
        try {
            ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"roProp", (Object)"bazfoo");
            Assert.fail((String)"expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        long now = System.currentTimeMillis();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"dateProp", (Object)new Date(now));
        Assert.assertEquals((long)now, (long)tb.getDateProp().getTime());
        String dateStr = "01/03/2013";
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"dateProp", (Object)dateStr);
        java.util.Date expectedDate = new SimpleDateFormat("MM/dd/yy").parse(dateStr);
        Assert.assertEquals((Object)expectedDate, (Object)tb.getDateProp());
    }

    @Test
    public void testGetAsText() throws Throwable {
        String dateStr = "01/03/2013";
        java.util.Date expectedDate = new SimpleDateFormat("MM/dd/yy").parse(dateStr);
        TestBean tb = new TestBean();
        tb.setDateProp(expectedDate);
        Assert.assertEquals((Object)"01/03/13", (Object)ObjectPropertyUtils.getPropertyValueAsText((Object)tb, (String)"dateProp"));
    }

    @Test
    public void testPathSet() {
        TestBean tb = new TestBean();
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"rwProp", (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)tb.getRwProp());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"next", (Object)new TestBean());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"next.next", (Object)new TestBean());
        ObjectPropertyUtils.setPropertyValue((Object)tb, (String)"next.next.woProp", (Object)"baz");
        Assert.assertEquals((Object)"baz", (Object)tb.getNext().getNext().woProp);
    }

    @Test
    public void testBulk() {
        HashMap<String, String> pd = new HashMap<String, String>();
        pd.put("rwProp", "foobar");
        pd.put("intProp", "3");
        pd.put("booleanProp", "true");
        pd.put("stuffs", "foo,bar,baz");
        for (int i = 0; i < 10000; ++i) {
            TestBean tb = new TestBean();
            ObjectPropertyUtils.copyPropertiesToObject(pd, (Object)tb);
            Assert.assertEquals((Object)"foobar", (Object)tb.getRwProp());
            Assert.assertEquals((long)3L, (long)tb.getIntProp());
            Assert.assertEquals((Object)true, (Object)tb.isBooleanProp());
            Assert.assertEquals((long)3L, (long)tb.getStuffs().size());
            Assert.assertEquals((Object)"foo", (Object)tb.getStuffs().get(0));
            Assert.assertEquals((Object)"bar", (Object)tb.getStuffs().get(1));
            Assert.assertEquals((Object)"baz", (Object)tb.getStuffs().get(2));
        }
    }

    @Test
    public void testReadWriteCheck() {
        TestBean tb = new TestBean();
        Assert.assertTrue((boolean)ObjectPropertyUtils.isReadableProperty((Object)tb, (String)"rwProp"));
        Assert.assertTrue((boolean)ObjectPropertyUtils.isWritableProperty((Object)tb, (String)"rwProp"));
        Assert.assertTrue((boolean)ObjectPropertyUtils.isReadableProperty((Object)tb, (String)"roProp"));
        Assert.assertFalse((boolean)ObjectPropertyUtils.isWritableProperty((Object)tb, (String)"roProp"));
        Assert.assertFalse((boolean)ObjectPropertyUtils.isReadableProperty((Object)tb, (String)"woProp"));
        Assert.assertTrue((boolean)ObjectPropertyUtils.isWritableProperty((Object)tb, (String)"woProp"));
    }

    @Test
    public void testKradUifTemplateHeaderMetadata() {
        FormView formView = new FormView();
        ViewHeader viewHeader = new ViewHeader();
        formView.setHeader((Header)viewHeader);
        Message headerMetadataMessage = new Message();
        viewHeader.setMetadataMessage(headerMetadataMessage);
        Assert.assertSame((Object)headerMetadataMessage, (Object)ObjectPropertyUtils.getPropertyValue((Object)formView, (String)"header.metadataMessage"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKradUifCollectionGroupBuilder() throws Throwable {
        UifUnitTestUtils.establishMockConfig(ObjectPropertyUtilsTest.class.getSimpleName());
        UifUnitTestUtils.establishMockUserSession("testuser");
        try {
            final CollectionGroupBuilder collectionGroupBuilder = new CollectionGroupBuilder();
            final CollectionTestForm form = new CollectionTestForm();
            CollectionTestItem item = new CollectionTestItem();
            item.setFoobar("barfoo");
            ObjectPropertyUtils.setPropertyValue((Object)((Object)form), (String)"foo.baz['foo_bar_'badquotes'_.foobar']", (Object)item);
            Assert.assertEquals((Object)"barfoo", (Object)form.foo.baz.get((Object)"foo_bar_'badquotes'_.foobar").foobar);
            final FormView view = new FormView();
            view.setFormClass(CollectionTestForm.class);
            view.setViewHelperService((ViewHelperService)new ViewHelperServiceImpl());
            view.setPresentationController((ViewPresentationController)new ViewPresentationControllerBase());
            view.setAuthorizer(UifUnitTestUtils.getAllowMostViewAuthorizer());
            CollectionGroupBase collectionGroup = new CollectionGroupBase();
            collectionGroup.setCollectionObjectClass(CollectionTestItem.class);
            collectionGroup.setAddLinePropertyName("addLineFoo");
            StackedLayoutManagerBase layoutManager = new StackedLayoutManagerBase();
            GroupBase lineGroupPrototype = new GroupBase();
            layoutManager.setLineGroupPrototype((Group)lineGroupPrototype);
            collectionGroup.setLayoutManager((LayoutManager)layoutManager);
            BindingInfo addLineBindingInfo = new BindingInfo();
            addLineBindingInfo.setBindingPath("foo.baz['foo_bar_'badquotes'_.foobar']");
            collectionGroup.setAddLineBindingInfo(addLineBindingInfo);
            BindingInfo collectionBindingInfo = new BindingInfo();
            collectionBindingInfo.setBindingPath("foo.bar");
            collectionGroup.setBindingInfo(collectionBindingInfo);
            ViewLifecycle.encapsulateLifecycle((View)view, (Object)((Object)form), null, (Runnable)new Runnable((CollectionGroup)collectionGroup){
                final /* synthetic */ CollectionGroup val$collectionGroup;
                {
                    this.val$collectionGroup = collectionGroup;
                }

                @Override
                public void run() {
                    collectionGroupBuilder.build((View)view, (Object)form, (CollectionGroup)CopyUtils.copy((Copyable)this.val$collectionGroup));
                }
            });
        }
        finally {
            GlobalVariables.setUserSession(null);
            GlobalVariables.clear();
            GlobalResourceLoader.stop();
        }
    }

    @Test
    public void testSetStringMapFromInt() {
        Action action = new Action();
        ObjectPropertyUtils.setPropertyValue((Object)action, (String)"actionParameters['lineIndex']", (Object)34);
        Assert.assertEquals((Object)"34", (Object)action.getActionParameter("lineIndex"));
    }

    @Test
    public void testClassNavigation() {
        Assert.assertEquals(String.class, (Object)ObjectPropertyUtils.getPropertyType(TestBean.class, (String)"complexProp.fooProp"));
        Assert.assertEquals(null, (Object)ObjectPropertyUtils.getPropertyType(TestBean.class, (String)"complexProp.foobar"));
        Assert.assertEquals(null, (Object)ObjectPropertyUtils.getPropertyType(TestBean.class, (String)"foo"));
        Assert.assertEquals(null, (Object)ObjectPropertyUtils.getPropertyType(TestBean.class, (String)"foo.bar"));
    }

    @Test
    public void testPropertySplitPath() {
        String path = "foo.foo1.foo2";
        String[] splitPaths = ObjectPropertyUtils.splitPropertyPath((String)path);
        Assert.assertEquals((long)3L, (long)splitPaths.length);
        Assert.assertEquals((Object)"foo", (Object)splitPaths[0]);
        Assert.assertEquals((Object)"foo1", (Object)splitPaths[1]);
        Assert.assertEquals((Object)"foo2", (Object)splitPaths[2]);
        path = "foo[1]";
        splitPaths = ObjectPropertyUtils.splitPropertyPath((String)path);
        Assert.assertEquals((long)1L, (long)splitPaths.length);
        Assert.assertEquals((Object)"foo[1]", (Object)splitPaths[0]);
        path = "foo.foo1['key.nested'].foo2";
        splitPaths = ObjectPropertyUtils.splitPropertyPath((String)path);
        Assert.assertEquals((long)3L, (long)splitPaths.length);
        Assert.assertEquals((Object)"foo", (Object)splitPaths[0]);
        Assert.assertEquals((Object)"foo1['key.nested']", (Object)splitPaths[1]);
        Assert.assertEquals((Object)"foo2", (Object)splitPaths[2]);
        path = "foo.foo1['key.nested'].foo2.foo3['key.nest.nest'].foo4";
        splitPaths = ObjectPropertyUtils.splitPropertyPath((String)path);
        Assert.assertEquals((long)5L, (long)splitPaths.length);
        Assert.assertEquals((Object)"foo", (Object)splitPaths[0]);
        Assert.assertEquals((Object)"foo1['key.nested']", (Object)splitPaths[1]);
        Assert.assertEquals((Object)"foo2", (Object)splitPaths[2]);
        Assert.assertEquals((Object)"foo3['key.nest.nest']", (Object)splitPaths[3]);
        Assert.assertEquals((Object)"foo4", (Object)splitPaths[4]);
    }

    @Test
    public void testCanonicalPath() {
        String path = "foo.foo1.foo2";
        Assert.assertEquals((Object)path, (Object)ObjectPropertyUtils.getCanonicalPath((String)path));
        path = "foo[1]";
        Assert.assertEquals((Object)"foo", (Object)ObjectPropertyUtils.getCanonicalPath((String)path));
        path = "foo.foo1['key.nested'].foo2";
        Assert.assertEquals((Object)"foo.foo1.foo2", (Object)ObjectPropertyUtils.getCanonicalPath((String)path));
        path = "foo.foo1['key.nested'].foo2.foo3['key.nest.nest'].foo4";
        Assert.assertEquals((Object)"foo.foo1.foo2.foo3.foo4", (Object)ObjectPropertyUtils.getCanonicalPath((String)path));
    }

    @Test
    public void testGetterInInterfaceOrSuperHasWiderType() {
        Method readMethod = null;
        readMethod = ObjectPropertyUtils.getReadMethod(ComparableHolderImpl.class, (String)"comparable");
        Assert.assertEquals(Integer.class, readMethod.getReturnType());
        readMethod = ObjectPropertyUtils.getReadMethod(NumberedImplOne.class, (String)"number");
        Assert.assertEquals(Integer.class, readMethod.getReturnType());
        readMethod = ObjectPropertyUtils.getReadMethod(ConcreteNarrowedNumberHolder.class, (String)"number");
        Assert.assertEquals(Integer.class, readMethod.getReturnType());
        readMethod = ObjectPropertyUtils.getReadMethod(ConcreteNarrowedNumberHolderSub.class, (String)"number");
        Assert.assertEquals(Integer.class, readMethod.getReturnType());
        for (int i = 0; i < 1; ++i) {
            readMethod = ObjectPropertyUtils.getReadMethod(KualiPercentHolder.class, (String)"decimal");
        }
        if (readMethod.getReturnType() == KualiDecimal.class) {
            this.LOG.info("I bet you're using JDK6 on Linux");
        }
        readMethod = ObjectPropertyUtils.getReadMethod(Base.class, (String)"value");
        Assert.assertEquals(Number.class, readMethod.getReturnType());
        readMethod = ObjectPropertyUtils.getReadMethod(Int.class, (String)"value");
        Assert.assertEquals(Integer.class, readMethod.getReturnType());
    }

    public class Int
    extends Base {
        @Override
        public Integer getValue() {
            return 1;
        }
    }

    public class Base {
        public Number getValue() {
            return null;
        }
    }

    public class KualiPercentHolder
    implements KualiDecimalHolder {
        public KualiPercent getDecimal() {
            return new KualiPercent(1.0);
        }
    }

    public static interface KualiDecimalHolder {
        public KualiDecimal getDecimal();
    }

    public class ComparableHolderImpl
    implements ComparableHolder {
        public Integer getComparable() {
            return 1;
        }
    }

    public static interface ComparableHolder {
        public Comparable<?> getComparable();
    }

    public class ConcreteNarrowedNumberHolderSub
    extends ConcreteNarrowedNumberHolder {
    }

    public class ConcreteNarrowedNumberHolder
    extends ConcreteNumberHolder {
        @Override
        public Integer getNumber() {
            return 1;
        }
    }

    public class ConcreteNumberHolder
    extends AbstractNumberHolder {
        @Override
        public Number getNumber() {
            return 1;
        }
    }

    public abstract class AbstractNumberHolder
    implements NumberHolder {
        @Override
        public abstract Number getNumber();
    }

    public class NumberedImplOne
    implements NumberHolder {
        @Override
        public Integer getNumber() {
            return 1;
        }
    }

    public static interface NumberHolder {
        public Number getNumber();
    }

    public static class CollectionTestForm
    extends UifFormBase {
        private static final long serialVersionUID = 1798800132492441253L;
        CollectionTestListRef foo;

        public CollectionTestListRef getFoo() {
            return this.foo;
        }

        public void setFoo(CollectionTestListRef foo) {
            this.foo = foo;
        }
    }

    public static class CollectionTestListRef {
        List<CollectionTestItem> bar;
        Map<String, CollectionTestItem> baz;

        public List<CollectionTestItem> getBar() {
            return this.bar;
        }

        public void setBar(List<CollectionTestItem> bar) {
            this.bar = bar;
        }

        public Map<String, CollectionTestItem> getBaz() {
            return this.baz;
        }

        public void setBaz(Map<String, CollectionTestItem> baz) {
            this.baz = baz;
        }
    }

    public static class CollectionTestItem {
        String foobar;

        public String getFoobar() {
            return this.foobar;
        }

        public void setFoobar(String foobar) {
            this.foobar = foobar;
        }
    }

    public static class FooEditor
    extends PropertyEditorSupport {
        @Override
        public String getAsText() {
            return "foobar";
        }
    }

    public static class TestForm
    extends UifFormBase {
        private static final long serialVersionUID = 6597388705374534394L;
        private TestBean bean;

        public TestBean getBean() {
            return this.bean;
        }

        public void setBean(TestBean bean) {
            this.bean = bean;
        }
    }

    public static class TestBeanTwo {
        private String fooProp;

        public String getFooProp() {
            return this.fooProp;
        }

        public void setFooProp(String fooProp) {
            this.fooProp = fooProp;
        }
    }

    public static class TestBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @RequestAccessible
        private String rwProp;
        private TestBeanTwo complexProp;
        private String woProp;
        private String roProp;
        private Boolean bitProp;
        private boolean booleanProp;
        private Timestamp timestampProp;
        private java.util.Date dateProp;
        private int intProp;
        private BigDecimal bigDecimalProp;
        private Integer integerProp;
        private TestBean next;
        private List<String> stuffs;
        private Object[] arrayProp;
        private Map<String, Object> mapProp;

        public String getRwProp() {
            return this.rwProp;
        }

        public void setRwProp(String r) {
            this.rwProp = r;
        }

        public void setWoProp(String w) {
            this.woProp = w;
        }

        @TestAnnotation(afoo="abar")
        public String getRoProp() {
            return this.roProp;
        }

        public boolean isBitProp() {
            return this.bitProp != null && this.bitProp != false;
        }

        public Boolean getBitProp() {
            return this.bitProp;
        }

        public void setBitProp(Boolean bitProp) {
            this.bitProp = bitProp;
        }

        public boolean isBooleanProp() {
            return this.booleanProp;
        }

        public void setBooleanProp(boolean booleanProp) {
            this.booleanProp = booleanProp;
        }

        public Timestamp getTimestampProp() {
            return this.timestampProp;
        }

        public void setTimestampProp(Timestamp timestampProp) {
            this.timestampProp = timestampProp;
        }

        public java.util.Date getDateProp() {
            return this.dateProp;
        }

        public void setDateProp(java.util.Date dateProp) {
            this.dateProp = dateProp;
        }

        public int getIntProp() {
            return this.intProp;
        }

        public BigDecimal getBigDecimalProp() {
            return this.bigDecimalProp;
        }

        public void setBigDecimalProp(BigDecimal bigDecimalProp) {
            this.bigDecimalProp = bigDecimalProp;
        }

        public void setIntProp(int intProp) {
            this.intProp = intProp;
        }

        public Integer getIntegerProp() {
            return this.integerProp;
        }

        public void setIntegerProp(Integer integerProp) {
            this.integerProp = integerProp;
        }

        public TestBean getNext() {
            return this.next;
        }

        public void setNext(TestBean next) {
            this.next = next;
        }

        public List<String> getStuffs() {
            return this.stuffs;
        }

        public void setStuffs(List<String> stuffs) {
            this.stuffs = stuffs;
        }

        public Object[] getArrayProp() {
            return this.arrayProp;
        }

        public void setArrayProp(Object[] arrayProp) {
            this.arrayProp = arrayProp;
        }

        public Map<String, Object> getMapProp() {
            return this.mapProp;
        }

        public void setMapProp(Map<String, Object> mapProp) {
            this.mapProp = mapProp;
        }

        public TestBeanTwo getComplexProp() {
            return this.complexProp;
        }

        public void setComplexProp(TestBeanTwo complexProp) {
            this.complexProp = complexProp;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TestAnnotation {
        public String afoo();
    }
}

