/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.uif.util.ProcessLoggingUnitTest;
import org.kuali.rice.krad.uif.util.ScriptUtils;

public class ScriptUtilsTest
extends ProcessLoggingUnitTest {
    @Test
    public void testEscapeHtml() throws Exception {
        Assert.assertEquals((Object)"wasn&apos;t", (Object)ScriptUtils.escapeHtml((String)"wasn't"));
        Assert.assertEquals((Object)"\\u0022wasn&apos;t\\u0022", (Object)ScriptUtils.escapeHtml((String)"\"wasn't\""));
    }

    @Test
    public void testEscapeHtmlStringList() {
        String[] escaped = new String[]{"wasn&apos;t", "\\u0022wasn&apos;t\\u0022"};
        String[] unEscaped = new String[]{"wasn't", "\"wasn't\""};
        Assert.assertEquals(Arrays.asList(escaped), (Object)ScriptUtils.escapeHtml(Arrays.asList(unEscaped)));
        List nullList = null;
        Assert.assertNull((Object)ScriptUtils.escapeHtml(nullList));
        List emptyList = Collections.emptyList();
        Assert.assertEquals(emptyList, (Object)ScriptUtils.escapeHtml(emptyList));
    }

    @Test
    public void testConvertToJSValue_function() {
        String jsFunction = "\n function () {alert('1 + 1 ' is 1 + 1);} \n\n";
        Assert.assertEquals((String)"function was not converted to js value as expected", (Object)jsFunction, (Object)ScriptUtils.convertToJsValue((String)jsFunction));
    }

    @Test
    public void testConvertToJSValue_numeric() {
        Assert.assertEquals((String)"number was not converted to js value as expected", (Object)" -1 ", (Object)ScriptUtils.convertToJsValue((String)" -1 "));
        Assert.assertEquals((String)"number was not converted to js value as expected", (Object)"1.01 ", (Object)ScriptUtils.convertToJsValue((String)"1.01 "));
        Assert.assertEquals((String)"string was not converted to js value as expected", (Object)"\"1.o1 \"", (Object)ScriptUtils.convertToJsValue((String)"1.o1 "));
    }

    @Test
    public void testConvertToJSValue_mapAndArray() {
        Assert.assertEquals((String)"array was not converted to js value as expected", (Object)" [-1, 4, 5] ", (Object)ScriptUtils.convertToJsValue((String)" [-1, 4, 5] "));
        String jsMap = " {'a':1, 'b':2} \n";
        Assert.assertEquals((String)"map was not converted to js value as expected", (Object)jsMap, (Object)ScriptUtils.convertToJsValue((String)jsMap));
    }

    @Test
    public void testBuildEventHandlerScript() {
        String onClickScript = "alert('A click happened');";
        String onClickHandler = ScriptUtils.buildEventHandlerScript((String)"u09", (String)"click", (String)onClickScript);
        String expectedHandler = "jQuery('#u09').on('click', function(e) {" + onClickScript + "}); ";
        Assert.assertEquals((String)"generate event script is not correct", (Object)expectedHandler, (Object)onClickHandler);
    }
}

