/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.controller;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.test.MockController;
import org.kuali.rice.krad.test.TestForm;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.web.controller.MethodAccessException;
import org.kuali.rice.krad.web.controller.UifControllerHandlerInterceptor;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.form.UifFormManager;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.web.method.HandlerMethod;

public class UifControllerHandlerInterceptorTest {
    private UifControllerHandlerInterceptor handlerInterceptor;
    private MockController controller;
    private MockHttpServletRequest request;
    private UifFormBase model;

    @Before
    public void setUp() throws Exception {
        this.request = new MockHttpServletRequest();
        this.request.setMethod("POST");
        UifFormManager uifFormManager = new UifFormManager();
        String formKey = "TEST";
        this.model = new TestForm();
        this.model.setFormKey(formKey);
        uifFormManager.addSessionForm(this.model);
        this.request.getSession().setAttribute("formManager", (Object)uifFormManager);
        this.request.setParameter("formKey", formKey);
        this.handlerInterceptor = new UifControllerHandlerInterceptor();
        this.controller = new MockController();
    }

    @Test
    public void testCheckHandlerMethodAccess() throws Exception {
        ViewPostMetadata viewPostMetadata = new ViewPostMetadata();
        this.model.setViewPostMetadata(viewPostMetadata);
        this.assertMethodAccess("Accessible annotation not picked up", "method1", true);
        this.assertMethodAccess("Custom method should be allowed due to not being in the available methods", "method2", true);
        viewPostMetadata.addAvailableMethodToCall("method2");
        this.assertMethodAccess("Accessible annotation picked up where not present", "method2", false);
        viewPostMetadata.addAccessibleMethodToCall("method4");
        viewPostMetadata.addAccessibleMethodToCall("method6");
        this.assertMethodAccess("Accessible method by view not picked up", "method4", true);
        this.assertMethodAccess("Accessible method by view not picked up", "method6", true);
        this.assertMethodAccess("Method not accessible for empty method to call", null, true);
    }

    protected void assertMethodAccess(String failureMessage, String methodToCall, boolean access) throws Exception {
        this.request.setParameter("methodToCall", methodToCall);
        if (StringUtils.isBlank((CharSequence)methodToCall)) {
            methodToCall = "method5";
        }
        try {
            this.handlerInterceptor.checkHandlerMethodAccess((HttpServletRequest)this.request, (Object)this.getHandlerMethod(methodToCall));
        }
        catch (MethodAccessException e) {
            if (access) {
                Assert.fail((String)failureMessage);
            }
            return;
        }
        if (!access) {
            Assert.fail((String)failureMessage);
        }
    }

    protected HandlerMethod getHandlerMethod(String methodToCall) {
        Method method = null;
        for (Method controllerMethod : this.controller.getClass().getMethods()) {
            if (!StringUtils.equals((CharSequence)controllerMethod.getName(), (CharSequence)methodToCall)) continue;
            method = controllerMethod;
        }
        if (method != null) {
            return new HandlerMethod((Object)this.controller, method);
        }
        return null;
    }
}

