/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.ReferenceDefinition;
import org.kuali.rice.krad.datadictionary.WorkflowAttributes;
import org.kuali.rice.krad.datadictionary.WorkflowProperties;
import org.kuali.rice.krad.datadictionary.exception.DuplicateEntryException;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizer;
import org.kuali.rice.krad.document.DocumentAuthorizerBase;
import org.kuali.rice.krad.document.DocumentPresentationController;
import org.kuali.rice.krad.document.DocumentPresentationControllerBase;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public abstract class DocumentEntry
extends DataDictionaryEntryBase {
    private static final long serialVersionUID = 8231730871830055356L;
    private static final Logger LOG = Logger.getLogger(DocumentEntry.class);
    protected String documentTypeName;
    protected Class<? extends Document> documentClass;
    protected Class<? extends Document> baseDocumentClass;
    protected Class<? extends BusinessRule> businessRulesClass;
    protected boolean allowsNoteAttachments = true;
    protected boolean allowsNoteFYI = false;
    protected Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass;
    protected boolean displayTopicFieldInNotes = false;
    protected boolean usePessimisticLocking = false;
    protected boolean useWorkflowPessimisticLocking = false;
    protected boolean encryptDocumentDataInPersistentSessionStorage = false;
    protected boolean allowsCopy = false;
    protected WorkflowProperties workflowProperties;
    protected WorkflowAttributes workflowAttributes;
    protected Class<? extends DocumentAuthorizer> documentAuthorizerClass = DocumentAuthorizerBase.class;
    protected Class<? extends DocumentPresentationController> documentPresentationControllerClass = DocumentPresentationControllerBase.class;
    protected List<ReferenceDefinition> defaultExistenceChecks = new ArrayList<ReferenceDefinition>();
    protected Map<String, ReferenceDefinition> defaultExistenceCheckMap = new LinkedHashMap<String, ReferenceDefinition>();

    @Override
    public String getJstlKey() {
        return this.documentTypeName;
    }

    public void setDocumentClass(Class<? extends Document> documentClass) {
        if (documentClass == null) {
            throw new IllegalArgumentException("invalid (null) documentClass");
        }
        this.documentClass = documentClass;
    }

    @BeanTagAttribute(name="documentClass")
    public Class<? extends Document> getDocumentClass() {
        return this.documentClass;
    }

    public void setBaseDocumentClass(Class<? extends Document> baseDocumentClass) {
        this.baseDocumentClass = baseDocumentClass;
    }

    @BeanTagAttribute(name="getBaseDocumentClass")
    public Class<? extends Document> getBaseDocumentClass() {
        return this.baseDocumentClass;
    }

    public void setBusinessRulesClass(Class<? extends BusinessRule> businessRulesClass) {
        this.businessRulesClass = businessRulesClass;
    }

    @BeanTagAttribute(name="businessRulesClass")
    public Class<? extends BusinessRule> getBusinessRulesClass() {
        return this.businessRulesClass;
    }

    public void setDocumentTypeName(String documentTypeName) {
        if (StringUtils.isBlank((String)documentTypeName)) {
            throw new IllegalArgumentException("invalid (blank) documentTypeName");
        }
        this.documentTypeName = documentTypeName;
    }

    @BeanTagAttribute(name="documentTypeName")
    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    @Override
    public void dataDictionaryPostProcessing() {
        super.dataDictionaryPostProcessing();
        if (this.defaultExistenceChecks != null) {
            this.defaultExistenceCheckMap.clear();
            for (ReferenceDefinition reference : this.defaultExistenceChecks) {
                String keyName;
                if (reference == null) continue;
                String string = keyName = reference.isCollectionReference() ? reference.getCollection() + "." + reference.getAttributeName() : reference.getAttributeName();
                if (this.defaultExistenceCheckMap.containsKey(keyName)) {
                    throw new DuplicateEntryException("duplicate defaultExistenceCheck entry for attribute '" + keyName + "'");
                }
                reference.setBusinessObjectClass(this.getEntryClass());
                this.defaultExistenceCheckMap.put(keyName, reference);
            }
        }
        if (this.workflowAttributes != null) {
            this.workflowAttributes.dataDictionaryPostProcessing();
        }
        for (ReferenceDefinition refDef : this.defaultExistenceChecks) {
            refDef.dataDictionaryPostProcessing();
        }
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this.getClass().getSimpleName(), this.getDocumentTypeName());
        if (this.workflowProperties != null && this.workflowAttributes != null) {
            String[] currentValues = new String[]{"workflowProperties = " + this.getWorkflowProperties(), "workflowAttributes = " + this.getWorkflowAttributes()};
            tracer.createError("WorkflowProperties and workflowAttributes cannot both be defined for a document", currentValues);
        }
        this.validateDefaultExistenceChecks(tracer);
        super.completeValidation(tracer.getCopy());
    }

    protected void validateDefaultExistenceChecks(ValidationTrace tracer) {
        for (ReferenceDefinition refDef : this.defaultExistenceChecks) {
            refDef.completeValidation(this.documentClass, null, tracer.getCopy());
        }
    }

    @Override
    public String getFullClassName() {
        if (this.getBaseDocumentClass() != null) {
            return this.getBaseDocumentClass().getName();
        }
        if (this.getDocumentClass() != null) {
            return this.getDocumentClass().getName();
        }
        return "";
    }

    public Class getEntryClass() {
        return this.getDocumentClass();
    }

    @BeanTagAttribute(name="displayTopicFieldInNotes")
    public boolean getDisplayTopicFieldInNotes() {
        return this.displayTopicFieldInNotes;
    }

    public void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes) {
        this.displayTopicFieldInNotes = displayTopicFieldInNotes;
    }

    @BeanTagAttribute(name="usePessimisticLocking")
    public boolean getUsePessimisticLocking() {
        return this.usePessimisticLocking;
    }

    public void setUsePessimisticLocking(boolean usePessimisticLocking) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calling setUsePessimisticLocking '" + usePessimisticLocking + "'"));
        }
        this.usePessimisticLocking = usePessimisticLocking;
    }

    @BeanTagAttribute(name="useWorkflowPessimisticLocking")
    public boolean getUseWorkflowPessimisticLocking() {
        return this.useWorkflowPessimisticLocking;
    }

    public void setUseWorkflowPessimisticLocking(boolean useWorkflowPessimisticLocking) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("calling setuseWorkflowPessimisticLocking '" + useWorkflowPessimisticLocking + "'"));
        }
        this.useWorkflowPessimisticLocking = useWorkflowPessimisticLocking;
    }

    public void setAttachmentTypesValuesFinderClass(Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass) {
        if (attachmentTypesValuesFinderClass == null) {
            throw new IllegalArgumentException("invalid (null) attachmentTypesValuesFinderClass");
        }
        this.attachmentTypesValuesFinderClass = attachmentTypesValuesFinderClass;
    }

    @BeanTagAttribute(name="attachmentTypesValuesFinderClass")
    public Class<? extends KeyValuesFinder> getAttachmentTypesValuesFinderClass() {
        return this.attachmentTypesValuesFinderClass;
    }

    public void setAllowsCopy(boolean allowsCopy) {
        this.allowsCopy = allowsCopy;
    }

    @BeanTagAttribute(name="allowsCopy")
    public boolean getAllowsCopy() {
        return this.allowsCopy;
    }

    @BeanTagAttribute(name="allowsNoteAttachments")
    public boolean getAllowsNoteAttachments() {
        return this.allowsNoteAttachments;
    }

    public void setAllowsNoteAttachments(boolean allowsNoteAttachments) {
        this.allowsNoteAttachments = allowsNoteAttachments;
    }

    @BeanTagAttribute(name="allowsNoteFYI")
    public boolean getAllowsNoteFYI() {
        return this.allowsNoteFYI;
    }

    public void setAllowsNoteFYI(boolean allowsNoteFYI) {
        this.allowsNoteFYI = allowsNoteFYI;
    }

    @BeanTagAttribute(name="workflowProperties", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public WorkflowProperties getWorkflowProperties() {
        return this.workflowProperties;
    }

    public void setWorkflowProperties(WorkflowProperties workflowProperties) {
        this.workflowProperties = workflowProperties;
    }

    @BeanTagAttribute(name="workflowAttributes", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public WorkflowAttributes getWorkflowAttributes() {
        return this.workflowAttributes;
    }

    public void setWorkflowAttributes(WorkflowAttributes workflowAttributes) {
        this.workflowAttributes = workflowAttributes;
    }

    @BeanTagAttribute(name="documentAuthorizerClass")
    public Class<? extends DocumentAuthorizer> getDocumentAuthorizerClass() {
        return this.documentAuthorizerClass;
    }

    public void setDocumentAuthorizerClass(Class<? extends DocumentAuthorizer> documentAuthorizerClass) {
        this.documentAuthorizerClass = documentAuthorizerClass;
    }

    @BeanTagAttribute(name="documentPresentationControllerClass")
    public Class<? extends DocumentPresentationController> getDocumentPresentationControllerClass() {
        return this.documentPresentationControllerClass;
    }

    public void setDocumentPresentationControllerClass(Class<? extends DocumentPresentationController> documentPresentationControllerClass) {
        this.documentPresentationControllerClass = documentPresentationControllerClass;
    }

    @BeanTagAttribute(name="defaultExistenceChecks", type=BeanTagAttribute.AttributeType.LISTBEAN)
    public List<ReferenceDefinition> getDefaultExistenceChecks() {
        return this.defaultExistenceChecks;
    }

    public void setDefaultExistenceChecks(List<ReferenceDefinition> defaultExistenceChecks) {
        this.defaultExistenceChecks = defaultExistenceChecks;
    }

    public List<String> getDefaultExistenceCheckFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.addAll(this.defaultExistenceCheckMap.keySet());
        return fieldNames;
    }

    @BeanTagAttribute(name="encryptDocumentDataInPersistentSessionStorage")
    public boolean isEncryptDocumentDataInPersistentSessionStorage() {
        return this.encryptDocumentDataInPersistentSessionStorage;
    }

    public void setEncryptDocumentDataInPersistentSessionStorage(boolean encryptDocumentDataInPersistentSessionStorage) {
        this.encryptDocumentDataInPersistentSessionStorage = encryptDocumentDataInPersistentSessionStorage;
    }
}

