/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.control.ControlDefinition;
import org.kuali.rice.krad.datadictionary.exception.CompletionException;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

@BeanTag(name="externalizableAttributeDefinitionProxy")
public class ExternalizableAttributeDefinitionProxy
extends AttributeDefinition {
    private static final long serialVersionUID = -3204870440281417429L;
    private static Log LOG = LogFactory.getLog(ExternalizableAttributeDefinitionProxy.class);
    private String sourceExternalizableBusinessObjectInterface;
    private String sourceAttributeName;
    private AttributeDefinition delegate;

    public ExternalizableAttributeDefinitionProxy() {
        LOG.debug((Object)"creating new ExternalizableAttributeDefinitionProxy");
    }

    public void setSourceExternalizableBusinessObjectInterface(String sourceClassName) {
        if (StringUtils.isBlank((String)sourceClassName)) {
            throw new IllegalArgumentException("invalid (blank) sourceClassName");
        }
        this.sourceExternalizableBusinessObjectInterface = sourceClassName;
    }

    @BeanTagAttribute(name="sourceExternalizableBusinessObjectInterface")
    public String getSourceExternalizableBusinessObjectInterface() {
        return this.sourceExternalizableBusinessObjectInterface;
    }

    public void setSourceAttributeName(String sourceAttributeName) {
        if (StringUtils.isBlank((String)sourceAttributeName)) {
            throw new IllegalArgumentException("invalid (blank) sourceAttributeName");
        }
        this.sourceAttributeName = sourceAttributeName;
    }

    @BeanTagAttribute(name="sourceAttributeName")
    public String getSourceAttributeName() {
        return this.sourceAttributeName;
    }

    @BeanTagAttribute(name="delegate", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    AttributeDefinition getDelegate() {
        BusinessObjectEntry delegateEntry = null;
        if (this.delegate == null) {
            try {
                delegateEntry = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(Class.forName(this.getSourceExternalizableBusinessObjectInterface())).getExternalizableBusinessObjectDictionaryEntry(Class.forName(this.getSourceExternalizableBusinessObjectInterface()));
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Unable to get delegate entry for sourceExternalizableBusinessObjectInterface", (Throwable)e);
            }
            if (delegateEntry == null) {
                throw new CompletionException("no BusinessObjectEntry exists for sourceClassName '" + this.getSourceExternalizableBusinessObjectInterface() + "'");
            }
            this.delegate = delegateEntry.getAttributeDefinition(this.getSourceAttributeName());
            if (this.delegate == null) {
                throw new CompletionException("no AttributeDefnintion exists for sourceAttributeName '" + this.getSourceExternalizableBusinessObjectInterface() + "." + this.getSourceAttributeName() + "'");
            }
        }
        return this.delegate;
    }

    void setDelegate(AttributeDefinition delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("invalid (null) delegate");
        }
        this.delegate = delegate;
    }

    @Override
    public Boolean getForceUppercase() {
        Boolean value = super.getForceUppercase();
        if (value == null) {
            value = this.getDelegate().getForceUppercase();
        }
        return value;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = this.getDelegate().getName();
        }
        return name;
    }

    @Override
    public String getLabel() {
        String label = super.getLabel();
        if (label == null) {
            label = this.getDelegate().getLabel();
        }
        return label;
    }

    @Override
    public String getShortLabel() {
        String shortLabel = super.getDirectShortLabel();
        if (shortLabel == null) {
            shortLabel = this.getDelegate().getShortLabel();
        }
        return shortLabel;
    }

    @Override
    public Integer getMaxLength() {
        Integer maxLength = super.getMaxLength();
        if (maxLength == null) {
            maxLength = this.getDelegate().getMaxLength();
        }
        return maxLength;
    }

    @Override
    public boolean hasValidationPattern() {
        return this.getValidationPattern() != null;
    }

    @Override
    public ValidationPattern getValidationPattern() {
        ValidationPattern validationPattern = super.getValidationPattern();
        if (validationPattern == null) {
            validationPattern = this.getDelegate().getValidationPattern();
        }
        return validationPattern;
    }

    @Override
    public Boolean isRequired() {
        Boolean required = super.isRequired();
        if (required == null) {
            required = this.getDelegate().isRequired();
        }
        return required;
    }

    @Override
    public ControlDefinition getControl() {
        ControlDefinition control = super.getControl();
        if (control == null) {
            control = this.getDelegate().getControl();
        }
        return control;
    }

    @Override
    public String getSummary() {
        String summary = super.getSummary();
        if (summary == null) {
            summary = this.getDelegate().getSummary();
        }
        return summary;
    }

    @Override
    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            description = this.getDelegate().getDescription();
        }
        return description;
    }

    @Override
    public boolean hasFormatterClass() {
        return this.getFormatterClass() != null;
    }

    @Override
    public String getFormatterClass() {
        String formatterClass = super.getFormatterClass();
        if (formatterClass == null) {
            formatterClass = this.getDelegate().getFormatterClass();
        }
        return formatterClass;
    }

    @Override
    public String getDisplayLabelAttribute() {
        String displayLabelAttribute = super.getDisplayLabelAttribute();
        if (StringUtils.isBlank((String)displayLabelAttribute)) {
            displayLabelAttribute = this.getDelegate().getDisplayLabelAttribute();
        }
        return displayLabelAttribute;
    }

    @Override
    public void completeValidation(Class rootObjectClass, Class otherObjectClass, ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this.getClass().getSimpleName(), "id: " + this.getId());
        if (StringUtils.isBlank((String)this.sourceExternalizableBusinessObjectInterface)) {
            currentValues = new String[]{"property = " + this.getName(), "class = " + rootObjectClass.getName()};
            tracer.createError("invalid (blank) sourceClassName for", currentValues);
        }
        if (StringUtils.isBlank((String)this.sourceAttributeName)) {
            currentValues = new String[]{"property = " + this.getName(), "class = " + rootObjectClass.getName()};
            tracer.createError("invalid (blank) sourceAttributeName for", currentValues);
        }
        if (DataDictionary.validateEBOs) {
            this.getDelegate();
            super.completeValidation(rootObjectClass, otherObjectClass, tracer);
        }
    }

    public String toString() {
        String name = super.getName();
        if (name == null && this.getDelegate() != null) {
            name = this.getDelegate().getName();
        }
        return "AttributeReferenceDefinition for attribute " + name;
    }
}

