/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.parse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttributeInfo;
import org.kuali.rice.krad.datadictionary.parse.BeanTagInfo;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CustomTagAnnotations {
    private static final Log LOG = LogFactory.getLog(CustomTagAnnotations.class);
    private static Map<String, Map<String, BeanTagAttributeInfo>> attributeProperties;
    private static Map<String, BeanTagInfo> beanTags;
    private static Set<Class<?>> customTagClasses;
    private static Map<Class<?>, Set<String>> beanTagsByClass;

    private CustomTagAnnotations() {
    }

    public static void loadTagClasses() {
        String scanPackagesStr = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("rice.krad.schema.packages");
        String[] scanPackages = StringUtils.split((String)scanPackagesStr, (String)",");
        CustomTagAnnotations.loadTagClasses(scanPackages);
    }

    public static void loadTagClasses(String[] scanPackages) {
        customTagClasses = new HashSet();
        for (String scanPackage : scanPackages) {
            try {
                customTagClasses.addAll(CustomTagAnnotations.findTagClasses(StringUtils.trim((String)scanPackage)));
            }
            catch (Exception e) {
                throw new RuntimeException("unable to scan package: " + scanPackage, e);
            }
        }
    }

    protected static List<Class<?>> findTagClasses(String basePackage) throws IOException, ClassNotFoundException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        ArrayList classes = new ArrayList();
        String resolvedBasePackage = ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
        String packageSearchPath = "classpath*:" + resolvedBasePackage + "/" + "**/*.class";
        for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
            MetadataReader metadataReader;
            if (!resource.isReadable() || (metadataReader = metadataReaderFactory.getMetadataReader(resource)) == null || !CustomTagAnnotations.isBeanTag(metadataReader)) continue;
            classes.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
        }
        return classes;
    }

    protected static boolean isBeanTag(MetadataReader metadataReader) {
        try {
            Class<?> c = Class.forName(metadataReader.getClassMetadata().getClassName());
            if (c.getAnnotation(BeanTag.class) != null || c.getAnnotation(BeanTags.class) != null) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    protected static void loadAttributeProperties(String tagName, Class<?> tagClass) {
        HashMap<String, BeanTagAttributeInfo> entries = new HashMap<String, BeanTagAttributeInfo>();
        entries.putAll(CustomTagAnnotations.getAttributes(tagClass));
        attributeProperties.put(tagName, entries);
    }

    public static Map<String, BeanTagAttributeInfo> getAttributes(Class<?> tagClass) {
        Method[] methods;
        HashMap<String, BeanTagAttributeInfo> entries = new HashMap<String, BeanTagAttributeInfo>();
        for (Method attributeMethod : methods = tagClass.getMethods()) {
            BeanTagAttribute attribute = attributeMethod.getAnnotation(BeanTagAttribute.class);
            if (attribute == null) continue;
            BeanTagAttributeInfo info = new BeanTagAttributeInfo();
            String propertyName = CustomTagAnnotations.getFieldName(attributeMethod.getName());
            info.setPropertyName(propertyName);
            if (StringUtils.isBlank((String)attribute.name())) {
                info.setName(propertyName);
            } else {
                info.setName(attribute.name());
            }
            if (BeanTagAttribute.AttributeType.NOTSET.equals((Object)attribute.type())) {
                BeanTagAttribute.AttributeType derivedType = CustomTagAnnotations.deriveTypeFromMethod(attributeMethod);
                if (derivedType != null) {
                    info.setType(derivedType);
                }
            } else {
                info.setType(attribute.type());
            }
            info.setValueType(attributeMethod.getReturnType());
            info.setGenericType(attributeMethod.getGenericReturnType());
            CustomTagAnnotations.validateBeanAttributes(tagClass.getName(), attribute.name(), entries);
            entries.put(info.getName(), info);
        }
        return entries;
    }

    protected static BeanTagAttribute.AttributeType deriveTypeFromMethod(Method attributeMethod) {
        BeanTagAttribute.AttributeType type = null;
        Class<?> returnType = attributeMethod.getReturnType();
        Type genericReturnType = attributeMethod.getGenericReturnType();
        if (TypeUtils.isSimpleType(returnType) || TypeUtils.isClassClass(returnType) || Enum.class.isAssignableFrom(returnType)) {
            type = BeanTagAttribute.AttributeType.SINGLEVALUE;
        } else if (returnType.isArray() || List.class.isAssignableFrom(returnType)) {
            Type genericParm;
            type = BeanTagAttribute.AttributeType.LISTBEAN;
            if (genericReturnType instanceof ParameterizedType && ((ParameterizedType)genericReturnType).getActualTypeArguments().length == 1 && CustomTagAnnotations.isValueType(genericParm = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0])) {
                type = BeanTagAttribute.AttributeType.LISTVALUE;
            }
        } else if (Set.class.isAssignableFrom(returnType)) {
            Type genericParm;
            type = BeanTagAttribute.AttributeType.SETBEAN;
            if (genericReturnType instanceof ParameterizedType && ((ParameterizedType)genericReturnType).getActualTypeArguments().length == 1 && CustomTagAnnotations.isValueType(genericParm = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0])) {
                type = BeanTagAttribute.AttributeType.SETVALUE;
            }
        } else if (Map.class.isAssignableFrom(returnType)) {
            type = BeanTagAttribute.AttributeType.MAPBEAN;
            if (genericReturnType instanceof ParameterizedType && ((ParameterizedType)genericReturnType).getActualTypeArguments().length == 2) {
                Type genericParmKey = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                Type genericParmValue = ((ParameterizedType)genericReturnType).getActualTypeArguments()[1];
                if (CustomTagAnnotations.isValueType(genericParmKey) && CustomTagAnnotations.isValueType(genericParmValue)) {
                    type = BeanTagAttribute.AttributeType.MAPVALUE;
                }
            }
        } else {
            type = BeanTagAttribute.AttributeType.SINGLEBEAN;
        }
        return type;
    }

    protected static boolean isValueType(Type type) {
        Class typeClass;
        return type instanceof Class && (TypeUtils.isSimpleType((Class)(typeClass = (Class)type)) || Object.class.equals((Object)typeClass));
    }

    protected static boolean isBeanType(Type type) {
        Class typeClass;
        return type instanceof Class && !TypeUtils.isSimpleType((Class)(typeClass = (Class)type));
    }

    protected static void loadBeanTags() {
        if (customTagClasses == null) {
            CustomTagAnnotations.loadTagClasses();
        }
        beanTags = new HashMap<String, BeanTagInfo>();
        attributeProperties = new HashMap<String, Map<String, BeanTagAttributeInfo>>();
        beanTagsByClass = new HashMap();
        for (Class<?> tagClass : customTagClasses) {
            BeanTag[] annotations = new BeanTag[1];
            BeanTag tag = tagClass.getAnnotation(BeanTag.class);
            if (tag != null) {
                annotations[0] = tag;
            } else {
                BeanTags tags = tagClass.getAnnotation(BeanTags.class);
                if (tags == null) continue;
                annotations = tags.value();
            }
            HashSet<String> classBeanTags = new HashSet<String>();
            for (int j = 0; j < annotations.length; ++j) {
                BeanTag annotation = annotations[j];
                BeanTagInfo info = new BeanTagInfo();
                info.setTag(annotation.name());
                if (j == 0) {
                    info.setDefaultTag(true);
                }
                info.setBeanClass(tagClass);
                info.setParent(annotation.parent());
                CustomTagAnnotations.validateBeanTag(annotation.name());
                beanTags.put(annotation.name(), info);
                CustomTagAnnotations.loadAttributeProperties(annotation.name(), tagClass);
                classBeanTags.add(annotation.name());
            }
            beanTagsByClass.put(tagClass, classBeanTags);
        }
    }

    private static String getFieldName(String methodName) {
        if (methodName.substring(0, 2).toLowerCase().compareTo("is") == 0) {
            String letter = methodName.substring(2, 3);
            return letter.toLowerCase() + methodName.substring(3, methodName.length());
        }
        String letter = methodName.substring(3, 4);
        return letter.toLowerCase() + methodName.substring(4, methodName.length());
    }

    protected static boolean validateBeanTag(String tagName) {
        boolean valid = true;
        Set<String> tagNames = beanTags.keySet();
        if (tagNames.contains(tagName)) {
            LOG.error((Object)("Duplicate tag name " + tagName));
            valid = false;
        }
        return valid;
    }

    private static boolean validateBeanAttributes(String className, String tagName, Map<String, BeanTagAttributeInfo> attributes) {
        boolean valid = true;
        if (tagName.compareTo("parent") == 0 || tagName.compareTo("ref") == 0 || tagName.compareTo("abstract") == 0) {
            return false;
        }
        String[] tags = new String[attributes.keySet().size()];
        tags = attributes.keySet().toArray(tags);
        for (int j = 0; j < tags.length; ++j) {
            if (tagName.compareTo(tags[j]) != 0) continue;
            LOG.error((Object)("Duplicate attribute tag name " + tagName + " in bean " + className));
            valid = false;
        }
        return valid;
    }

    public static Map<String, BeanTagInfo> getBeanTags() {
        if (beanTags == null || beanTags.isEmpty()) {
            CustomTagAnnotations.loadBeanTags();
        }
        return beanTags;
    }

    public static Set<String> getBeanTagsByClass(Class<?> clazz) {
        Set<String> beanTags = null;
        if (beanTagsByClass != null && beanTagsByClass.containsKey(clazz)) {
            beanTags = beanTagsByClass.get(clazz);
        }
        if (beanTags == null) {
            CustomTagAnnotations.loadBeanTags();
        }
        return beanTags;
    }

    public static Map<String, Map<String, BeanTagAttributeInfo>> getAttributeProperties() {
        if (attributeProperties == null || attributeProperties.isEmpty()) {
            CustomTagAnnotations.loadBeanTags();
        }
        return attributeProperties;
    }

    public static String findPropertyByType(String parentTag, String childTag) {
        String propertyName = null;
        Class<?> childTagClass = beanTags.get(childTag).getBeanClass();
        Map<String, BeanTagAttributeInfo> propertyInfos = attributeProperties.get(parentTag);
        for (Map.Entry<String, BeanTagAttributeInfo> propertyInfo : propertyInfos.entrySet()) {
            BeanTagAttributeInfo info = propertyInfo.getValue();
            if (!info.getType().equals((Object)BeanTagAttribute.AttributeType.BYTYPE) && !info.getType().equals((Object)BeanTagAttribute.AttributeType.DIRECTORBYTYPE) || !info.getValueType().isAssignableFrom(childTagClass)) continue;
            propertyName = info.getPropertyName();
        }
        return propertyName;
    }

    private static ArrayList<String> getClassList(String path) {
        ArrayList<String> completeList = new ArrayList<String>();
        try {
            int i;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ClassPathXmlApplicationContext app = new ClassPathXmlApplicationContext();
            InputStream stream = app.getResource(path).getInputStream();
            Document document = builder.parse(stream);
            NodeList classes = document.getElementsByTagName("class");
            String classList = "";
            for (int i2 = 0; i2 < classes.getLength(); ++i2) {
                classList = classList + classes.item(i2).getTextContent() + ",";
            }
            if (classList.length() > 0) {
                if (classList.charAt(classList.length() - 1) == ',') {
                    classList = classList.substring(0, classList.length() - 1);
                }
                String[] list = classList.split(",");
                for (i = 0; i < list.length; ++i) {
                    completeList.add(list[i]);
                }
            }
            NodeList includes = document.getElementsByTagName("include");
            for (i = 0; i < includes.getLength(); ++i) {
                completeList.addAll(CustomTagAnnotations.getClassList(includes.item(i).getTextContent()));
            }
        }
        catch (Exception e) {
            try {
                int i;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                File file = new File(path);
                Document document = builder.parse(file);
                NodeList classes = document.getElementsByTagName("class");
                String classList = "";
                for (int i3 = 0; i3 < classes.getLength(); ++i3) {
                    classList = classList + classes.item(i3).getTextContent() + ",";
                }
                if (classList.length() > 0) {
                    if (classList.charAt(classList.length() - 1) == ',') {
                        classList = classList.substring(0, classList.length() - 1);
                    }
                    String[] list = classList.split(",");
                    for (i = 0; i < list.length; ++i) {
                        completeList.add(list[i]);
                    }
                }
                NodeList includes = document.getElementsByTagName("include");
                for (i = 0; i < includes.getLength(); ++i) {
                    completeList.addAll(CustomTagAnnotations.getClassList(includes.item(i).getTextContent()));
                }
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        return completeList;
    }
}

