/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Help;

@BeanTags(value={@BeanTag(name="header", parent="Uif-HeaderBase"), @BeanTag(name="headerOne", parent="Uif-HeaderOne"), @BeanTag(name="headerTwo", parent="Uif-HeaderTwo"), @BeanTag(name="headerThree", parent="Uif-HeaderThree"), @BeanTag(name="headerFour", parent="Uif-HeaderFour"), @BeanTag(name="headerFive", parent="Uif-HeaderFive"), @BeanTag(name="headerSix", parent="Uif-HeaderSix"), @BeanTag(name="pageHeader", parent="Uif-PageHeader"), @BeanTag(name="sectionHeader", parent="Uif-SectionHeader"), @BeanTag(name="subSectionHeader", parent="Uif-SubSectionHeader"), @BeanTag(name="subCollectionHeader", parent="Uif-SubCollectionHeader")})
public class Header
extends ContentElementBase {
    private static final long serialVersionUID = -6950408292923393244L;
    private String headerText;
    private String headerLevel;
    private String headerTagStyle;
    private List<String> headerTagCssClasses = new ArrayList<String>();
    private boolean headerTagOnly;
    private Message richHeaderMessage;
    private List<Component> inlineComponents;
    private Group upperGroup;
    private Group rightGroup;
    private Group lowerGroup;
    private boolean renderWrapper = true;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.richHeaderMessage == null && this.headerText != null && this.headerText.contains("[") && this.headerText.contains("]")) {
            Message message = ComponentFactory.getMessage();
            message.setMessageText(this.headerText);
            message.setInlineComponents(this.inlineComponents);
            message.setRenderWrapperTag(false);
            this.setRichHeaderMessage(message);
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.getUpperGroup() != null && this.getUpperGroup().getItems().isEmpty()) {
            this.getUpperGroup().setRender(false);
        }
        if (this.getRightGroup() != null && this.getRightGroup().getItems().isEmpty()) {
            this.getRightGroup().setRender(false);
        }
        if (this.getLowerGroup() != null && this.getLowerGroup().getItems().isEmpty()) {
            this.getLowerGroup().setRender(false);
        }
        if (this.getUpperGroup() != null) {
            this.getUpperGroup().addStyleClass("uif-header-upperGroup");
        }
        if (this.getRightGroup() != null) {
            this.getRightGroup().addStyleClass("uif-header-rightGroup");
        }
        if (this.getLowerGroup() != null) {
            this.getLowerGroup().addStyleClass("uif-header-lowerGroup");
        }
    }

    @Override
    public List<String> getAdditionalTemplates() {
        List<String> additionalTemplates = super.getAdditionalTemplates();
        Object parent = this.getContext().get("parent");
        Help help = null;
        if (parent instanceof Group) {
            help = ((Group)parent).getHelp();
        } else if (parent instanceof View) {
            help = ((View)parent).getHelp();
        }
        if (help != null) {
            String helpTemplate = help.getTemplate();
            if (additionalTemplates.isEmpty()) {
                additionalTemplates = new ArrayList<String>();
            }
            additionalTemplates.add(helpTemplate);
        }
        return additionalTemplates;
    }

    @BeanTagAttribute
    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    @BeanTagAttribute
    public String getHeaderLevel() {
        return this.headerLevel;
    }

    public void setHeaderLevel(String headerLevel) {
        this.headerLevel = headerLevel;
    }

    @BeanTagAttribute
    public List<String> getHeaderTagCssClasses() {
        return this.headerTagCssClasses;
    }

    public void setHeaderTagCssClasses(List<String> headerTagCssClasses) {
        this.headerTagCssClasses = headerTagCssClasses;
    }

    public String getHeaderStyleClassesAsString() {
        if (this.headerTagCssClasses != null) {
            return StringUtils.join(this.headerTagCssClasses, (String)" ");
        }
        return "";
    }

    @BeanTagAttribute
    public String getHeaderTagStyle() {
        return this.headerTagStyle;
    }

    public void setHeaderTagStyle(String headerTagStyle) {
        this.headerTagStyle = headerTagStyle;
    }

    @BeanTagAttribute
    public boolean isHeaderTagOnly() {
        return this.headerTagOnly;
    }

    public void setHeaderTagOnly(boolean headerTagOnly) {
        this.headerTagOnly = headerTagOnly;
    }

    @BeanTagAttribute
    public Group getUpperGroup() {
        return this.upperGroup;
    }

    public void setUpperGroup(Group upperGroup) {
        this.upperGroup = upperGroup;
    }

    @BeanTagAttribute
    public Group getRightGroup() {
        return this.rightGroup;
    }

    public void setRightGroup(Group rightGroup) {
        this.rightGroup = rightGroup;
    }

    @BeanTagAttribute
    public Group getLowerGroup() {
        return this.lowerGroup;
    }

    public void setLowerGroup(Group lowerGroup) {
        this.lowerGroup = lowerGroup;
    }

    @ViewLifecycleRestriction
    @BeanTagAttribute
    public List<? extends Component> getItems() {
        if (this.lowerGroup != null) {
            return this.lowerGroup.getItems();
        }
        return null;
    }

    public void setItems(List<? extends Component> items) {
        if (this.lowerGroup != null) {
            this.lowerGroup.setItems(items);
        }
    }

    @BeanTagAttribute
    public Message getRichHeaderMessage() {
        return this.richHeaderMessage;
    }

    public void setRichHeaderMessage(Message richHeaderMessage) {
        this.richHeaderMessage = richHeaderMessage;
    }

    @BeanTagAttribute
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this);
        String headerLevel = this.getHeaderLevel().toUpperCase();
        boolean correctHeaderLevel = false;
        if (headerLevel.compareTo("H1") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H2") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H3") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H4") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H5") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("H6") == 0) {
            correctHeaderLevel = true;
        } else if (headerLevel.compareTo("LABEL") == 0) {
            correctHeaderLevel = true;
        }
        if (!correctHeaderLevel) {
            currentValues = new String[]{"headerLevel =" + this.getHeaderLevel()};
            tracer.createError("HeaderLevel must be of values h1, h2, h3, h4, h5, h6, or label", currentValues);
        }
        if (this.getHeaderText() == null && !Validator.checkExpressions(this, "headerText")) {
            currentValues = new String[]{"headertText =" + this.getHeaderText()};
            tracer.createWarning("HeaderText should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

