/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.service.ViewValidationService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.service.ViewService;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.util.UifRenderHelperMethods;
import org.kuali.rice.krad.uif.view.MessageView;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.UrlFactory;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.springframework.web.servlet.ModelAndView;

public class ModelAndViewServiceImpl
implements ModelAndViewService {
    private static final Logger LOG = Logger.getLogger(ModelAndViewServiceImpl.class);
    private ViewService viewService;
    private ViewValidationService viewValidationService;

    @Override
    public ModelAndView checkForm(UifFormBase form) {
        this.getViewValidationService().validateViewSimulation(form);
        return this.getModelAndView(form);
    }

    @Override
    public ModelAndView showDialog(String dialogId, boolean confirmation, UifFormBase form) {
        if (form.isAjaxRequest()) {
            form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATEDIALOG.getKey());
            form.setUpdateComponentId(dialogId);
        }
        ModelAndView modelAndView = this.getModelAndView(form);
        this.prepareView(form.getRequest(), modelAndView);
        Component updateComponent = form.isAjaxRequest() ? form.getUpdateComponent() : form.getView();
        String showDialogScript = this.buildShowDialogScript(dialogId, confirmation, form);
        String onReadyScript = ScriptUtils.appendScript(updateComponent.getOnDocumentReadyScript(), showDialogScript);
        updateComponent.setOnDocumentReadyScript(onReadyScript);
        form.getRequest().setAttribute("ViewLifecycleComplete", (Object)"true");
        return modelAndView;
    }

    protected String buildShowDialogScript(String dialogId, boolean confirmation, UifFormBase form) {
        StringBuilder showDialogScript = new StringBuilder();
        showDialogScript.append("showDialog");
        showDialogScript.append("('");
        showDialogScript.append(dialogId);
        showDialogScript.append("', {responseHandler: ");
        showDialogScript.append("handleServerDialogResponse");
        showDialogScript.append(",responseEventData:{triggerActionId:'");
        showDialogScript.append(form.getTriggerActionId());
        showDialogScript.append("',confirmation:");
        showDialogScript.append(confirmation);
        showDialogScript.append("}});");
        return showDialogScript.toString();
    }

    @Override
    public ModelAndView performRedirect(UifFormBase form, String baseUrl, Properties urlParameters) {
        String redirectUrl = UrlFactory.parameterizeUrl((String)baseUrl, (Properties)urlParameters);
        return this.performRedirect(form, redirectUrl);
    }

    @Override
    public ModelAndView performRedirect(UifFormBase form, String redirectUrl) {
        ModelAndView modelAndView;
        form.setRequestRedirected(true);
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.REDIRECT.getKey());
        if (form.isAjaxRequest()) {
            modelAndView = this.getModelAndView(form, form.getPageId());
            modelAndView.addObject("redirectUrl", (Object)redirectUrl);
        } else {
            modelAndView = new ModelAndView("redirect:" + redirectUrl);
        }
        return modelAndView;
    }

    @Override
    public ModelAndView getMessageView(UifFormBase form, String headerText, String messageText) {
        MessageView messageView = (MessageView)this.getViewService().getViewById("Uif-MessageView");
        messageView.setHeaderText(headerText);
        messageView.setMessageText(messageText);
        form.setViewId("Uif-MessageView");
        form.setView(messageView);
        return this.getModelAndView(form);
    }

    @Override
    public ModelAndView getModelAndView(UifFormBase form) {
        return this.getModelAndView(form, form.getPageId());
    }

    @Override
    public ModelAndView getModelAndView(UifFormBase form, String pageId) {
        if (StringUtils.isNotBlank((String)pageId)) {
            form.setPageId(pageId);
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("KualiForm", (Object)form);
        modelAndView.setViewName("/krad/WEB-INF/ftl/uifRender");
        return modelAndView;
    }

    @Override
    public ModelAndView getModelAndView(UifFormBase form, Map<String, Object> additionalViewAttributes) {
        ModelAndView modelAndView = this.getModelAndView(form, form.getPageId());
        if (additionalViewAttributes != null) {
            for (Map.Entry<String, Object> additionalViewAttribute : additionalViewAttributes.entrySet()) {
                modelAndView.getModelMap().put((Object)additionalViewAttribute.getKey(), additionalViewAttribute.getValue());
            }
        }
        return modelAndView;
    }

    @Override
    public ModelAndView getModelAndViewWithInit(UifFormBase form, String viewId) {
        form.setPageId(null);
        return this.getModelAndViewWithInit(form, viewId, null);
    }

    @Override
    public ModelAndView getModelAndViewWithInit(UifFormBase form, String viewId, String pageId) {
        View view = this.getViewService().getViewById(viewId);
        if (view == null) {
            throw new RiceRuntimeException("No view was found with view id " + viewId);
        }
        form.setView(view);
        form.setViewId(viewId);
        return this.getModelAndView(form, pageId);
    }

    @Override
    public void prepareView(HttpServletRequest request, ModelAndView modelAndView) {
        if (modelAndView == null) {
            return;
        }
        Object model = modelAndView.getModelMap().get((Object)"KualiForm");
        if (!(model instanceof UifFormBase)) {
            return;
        }
        UifFormBase form = (UifFormBase)model;
        if (!form.isRequestRedirected()) {
            this.invokeViewLifecycle(request, form);
        }
        modelAndView.addObject("request", (Object)request);
        modelAndView.addObject("UserSession", request.getSession().getAttribute("UserSession"));
        Map properties = CoreApiServiceLocator.getKualiConfigurationService().getAllProperties();
        modelAndView.addObject("ConfigProperties", (Object)properties);
        modelAndView.addObject("HelperMethods", (Object)new UifRenderHelperMethods());
    }

    protected void invokeViewLifecycle(HttpServletRequest request, UifFormBase form) {
        if (form.isUpdateComponentRequest() || form.isUpdateDialogRequest() || form.isJsonRequest() && StringUtils.isNotBlank((String)form.getUpdateComponentId())) {
            String refreshComponentId = form.getUpdateComponentId();
            Component updateComponent = ViewLifecycle.performComponentLifecycle(form.getView(), form, request, form.getViewPostMetadata(), refreshComponentId);
            form.setUpdateComponent(updateComponent);
        } else {
            View view = form.getView();
            if (view == null) {
                LOG.warn((Object)("View in form was null: " + form));
                if (!form.isJsonRequest()) {
                    throw new IllegalStateException("View in form was null: " + form);
                }
                return;
            }
            Map<String, String> parameterMap = KRADUtils.translateRequestParameterMap(request.getParameterMap());
            parameterMap.putAll(form.getViewRequestParameters());
            ViewPostMetadata postMetadata = ViewLifecycle.buildView(view, form, request, parameterMap);
            form.setViewPostMetadata(postMetadata);
            if (form.isUpdatePageRequest()) {
                PageGroup updateComponent = form.getView().getCurrentPage();
                form.setUpdateComponent(updateComponent);
            }
            form.setPageId(view.getCurrentPageId());
        }
    }

    protected ViewService getViewService() {
        return this.viewService;
    }

    public void setViewService(ViewService viewService) {
        this.viewService = viewService;
    }

    public ViewValidationService getViewValidationService() {
        return this.viewValidationService;
    }

    public void setViewValidationService(ViewValidationService viewValidationService) {
        this.viewValidationService = viewValidationService;
    }
}

