/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.TransactionalDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.rule.AddAdHocRoutePersonRule;
import org.kuali.rice.krad.rules.rule.AddAdHocRouteWorkgroupRule;
import org.kuali.rice.krad.rules.rule.AddCollectionLineRule;
import org.kuali.rice.krad.rules.rule.AddNoteRule;
import org.kuali.rice.krad.rules.rule.ApproveDocumentRule;
import org.kuali.rice.krad.rules.rule.CompleteDocumentRule;
import org.kuali.rice.krad.rules.rule.RouteDocumentRule;
import org.kuali.rice.krad.rules.rule.SaveDocumentRule;
import org.kuali.rice.krad.rules.rule.SendAdHocRequestsRule;
import org.kuali.rice.krad.rules.rule.event.AddCollectionLineEvent;
import org.kuali.rice.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.service.DocumentDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.RouteToCompletionUtil;

public abstract class DocumentRuleBase
implements SaveDocumentRule,
RouteDocumentRule,
ApproveDocumentRule,
AddNoteRule,
AddAdHocRoutePersonRule,
AddAdHocRouteWorkgroupRule,
SendAdHocRequestsRule,
CompleteDocumentRule,
AddCollectionLineRule {
    private static final Logger LOG = Logger.getLogger(DocumentRuleBase.class);
    private static PersonService personService;
    private static DictionaryValidationService dictionaryValidationService;
    private static DocumentDictionaryService documentDictionaryService;
    private static ConfigurationService kualiConfigurationService;
    private static GroupService groupService;
    private static PermissionService permissionService;
    private static DocumentTypeService documentTypeService;
    private static DataDictionaryService dataDictionaryService;
    private int maxDictionaryValidationDepth = 100;

    public boolean isDocumentOverviewValid(Document document) {
        GlobalVariables.getMessageMap().addToErrorPath("document");
        GlobalVariables.getMessageMap().addToErrorPath("documentHeader");
        this.getDictionaryValidationService().validateBusinessObject(document.getDocumentHeader());
        this.validateSensitiveDataValue("explanation", document.getDocumentHeader().getExplanation(), this.getDataDictionaryService().getAttributeLabel(DocumentHeader.class, "explanation"));
        this.validateSensitiveDataValue("documentDescription", document.getDocumentHeader().getDocumentDescription(), this.getDataDictionaryService().getAttributeLabel(DocumentHeader.class, "documentDescription"));
        GlobalVariables.getMessageMap().removeFromErrorPath("documentHeader");
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    public boolean isDocumentAttributesValid(Document document, boolean validateRequired) {
        GlobalVariables.getMessageMap().addToErrorPath("document");
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), validateRequired);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    @Override
    public boolean processSaveDocument(Document document) {
        boolean isValid = true;
        isValid = this.isDocumentOverviewValid(document);
        GlobalVariables.getMessageMap().addToErrorPath("document");
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), false);
        this.getDictionaryValidationService().validateDefaultExistenceChecksForTransDoc((TransactionalDocument)document);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        isValid &= GlobalVariables.getMessageMap().hasNoErrors();
        return isValid &= this.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return true;
    }

    @Override
    public boolean processRouteDocument(Document document) {
        boolean isValid = true;
        isValid = this.isDocumentOverviewValid(document);
        boolean completeRequestPending = RouteToCompletionUtil.checkIfAtleastOneAdHocCompleteRequestExist(document);
        if (isValid && !completeRequestPending) {
            isValid &= this.isDocumentAttributesValid(document, true);
            isValid &= this.processCustomRouteDocumentBusinessRules(document);
        }
        return isValid;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        return true;
    }

    @Override
    public boolean processApproveDocument(ApproveDocumentEvent approveEvent) {
        boolean isValid = true;
        isValid = this.processCustomApproveDocumentBusinessRules(approveEvent);
        return isValid;
    }

    protected boolean processCustomApproveDocumentBusinessRules(ApproveDocumentEvent approveEvent) {
        return true;
    }

    @Override
    public boolean processAddCollectionLine(AddCollectionLineEvent addEvent) {
        boolean isValid = true;
        isValid = this.processCustomAddCollectionLineBusinessRules(addEvent);
        return isValid;
    }

    protected boolean processCustomAddCollectionLineBusinessRules(AddCollectionLineEvent addEvent) {
        return true;
    }

    @Override
    public boolean processAddNote(Document document, Note note) {
        boolean isValid = true;
        isValid &= this.isNoteValid(note);
        return isValid &= this.processCustomAddNoteBusinessRules(document, note);
    }

    public boolean isNoteValid(Note note) {
        GlobalVariables.getMessageMap().addToErrorPath("newCollectionLines['document.notes']");
        this.getDictionaryValidationService().validateBusinessObject(note);
        this.validateSensitiveDataValue("noteText", note.getNoteText(), this.getDataDictionaryService().getAttributeLabel(Note.class, "noteText"));
        GlobalVariables.getMessageMap().removeFromErrorPath("newCollectionLines['document.notes']");
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    protected boolean processCustomAddNoteBusinessRules(Document document, Note note) {
        return true;
    }

    @Override
    public boolean processAddAdHocRoutePerson(Document document, AdHocRoutePerson adHocRoutePerson) {
        boolean isValid = true;
        isValid &= this.isAddHocRoutePersonValid(document, adHocRoutePerson);
        return isValid &= this.processCustomAddAdHocRoutePersonBusinessRules(document, adHocRoutePerson);
    }

    @Override
    public boolean processSendAdHocRequests(Document document) {
        boolean isValid = true;
        isValid &= this.isAdHocRouteRecipientsValid(document);
        return isValid &= this.processCustomSendAdHocRequests(document);
    }

    protected boolean processCustomSendAdHocRequests(Document document) {
        return true;
    }

    protected boolean isAdHocRouteRecipientsValid(Document document) {
        boolean isValid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (errorMap.getErrorPath().size() == 0) {
            errorMap.addToErrorPath("newAdHocRoutePerson");
        }
        if ((document.getAdHocRoutePersons() == null || document.getAdHocRoutePersons().isEmpty()) && (document.getAdHocRouteWorkgroups() == null || document.getAdHocRouteWorkgroups().isEmpty())) {
            GlobalVariables.getMessageMap().putError("id", "error.adhoc.missing.recipients", new String[0]);
            isValid = false;
        }
        errorMap.removeFromErrorPath("newAdHocRoutePerson");
        return isValid;
    }

    public boolean isAddHocRoutePersonValid(Document document, AdHocRoutePerson person) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (errorMap.getErrorPath().size() == 0) {
            errorMap.addToErrorPath("newAdHocRoutePerson");
        }
        String actionRequestedCode = person.getActionRequested();
        if (StringUtils.isNotBlank((String)person.getId())) {
            Person user = this.getPersonService().getPersonByPrincipalName(person.getId());
            if (user == null) {
                GlobalVariables.getMessageMap().putError("id", "error.adhoc.invalid.person", new String[0]);
            } else if (!DocumentRuleBase.getPermissionService().hasPermission(user.getPrincipalId(), "KUALI", "Log In Kuali Portal")) {
                GlobalVariables.getMessageMap().putError("id", "error.adhoc.inactive.person", new String[0]);
            } else if (this.isAdHocRouteCompletionToInitiator(document, user, actionRequestedCode)) {
                GlobalVariables.getMessageMap().putError("id", "error.adhoc.complete.person.is.initiator", new String[0]);
            } else if (StringUtils.equals((String)actionRequestedCode, (String)"C") && this.hasAdHocRouteCompletion(document, (AdHocRouteRecipient)person)) {
                GlobalVariables.getMessageMap().putError("id", "error.adhoc.complete.more.than.one.request", new String[0]);
            } else {
                Class<?> docOrBoClass = null;
                docOrBoClass = document instanceof MaintenanceDocument ? ((MaintenanceDocument)document).getNewMaintainableObject().getDataObjectClass() : document.getClass();
                if (!DocumentRuleBase.getDocumentDictionaryService().getDocumentAuthorizer(document).canReceiveAdHoc(document, user, actionRequestedCode)) {
                    GlobalVariables.getMessageMap().putError("id", "error.adhoc.unauthorized.person", new String[0]);
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError("id", "error.adhoc.missing.person", new String[0]);
        }
        errorMap.removeFromErrorPath("newAdHocRoutePerson");
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    protected boolean isAdHocRouteCompletionToInitiator(Document document, Person person, String actionRequestCode) {
        if (!StringUtils.equals((String)actionRequestCode, (String)"C")) {
            return false;
        }
        String documentInitiator = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        String adhocRecipient = person.getPrincipalId();
        return StringUtils.equals((String)documentInitiator, (String)adhocRecipient);
    }

    protected boolean hasAdHocRouteCompletion(Document document, AdHocRouteRecipient adHocRouteRecipient) {
        List<AdHocRouteWorkgroup> adHocRouteWorkgroups;
        List<AdHocRoutePerson> adHocRoutePersons = document.getAdHocRoutePersons();
        if (KRADUtils.isNotNull(adHocRoutePersons)) {
            for (AdHocRoutePerson adhocRecipient : adHocRoutePersons) {
                String actionRequestCode;
                if (adHocRouteRecipient == adhocRecipient || !StringUtils.equals((String)"C", (String)(actionRequestCode = adhocRecipient.getActionRequested()))) continue;
                return true;
            }
        }
        if (KRADUtils.isNotNull(adHocRouteWorkgroups = document.getAdHocRouteWorkgroups())) {
            for (AdHocRouteWorkgroup adhocRecipient : adHocRouteWorkgroups) {
                String actionRequestCode;
                if (adHocRouteRecipient == adhocRecipient || !StringUtils.equals((String)"C", (String)(actionRequestCode = adhocRecipient.getActionRequested()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean processCustomAddAdHocRoutePersonBusinessRules(Document document, AdHocRoutePerson person) {
        return true;
    }

    @Override
    public boolean processAddAdHocRouteWorkgroup(Document document, AdHocRouteWorkgroup adHocRouteWorkgroup) {
        boolean isValid = true;
        isValid &= this.isAddHocRouteWorkgroupValid(document, adHocRouteWorkgroup);
        return isValid &= this.processCustomAddAdHocRouteWorkgroupBusinessRules(document, adHocRouteWorkgroup);
    }

    public boolean isAddHocRouteWorkgroupValid(Document document, AdHocRouteWorkgroup workgroup) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (errorMap.getErrorPath().size() == 0) {
            GlobalVariables.getMessageMap().addToErrorPath("newAdHocRouteWorkgroup");
        }
        if (workgroup.getRecipientName() != null && workgroup.getRecipientNamespaceCode() != null) {
            try {
                Group group = DocumentRuleBase.getGroupService().getGroupByNamespaceCodeAndName(workgroup.getRecipientNamespaceCode(), workgroup.getRecipientName());
                String actionRequestedCode = workgroup.getActionRequested();
                if (group == null || !group.isActive()) {
                    GlobalVariables.getMessageMap().putError("recipientName", "error.adhoc.invalid.workgroup", new String[0]);
                    GlobalVariables.getMessageMap().putError("recipientNamespaceCode", "error.adhoc.invalid.workgroup.namespace", new String[0]);
                } else if (StringUtils.equals((String)actionRequestedCode, (String)"C") && this.hasAdHocRouteCompletion(document, (AdHocRouteRecipient)workgroup)) {
                    GlobalVariables.getMessageMap().putError("recipientNamespaceCode", "error.adhoc.complete.more.than.one.request", new String[0]);
                } else {
                    WorkflowDocumentService wds = KewApiServiceLocator.getWorkflowDocumentService();
                    DocumentType documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(wds.getDocument(document.getDocumentNumber()).getDocumentTypeName());
                    Map<String, String> permissionDetails = this.buildDocumentTypeActionRequestPermissionDetails(documentType, workgroup.getActionRequested());
                    if (this.useKimPermission("KR-WKFLW", "Ad Hoc Review Document", permissionDetails)) {
                        List principalIds = DocumentRuleBase.getGroupService().getMemberPrincipalIds(group.getId());
                        for (String principalId : principalIds) {
                            if (DocumentRuleBase.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Ad Hoc Review Document", permissionDetails, new HashMap())) continue;
                            GlobalVariables.getMessageMap().putError("recipientName", "error.adhoc.unauthorized.workgroup", new String[0]);
                            GlobalVariables.getMessageMap().putError("recipientNamespaceCode", "error.adhoc.invalid.workgroup.namespace", new String[0]);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"isAddHocRouteWorkgroupValid(AdHocRouteWorkgroup)", (Throwable)e);
                GlobalVariables.getMessageMap().putError("recipientName", "error.adhoc.invalid.workgroup", new String[0]);
                GlobalVariables.getMessageMap().putError("recipientNamespaceCode", "error.adhoc.invalid.workgroup.namespace", new String[0]);
            }
        } else {
            if (workgroup.getRecipientNamespaceCode() == null) {
                GlobalVariables.getMessageMap().putError("recipientNamespaceCode", "error.adhoc.invalid.workgroup.namespace.missing", new String[0]);
            }
            if (workgroup.getRecipientName() == null) {
                GlobalVariables.getMessageMap().putError("recipientName", "error.adhoc.missing.workgroup", new String[0]);
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("newAdHocRouteWorkgroup");
        return GlobalVariables.getMessageMap().hasNoErrors();
    }

    protected boolean processCustomAddAdHocRouteWorkgroupBusinessRules(Document document, AdHocRouteWorkgroup workgroup) {
        return true;
    }

    public int getMaxDictionaryValidationDepth() {
        return this.maxDictionaryValidationDepth;
    }

    public void setMaxDictionaryValidationDepth(int maxDictionaryValidationDepth) {
        if (maxDictionaryValidationDepth < 0) {
            LOG.error((Object)("Dictionary validation depth should be greater than or equal to 0.  Value received was: " + maxDictionaryValidationDepth));
            throw new RuntimeException("Dictionary validation depth should be greater than or equal to 0.  Value received was: " + maxDictionaryValidationDepth);
        }
        this.maxDictionaryValidationDepth = maxDictionaryValidationDepth;
    }

    protected boolean validateSensitiveDataValue(String fieldName, String fieldValue, String fieldLabel) {
        boolean dataValid = true;
        if (fieldValue == null) {
            return dataValid;
        }
        boolean patternFound = KRADUtils.containsSensitiveDataPatternMatch(fieldValue);
        boolean warnForSensitiveData = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "SENSITIVE_DATA_PATTERNS_WARNING_IND");
        if (patternFound && !warnForSensitiveData) {
            dataValid = false;
            GlobalVariables.getMessageMap().putError(fieldName, "error.document.fieldContainsPossibleSensitiveData", new String[]{fieldLabel});
        }
        return dataValid;
    }

    @Override
    public boolean processCompleteDocument(Document document) {
        boolean isValid = true;
        isValid &= this.processSaveDocument(document);
        return isValid &= this.processCustomCompleteDocumentBusinessRules(document);
    }

    protected boolean processCustomCompleteDocumentBusinessRules(Document document) {
        return true;
    }

    protected boolean useKimPermission(String namespace, String permissionTemplateName, Map<String, String> permissionDetails) {
        Boolean b = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-WKFLW", "All", "KIM_PRIORITY_ON_DOC_TYP_PERMS_IND");
        if (b == null || b.booleanValue()) {
            return DocumentRuleBase.getPermissionService().isPermissionDefinedByTemplate(namespace, permissionTemplateName, permissionDetails);
        }
        return false;
    }

    protected Map<String, String> buildDocumentTypeActionRequestPermissionDetails(DocumentType documentType, String actionRequestCode) {
        Map<String, String> details = this.buildDocumentTypePermissionDetails(documentType);
        if (!StringUtils.isBlank((String)actionRequestCode)) {
            details.put("actionRequestCd", actionRequestCode);
        }
        return details;
    }

    protected Map<String, String> buildDocumentTypePermissionDetails(DocumentType documentType) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("documentTypeName", documentType.getName());
        return details;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    protected PersonService getPersonService() {
        if (personService == null) {
            personService = KimApiServiceLocator.getPersonService();
        }
        return personService;
    }

    public static GroupService getGroupService() {
        if (groupService == null) {
            groupService = KimApiServiceLocator.getGroupService();
        }
        return groupService;
    }

    public static PermissionService getPermissionService() {
        if (permissionService == null) {
            permissionService = KimApiServiceLocator.getPermissionService();
        }
        return permissionService;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        if (dictionaryValidationService == null) {
            dictionaryValidationService = KRADServiceLocatorWeb.getDictionaryValidationService();
        }
        return dictionaryValidationService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        if (kualiConfigurationService == null) {
            kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return kualiConfigurationService;
    }

    protected static DocumentDictionaryService getDocumentDictionaryService() {
        if (documentDictionaryService == null) {
            documentDictionaryService = KRADServiceLocatorWeb.getDocumentDictionaryService();
        }
        return documentDictionaryService;
    }

    public static void setDocumentDictionaryService(DocumentDictionaryService documentDictionaryService) {
        DocumentRuleBase.documentDictionaryService = documentDictionaryService;
    }
}

