/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.container.ContainerBase;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;
import org.kuali.rice.krad.uif.util.RecycleUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.MessageMap;

@BeanTag(name="validationMessages", parent="Uif-ValidationMessagesBase")
public class ValidationMessages
extends UifDictionaryBeanBase {
    private static final long serialVersionUID = 780940788435330077L;
    private List<String> additionalKeysToMatch;
    private boolean displayMessages;
    private List<String> errors;
    private List<String> warnings;
    private List<String> infos;

    public void generateMessages(View view, Object model, Component parent) {
        Object parentContainer;
        this.errors = new ArrayList<String>();
        this.warnings = new ArrayList<String>();
        this.infos = new ArrayList<String>();
        List<String> masterKeyList = this.getKeys(parent);
        MessageMap messageMap = GlobalVariables.getMessageMap();
        String parentContainerId = "";
        Map<String, Object> parentContext = parent.getContext();
        Object object = parentContainer = parentContext == null ? null : parentContext.get("parent");
        if (parentContainer != null && (parentContainer instanceof Container || parentContainer instanceof FieldGroup)) {
            parentContainerId = ((Component)parentContainer).getId();
        }
        if (parentContainer != null && parentContainer instanceof Message && ((Message)parentContainer).isRenderWrapperTag()) {
            parentContainerId = ((Component)parentContainer).getId();
        }
        if (parentContainer != null && parentContainer instanceof Component && StringUtils.isBlank((String)parentContainerId)) {
            parentContext = ((Component)parentContainer).getContext();
            Object object2 = parentContainer = parentContext == null ? null : parentContext.get("parent");
            if (parentContainer != null && (parentContainer instanceof Container || parentContainer instanceof FieldGroup)) {
                parentContainerId = ((Component)parentContainer).getId();
            }
        }
        if (parent.getDataAttributes() == null || parent.getDataAttributes().get("parent") == null) {
            parent.addDataAttribute("parent", parentContainerId);
        }
        if (parentContainer != null && parentContainer instanceof FieldGroup) {
            masterKeyList.add(parentContainerId);
        }
        this.processAuditErrors(masterKeyList);
        for (String key : masterKeyList) {
            this.errors.addAll(this.getMessages(view, key, messageMap.getErrorMessagesForProperty(key, true)));
            this.warnings.addAll(this.getMessages(view, key, messageMap.getWarningMessagesForProperty(key, true)));
            this.infos.addAll(this.getMessages(view, key, messageMap.getInfoMessagesForProperty(key, true)));
        }
    }

    private void processAuditErrors(List<String> masterKeyList) {
        Map<String, AuditCluster> clusterMap = GlobalVariables.getAuditErrorMap();
        for (AuditCluster auditCluster : clusterMap.values()) {
            boolean isError = !auditCluster.getCategory().equals("Warnings");
            List auditErrors = auditCluster.getAuditErrorList();
            if (auditErrors == null) continue;
            for (AuditError auditError : auditErrors) {
                if (!masterKeyList.contains(auditError.getValidationKey())) continue;
                MessageService messageService = KRADServiceLocatorWeb.getMessageService();
                String message = messageService.getMessageText(auditError.getMessageKey());
                if (message == null) {
                    message = "Intended message with key: " + auditError.getErrorKey() + " not found.";
                }
                if (auditError.getParams() != null && StringUtils.isNotBlank((String)message)) {
                    message = message.replace("'", "''");
                    message = MessageFormat.format(message, auditError.getParams());
                }
                message = MessageStructureUtils.translateStringMessage(message);
                if (isError) {
                    this.errors.add(message);
                    continue;
                }
                this.warnings.add(message);
            }
        }
    }

    protected List<String> getMessages(View view, String key, List<List<ErrorMessage>> lists) {
        ArrayList<String> result = new ArrayList<String>();
        for (List<ErrorMessage> errorList : lists) {
            if (errorList == null || !StringUtils.isNotBlank((String)key)) continue;
            for (ErrorMessage e : errorList) {
                String message = KRADUtils.getMessageText(e, true);
                message = MessageStructureUtils.translateStringMessage(message);
                result.add(message);
            }
        }
        return result;
    }

    protected List<String> getKeys(Component parent) {
        ArrayList<String> keyList = new ArrayList<String>();
        if (this.additionalKeysToMatch != null) {
            keyList.addAll(this.additionalKeysToMatch);
        }
        if (StringUtils.isNotBlank((String)parent.getId())) {
            keyList.add(parent.getId());
        }
        if (parent instanceof DataBinding && ((DataBinding)parent).getBindingInfo() != null && StringUtils.isNotEmpty((String)((DataBinding)parent).getBindingInfo().getBindingPath())) {
            keyList.add(((DataBinding)parent).getBindingInfo().getBindingPath());
        }
        return keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNestedGroupKeys(Collection<String> keyList, Component component) {
        Queue elementQueue = RecycleUtils.getInstance(LinkedList.class);
        try {
            elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(component).values());
            while (!elementQueue.isEmpty()) {
                LifecycleElement element = (LifecycleElement)elementQueue.poll();
                ValidationMessages ef = null;
                if (element instanceof ContainerBase) {
                    ef = ((ContainerBase)element).getValidationMessages();
                } else if (element instanceof FieldGroup) {
                    ef = ((FieldGroup)element).getGroup().getValidationMessages();
                }
                if (ef != null) {
                    keyList.addAll(ef.getKeys((Component)element));
                }
                elementQueue.addAll(ViewLifecycleUtils.getElementsForLifecycle(element).values());
            }
        }
        finally {
            elementQueue.clear();
            RecycleUtils.recycle(elementQueue);
        }
    }

    @BeanTagAttribute
    public List<String> getAdditionalKeysToMatch() {
        return this.additionalKeysToMatch;
    }

    public void setAdditionalKeysToMatch(String additionalKeysToMatch) {
        if (StringUtils.isNotBlank((String)additionalKeysToMatch)) {
            this.additionalKeysToMatch = Arrays.asList(StringUtils.split((String)additionalKeysToMatch, (String)","));
        }
    }

    public void setAdditionalKeysToMatch(List<String> additionalKeysToMatch) {
        this.additionalKeysToMatch = additionalKeysToMatch;
    }

    @BeanTagAttribute
    public boolean isDisplayMessages() {
        return this.displayMessages;
    }

    public void setDisplayMessages(boolean displayMessages) {
        this.displayMessages = displayMessages;
    }

    @BeanTagAttribute
    public List<String> getErrors() {
        return this.errors;
    }

    protected void setErrors(List<String> errors) {
        this.errors = errors;
    }

    @BeanTagAttribute
    public List<String> getWarnings() {
        return this.warnings;
    }

    protected void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    @BeanTagAttribute
    public List<String> getInfos() {
        return this.infos;
    }

    protected void setInfos(List<String> infos) {
        this.infos = infos;
    }

    protected void addValidationDataSettingsValue(Map<String, Object> valueMap, Map<String, String> defaults, String key, Object value) {
        String defaultValue = defaults.get(key);
        if (defaultValue != null && !value.toString().equals(defaultValue) || defaultValue != null && defaultValue.equals("[]") && value instanceof List && !((List)value).isEmpty() || defaultValue == null) {
            valueMap.put(key, value);
        }
    }
}

