/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.lifecycle.ComponentPostMetadata;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewPostMetadata;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewIndex;

public class LifecycleRefreshPathBuilder {
    public static void processLifecycleElements() {
        ViewIndex viewIndex = ViewLifecycle.getView().getViewIndex();
        Map<String, LifecycleElement> lifecycleElements = viewIndex.getLifecycleElementsByPath();
        for (LifecycleElement lifecycleElement : lifecycleElements.values()) {
            LifecycleRefreshPathBuilder.processLifecycleElement(lifecycleElement);
        }
    }

    protected static void processLifecycleElement(LifecycleElement element) {
        if (element == null || !(element instanceof Component)) {
            return;
        }
        Component component = (Component)element;
        if (ComponentUtils.canBeRefreshed(component) || component instanceof CollectionGroup || component.isForceSessionPersistence()) {
            ViewPostMetadata viewPostMetadata = ViewLifecycle.getViewPostMetadata();
            ComponentPostMetadata componentPostMetadata = viewPostMetadata.getComponentPostMetadata(component.getId());
            if (componentPostMetadata == null) {
                componentPostMetadata = viewPostMetadata.initializeComponentPostMetadata(component);
            }
            componentPostMetadata.setPath(component.getViewPath());
            LifecycleRefreshPathBuilder.buildRefreshPathMappings(component, componentPostMetadata);
            LifecycleRefreshPathBuilder.storePhasePathMapping(component, componentPostMetadata);
        }
    }

    protected static void buildRefreshPathMappings(LifecycleElement lifecycleElement, ComponentPostMetadata componentPostMetadata) {
        ArrayList<String> initializePaths = new ArrayList<String>();
        ArrayList<String> applyModelPaths = new ArrayList<String>();
        ArrayList<String> finalizePaths = new ArrayList<String>();
        String refreshElementPath = lifecycleElement.getViewPath();
        LifecycleRefreshPathBuilder.processElementPath(refreshElementPath, initializePaths, applyModelPaths, finalizePaths, new HashSet<String>());
        HashMap<String, List<String>> refreshPathMappings = new HashMap<String, List<String>>();
        refreshPathMappings.put("INITIALIZE", initializePaths);
        refreshPathMappings.put("APPLY_MODEL", applyModelPaths);
        refreshPathMappings.put("FINALIZE", finalizePaths);
        componentPostMetadata.setRefreshPathMappings(refreshPathMappings);
    }

    protected static void storePhasePathMapping(LifecycleElement lifecycleElement, ComponentPostMetadata componentPostMetadata) {
        HashMap<String, String> storedPhasePathMapping = new HashMap<String, String>();
        String refreshElementPath = lifecycleElement.getViewPath();
        Map<String, String> phasePathMapping = lifecycleElement.getPhasePathMapping();
        for (Map.Entry<String, String> phasePathEntry : phasePathMapping.entrySet()) {
            if (StringUtils.equals((String)phasePathEntry.getValue(), (String)refreshElementPath)) continue;
            storedPhasePathMapping.put(phasePathEntry.getKey(), phasePathEntry.getValue());
        }
        if (!storedPhasePathMapping.isEmpty()) {
            componentPostMetadata.setPhasePathMapping(storedPhasePathMapping);
        }
    }

    protected static void processElementPath(String path, List<String> initializePaths, List<String> applyModelPaths, List<String> finalizePaths, Set<String> visitedPaths) {
        String[] parentProperties = ObjectPropertyUtils.splitPropertyPath(path);
        String previousPath = null;
        for (int i = 0; i < parentProperties.length; ++i) {
            String parentPath = parentProperties[i];
            if (previousPath != null) {
                parentPath = previousPath + "." + parentPath;
            }
            if (!visitedPaths.contains(parentPath)) {
                visitedPaths.add(parentPath);
                LifecycleRefreshPathBuilder.addElementRefreshPaths(parentPath, initializePaths, applyModelPaths, finalizePaths, visitedPaths);
            }
            previousPath = parentPath;
        }
    }

    protected static void addElementRefreshPaths(String elementPath, List<String> initializePaths, List<String> applyModelPaths, List<String> finalizePaths, Set<String> visitedPaths) {
        LifecycleElement lifecycleElement = ViewLifecycle.getView().getViewIndex().getLifecycleElementByPath(elementPath);
        if (lifecycleElement == null) {
            return;
        }
        Map<String, String> phasePathMapping = lifecycleElement.getPhasePathMapping();
        for (Map.Entry<String, String> phasePathEntry : phasePathMapping.entrySet()) {
            String refreshPath = phasePathEntry.getValue();
            LifecycleRefreshPathBuilder.addElementRefreshPath(refreshPath, phasePathEntry.getKey(), initializePaths, applyModelPaths, finalizePaths);
            if (!StringUtils.equals((String)elementPath, (String)refreshPath)) continue;
            LifecycleRefreshPathBuilder.processElementPath(refreshPath, initializePaths, applyModelPaths, finalizePaths, visitedPaths);
        }
    }

    protected static void addElementRefreshPath(String path, String phase, List<String> initializePaths, List<String> applyModelPaths, List<String> finalizePaths) {
        if ("INITIALIZE".equals(phase)) {
            initializePaths.add(path);
        } else if ("APPLY_MODEL".equals(phase)) {
            applyModelPaths.add(path);
        } else if ("FINALIZE".equals(phase)) {
            finalizePaths.add(path);
        }
    }
}

