/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ControllerService;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.NavigationControllerService;
import org.springframework.web.servlet.ModelAndView;

public class ControllerServiceImpl
implements ControllerService {
    private ModelAndViewService modelAndViewService;
    private NavigationControllerService navigationControllerService;

    @Override
    public ModelAndView start(UifFormBase form) {
        this.checkViewAuthorization(form);
        if (form.getView() != null) {
            form.setApplyDefaultValues(true);
        }
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public void checkViewAuthorization(UifFormBase form) throws AuthorizationException {
        View view = form.getView();
        if (GlobalVariables.getUserSession() == null || view == null) {
            return;
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean viewAuthorized = view.getAuthorizer().canOpenView(view, form, user);
        if (!viewAuthorized) {
            throw new AuthorizationException(user.getPrincipalName(), "open", view.getId(), "User '" + user.getPrincipalName() + "' is not authorized to open view ID: " + view.getId(), null);
        }
    }

    @Override
    public ModelAndView sessionTimeout(UifFormBase form) {
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView cancel(UifFormBase form) {
        GlobalVariables.getUifFormManager().removeSessionForm(form);
        return this.getNavigationControllerService().returnToHistory(form, false, false, true);
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    protected NavigationControllerService getNavigationControllerService() {
        return this.navigationControllerService;
    }

    public void setNavigationControllerService(NavigationControllerService navigationControllerService) {
        this.navigationControllerService = navigationControllerService;
    }
}

