/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.impl.role;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebParam;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.cache.CacheKeyUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.VersionHelper;
import org.kuali.rice.kim.api.common.delegate.DelegateMember;
import org.kuali.rice.kim.api.common.delegate.DelegateMemberContract;
import org.kuali.rice.kim.api.common.delegate.DelegateType;
import org.kuali.rice.kim.api.common.delegate.DelegateTypeContract;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.DelegateMemberQueryResults;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleContract;
import org.kuali.rice.kim.api.role.RoleMember;
import org.kuali.rice.kim.api.role.RoleMemberContract;
import org.kuali.rice.kim.api.role.RoleMemberQueryResults;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleMembershipContract;
import org.kuali.rice.kim.api.role.RoleMembershipQueryResults;
import org.kuali.rice.kim.api.role.RoleQueryResults;
import org.kuali.rice.kim.api.role.RoleResponsibility;
import org.kuali.rice.kim.api.role.RoleResponsibilityAction;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.api.type.KimTypeUtils;
import org.kuali.rice.kim.framework.common.delegate.DelegationTypeService;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.impl.common.attribute.AttributeTransform;
import org.kuali.rice.kim.impl.common.attribute.KimAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberAttributeDataBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.common.delegate.DelegateTypeBo;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.role.RoleBoLite;
import org.kuali.rice.kim.impl.role.RoleMemberAttributeDataBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;
import org.kuali.rice.kim.impl.role.RolePermissionBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityActionBo;
import org.kuali.rice.kim.impl.role.RoleResponsibilityBo;
import org.kuali.rice.kim.impl.role.RoleServiceBase;
import org.kuali.rice.kim.impl.services.KimImplServiceLocator;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.util.LinkedMultiValueMap;

public class RoleServiceImpl
extends RoleServiceBase
implements RoleService {
    private static final Logger LOG = Logger.getLogger(RoleServiceImpl.class);
    private static final Map<String, RoleServiceBase.RoleDaoAction> memberTypeToRoleDaoActionMap = RoleServiceImpl.populateMemberTypeToRoleDaoActionMap();
    private RoleService proxiedRoleService;
    private CacheManager cacheManager = new NoOpCacheManager();

    private static Map<String, RoleServiceBase.RoleDaoAction> populateMemberTypeToRoleDaoActionMap() {
        HashMap<String, RoleServiceBase.RoleDaoAction> map = new HashMap<String, RoleServiceBase.RoleDaoAction>();
        map.put(MemberType.GROUP.getCode(), RoleServiceBase.RoleDaoAction.ROLE_GROUPS_FOR_GROUP_IDS_AND_ROLE_IDS);
        map.put(MemberType.PRINCIPAL.getCode(), RoleServiceBase.RoleDaoAction.ROLE_PRINCIPALS_FOR_PRINCIPAL_ID_AND_ROLE_IDS);
        map.put(MemberType.ROLE.getCode(), RoleServiceBase.RoleDaoAction.ROLE_MEMBERSHIPS_FOR_ROLE_IDS_AS_MEMBERS);
        return Collections.unmodifiableMap(map);
    }

    public Role createRole(Role role) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(role, "role");
        if (StringUtils.isNotBlank((String)role.getId()) && this.getRole(role.getId()) != null) {
            throw new RiceIllegalStateException("the role to create already exists: " + role);
        }
        RoleBo bo = RoleBo.from(role);
        return RoleBo.to((RoleBo)((Object)this.getDataObjectService().save((Object)bo, new PersistenceOption[0])));
    }

    public Role updateRole(Role role) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(role, "role");
        RoleBoLite originalRole = this.getRoleBoLite(role.getId());
        if (StringUtils.isBlank((String)role.getId()) || originalRole == null) {
            throw new RiceIllegalStateException("the role does not exist: " + role);
        }
        RoleBo bo = RoleBo.from(role);
        RoleBo updatedRole = (RoleBo)((Object)this.getDataObjectService().save((Object)bo, new PersistenceOption[0]));
        if (originalRole.isActive() && !updatedRole.isActive()) {
            KimImplServiceLocator.getRoleInternalService().roleInactivated(updatedRole.getId());
        }
        return RoleBo.to(updatedRole);
    }

    protected boolean checkForCircularRoleMembership(String newMemberId, RoleBo roleBo) {
        Set<String> newRoleMemberIds = this.getRoleTypeRoleMemberIds(newMemberId);
        return !newRoleMemberIds.contains(roleBo.getId());
    }

    protected RoleMember findRoleMember(String roleMemberId) {
        List roleMembers = this.findRoleMembers(QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equal((String)"id", (Object)roleMemberId)})).getResults();
        if (roleMembers != null && !roleMembers.isEmpty()) {
            return (RoleMember)roleMembers.get(0);
        }
        return null;
    }

    public RoleMemberQueryResults findRoleMembers(QueryByCriteria queryByCriteria) throws RiceIllegalStateException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(RoleMemberBo.class, (QueryByCriteria)AttributeTransform.getInstance().apply((Object)queryByCriteria));
        RoleMemberQueryResults.Builder builder = RoleMemberQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<RoleMember.Builder> ims = new ArrayList<RoleMember.Builder>();
        for (RoleMemberBo bo : results.getResults()) {
            ims.add(RoleMember.Builder.create((RoleMemberContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public Set<String> getRoleTypeRoleMemberIds(String roleId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(roleId, "roleId");
        HashSet<String> results = new HashSet<String>();
        this.getNestedRoleTypeMemberIds(roleId, results);
        return Collections.unmodifiableSet(results);
    }

    public List<String> getMemberParentRoleIds(String memberType, String memberId) throws RiceIllegalStateException {
        this.incomingParamCheck(memberType, "memberType");
        this.incomingParamCheck(memberId, "memberId");
        List<RoleMemberBo> parentRoleMembers = this.getRoleMembershipsForMemberId(memberType, memberId, Collections.emptyMap());
        ArrayList<String> parentRoleIds = new ArrayList<String>(parentRoleMembers.size());
        for (RoleMemberBo parentRoleMember : parentRoleMembers) {
            parentRoleIds.add(parentRoleMember.getRoleId());
        }
        return parentRoleIds;
    }

    public List<RoleResponsibilityAction> getRoleMemberResponsibilityActions(String roleMemberId) throws RiceIllegalStateException {
        this.incomingParamCheck(roleMemberId, "roleMemberId");
        QueryResults responsibilityActionBoList = this.getDataObjectService().findMatching(RoleResponsibilityActionBo.class, QueryByCriteria.Builder.forAttribute((String)"roleMemberId", (Object)roleMemberId).build());
        ArrayList<RoleResponsibilityAction> roleResponsibilityActionsList = new ArrayList<RoleResponsibilityAction>();
        for (RoleResponsibilityActionBo roleResponsibilityActionBo : responsibilityActionBoList.getResults()) {
            RoleResponsibilityAction roleResponsibility = RoleResponsibilityActionBo.to(roleResponsibilityActionBo);
            roleResponsibilityActionsList.add(roleResponsibility);
        }
        return roleResponsibilityActionsList;
    }

    public DelegateMemberQueryResults findDelegateMembers(QueryByCriteria queryByCriteria) throws RiceIllegalStateException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(DelegateMemberBo.class, (QueryByCriteria)AttributeTransform.getInstance().apply((Object)queryByCriteria));
        DelegateMemberQueryResults.Builder builder = DelegateMemberQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<DelegateMember.Builder> ims = new ArrayList<DelegateMember.Builder>();
        for (DelegateMemberBo bo : results.getResults()) {
            ims.add(DelegateMember.Builder.create((DelegateMemberContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public Role getRole(String roleId) throws RiceIllegalStateException {
        this.incomingParamCheck(roleId, "roleId");
        return this.loadRole(roleId);
    }

    protected Role loadRole(String roleId) {
        RoleBoLite roleBo;
        Role role = this.getRoleFromCache(roleId);
        if (role == null && (roleBo = this.getRoleBoLite(roleId)) != null) {
            role = RoleBoLite.to(roleBo);
            this.putRoleInCache(role);
        }
        return role;
    }

    protected Role getRoleFromCache(String id) {
        Cache cache = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/RoleType");
        Cache.ValueWrapper cachedValue = cache.get((Object)("id=" + id));
        if (cachedValue != null) {
            return (Role)cachedValue.get();
        }
        return null;
    }

    protected Role getRoleFromCache(String namespaceCode, String name) {
        Cache cache = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/RoleType");
        Cache.ValueWrapper cachedValue = cache.get((Object)("namespaceCode=" + namespaceCode + "|name=" + name));
        if (cachedValue != null) {
            return (Role)cachedValue.get();
        }
        return null;
    }

    protected void putRoleInCache(Role role) {
        if (role != null) {
            Cache cache = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/RoleType");
            String idKey = "id=" + role.getId();
            String nameKey = "namespaceCode=" + role.getNamespaceCode() + "|name=" + role.getName();
            cache.put((Object)idKey, (Object)role);
            cache.put((Object)nameKey, (Object)role);
        }
    }

    protected Map<String, RoleBoLite> getRoleBoLiteMap(Collection<String> roleIds) {
        Map<String, RoleBoLite> result;
        if (roleIds.size() == 1) {
            String roleId = roleIds.iterator().next();
            RoleBoLite bo = this.getRoleBoLite(roleId);
            if (bo == null) {
                return Collections.emptyMap();
            }
            result = bo.isActive() ? Collections.singletonMap(roleId, bo) : Collections.emptyMap();
        } else {
            result = new HashMap<String, RoleBoLite>(roleIds.size());
            for (String roleId : roleIds) {
                RoleBoLite bo = this.getRoleBoLite(roleId);
                if (bo == null || !bo.isActive()) continue;
                result.put(roleId, bo);
            }
        }
        return result;
    }

    public List<Role> getRoles(List<String> roleIds) throws RiceIllegalStateException {
        if (CollectionUtils.isEmpty(roleIds)) {
            throw new RiceIllegalArgumentException("roleIds is null or empty");
        }
        return Collections.unmodifiableList(this.loadRoles(roleIds));
    }

    protected List<Role> loadRoles(List<String> roleIds) {
        ArrayList<String> remainingRoleIds = new ArrayList<String>();
        HashMap<String, Role> roleMap = new HashMap<String, Role>(roleIds.size());
        for (String roleId : roleIds) {
            Role role = this.getRoleFromCache(roleId);
            if (role != null) {
                roleMap.put(roleId, role);
                continue;
            }
            remainingRoleIds.add(roleId);
        }
        if (!remainingRoleIds.isEmpty()) {
            Map<String, RoleBoLite> roleBoMap = this.getRoleBoLiteMap(remainingRoleIds);
            for (String roleId : roleBoMap.keySet()) {
                RoleBoLite roleBo = roleBoMap.get(roleId);
                if (roleBo == null) continue;
                Role role = RoleBoLite.to(roleBo);
                roleMap.put(roleId, role);
                this.putRoleInCache(role);
            }
        }
        ArrayList<Role> roles = new ArrayList<Role>(roleMap.values());
        return roles;
    }

    public Role getRoleByNamespaceCodeAndName(String namespaceCode, String roleName) throws RiceIllegalStateException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        return this.loadRoleByName(namespaceCode, roleName);
    }

    protected Role loadRoleByName(String namespaceCode, String roleName) {
        RoleBoLite roleBo;
        Role role = this.getRoleFromCache(namespaceCode, roleName);
        if (role == null && (roleBo = this.getRoleBoLiteByName(namespaceCode, roleName)) != null) {
            role = this.getRoleFromCache(roleBo.getId());
            if (role == null) {
                role = RoleBoLite.to(roleBo);
            }
            this.putRoleInCache(role);
        }
        return role;
    }

    public String getRoleIdByNamespaceCodeAndName(String namespaceCode, String roleName) throws RiceIllegalStateException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        Role role = this.getRoleByNamespaceCodeAndName(namespaceCode, roleName);
        if (role != null) {
            return role.getId();
        }
        return null;
    }

    public boolean isRoleActive(String roleId) throws RiceIllegalStateException {
        this.incomingParamCheck(roleId, "roleId");
        Role role = this.getRole(roleId);
        return role != null && role.isActive();
    }

    public List<Map<String, String>> getRoleQualifersForPrincipalByRoleIds(String principalId, List<String> roleIds, Map<String, String> qualification) throws RiceIllegalStateException {
        RoleTypeService roleTypeService;
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(roleIds, "roleIds");
        ArrayList<Map> results = new ArrayList<Map>();
        List<RoleMemberBo> roleMemberBoList = this.getStoredRoleMembersUsingExactMatchOnQualification(principalId, null, roleIds, qualification);
        HashMap roleIdToMembershipMap = new HashMap();
        for (RoleMemberBo roleMemberBo : roleMemberBoList) {
            if (!MemberType.PRINCIPAL.equals((Object)roleMemberBo.getType())) continue;
            roleTypeService = this.getRoleTypeService(roleMemberBo.getRoleId());
            if (roleTypeService != null) {
                ArrayList<RoleMembership> las = (ArrayList<RoleMembership>)roleIdToMembershipMap.get(roleMemberBo.getRoleId());
                if (las == null) {
                    las = new ArrayList<RoleMembership>();
                    roleIdToMembershipMap.put(roleMemberBo.getRoleId(), las);
                }
                RoleMembership mi = RoleMembership.Builder.create((String)roleMemberBo.getRoleId(), (String)roleMemberBo.getId(), (String)roleMemberBo.getMemberId(), (MemberType)roleMemberBo.getType(), roleMemberBo.getAttributes(), (DateTime)roleMemberBo.getActiveFromDate(), (DateTime)roleMemberBo.getActiveToDate()).build();
                las.add(mi);
                continue;
            }
            results.add(roleMemberBo.getAttributes());
        }
        for (Map.Entry entry : roleIdToMembershipMap.entrySet()) {
            roleTypeService = this.getRoleTypeService((String)entry.getKey());
            try {
                List matchingMembers = roleTypeService.getMatchingRoleMemberships(qualification, (List)entry.getValue());
                for (RoleMembership rmi : matchingMembers) {
                    results.add(rmi.getQualifier());
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + (String)entry.getKey()), (Throwable)ex);
            }
        }
        return Collections.unmodifiableList(results);
    }

    public List<Map<String, String>> getRoleQualifersForPrincipalByNamespaceAndRolename(String principalId, String namespaceCode, String roleName, Map<String, String> qualification) throws RiceIllegalStateException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        String roleId = this.getRoleIdByNamespaceCodeAndName(namespaceCode, roleName);
        if (roleId == null) {
            return Collections.emptyList();
        }
        return this.getNestedRoleQualifiersForPrincipalByRoleIds(principalId, Collections.singletonList(roleId), qualification);
    }

    public List<Map<String, String>> getNestedRoleQualifersForPrincipalByNamespaceAndRolename(String principalId, String namespaceCode, String roleName, Map<String, String> qualification) throws RiceIllegalStateException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        String roleId = this.getRoleIdByNamespaceCodeAndName(namespaceCode, roleName);
        if (roleId == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        return this.getNestedRoleQualifiersForPrincipalByRoleIds(principalId, Collections.singletonList(roleId), qualification);
    }

    public List<Map<String, String>> getNestedRoleQualifiersForPrincipalByRoleIds(String principalId, List<String> roleIds, Map<String, String> qualification) throws RiceIllegalStateException {
        RoleTypeService roleTypeService;
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(roleIds, "roleIds");
        ArrayList<Map> results = new ArrayList<Map>();
        Map<String, RoleBoLite> roleBosById = this.getRoleBoLiteMap(roleIds);
        List groupIds = this.getGroupService().getGroupIdsByPrincipalId(principalId);
        List<RoleMemberBo> roleMemberBos = this.getStoredRoleMembersUsingExactMatchOnQualification(principalId, groupIds, roleIds, qualification);
        HashMap roleIdToMembershipMap = new HashMap();
        for (RoleMemberBo roleMemberBo : roleMemberBos) {
            roleTypeService = this.getRoleTypeService(roleMemberBo.getRoleId());
            if (MemberType.PRINCIPAL.equals((Object)roleMemberBo.getType()) || MemberType.GROUP.equals((Object)roleMemberBo.getType())) {
                if (roleTypeService != null) {
                    ArrayList<RoleMembership> las = (ArrayList<RoleMembership>)roleIdToMembershipMap.get(roleMemberBo.getRoleId());
                    if (las == null) {
                        las = new ArrayList<RoleMembership>();
                        roleIdToMembershipMap.put(roleMemberBo.getRoleId(), las);
                    }
                    RoleMembership mi = RoleMembership.Builder.create((String)roleMemberBo.getRoleId(), (String)roleMemberBo.getId(), (String)roleMemberBo.getMemberId(), (MemberType)roleMemberBo.getType(), roleMemberBo.getAttributes(), (DateTime)roleMemberBo.getActiveFromDate(), (DateTime)roleMemberBo.getActiveToDate()).build();
                    las.add(mi);
                    continue;
                }
                results.add(roleMemberBo.getAttributes());
                continue;
            }
            if (!MemberType.ROLE.equals((Object)roleMemberBo.getType())) continue;
            Map<String, String> nestedQualification = qualification;
            if (roleTypeService != null) {
                RoleBoLite roleBo = roleBosById.get(roleMemberBo.getRoleId());
                RoleBoLite nestedRole = this.getRoleBoLite(roleMemberBo.getMemberId());
                try {
                    nestedQualification = this.getNestedQualification(nestedRole, roleBo.getNamespaceCode(), roleBo.getName(), nestedRole.getNamespaceCode(), nestedRole.getName(), qualification, roleMemberBo.getAttributes());
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for roleBo Id: " + roleBo.getId()), (Throwable)ex);
                }
            }
            ArrayList<String> nestedRoleId = new ArrayList<String>(1);
            nestedRoleId.add(roleMemberBo.getMemberId());
            if (!this.getProxiedRoleService().principalHasRole(principalId, nestedRoleId, nestedQualification, false)) continue;
            results.add(roleMemberBo.getAttributes());
        }
        for (Map.Entry entry : roleIdToMembershipMap.entrySet()) {
            roleTypeService = this.getRoleTypeService((String)entry.getKey());
            try {
                List matchingMembers = roleTypeService.getMatchingRoleMemberships(qualification, (List)entry.getValue());
                for (RoleMembership roleMembership : matchingMembers) {
                    results.add(roleMembership.getQualifier());
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + (String)entry.getKey()), (Throwable)ex);
            }
        }
        return Collections.unmodifiableList(results);
    }

    public List<RoleMembership> getRoleMembers(List<String> roleIds, Map<String, String> qualification) throws RiceIllegalStateException {
        this.incomingParamCheck(roleIds, "roleIds");
        HashSet<String> foundRoleTypeMembers = new HashSet<String>();
        List<RoleMembership> roleMembers = this.getRoleMembers(roleIds, qualification, true, foundRoleTypeMembers);
        return Collections.unmodifiableList(roleMembers);
    }

    public Collection<String> getRoleMemberPrincipalIds(String namespaceCode, String roleName, Map<String, String> qualification) throws RiceIllegalStateException {
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        HashSet<String> principalIds = new HashSet<String>();
        HashSet<String> foundRoleTypeMembers = new HashSet<String>();
        List<String> roleIds = Collections.singletonList(this.getRoleIdByNamespaceCodeAndName(namespaceCode, roleName));
        for (RoleMembership roleMembership : this.getRoleMembers(roleIds, qualification, false, foundRoleTypeMembers)) {
            if (MemberType.GROUP.equals((Object)roleMembership.getType())) {
                principalIds.addAll(this.getGroupService().getMemberPrincipalIds(roleMembership.getMemberId()));
                continue;
            }
            principalIds.add(roleMembership.getMemberId());
        }
        return Collections.unmodifiableSet(principalIds);
    }

    public boolean principalHasRole(String principalId, List<String> roleIds, Map<String, String> qualification) throws RiceIllegalStateException {
        if (LOG.isDebugEnabled()) {
            this.logPrincipalHasRoleCheck(principalId, roleIds, qualification);
        }
        boolean hasRole = this.getProxiedRoleService().principalHasRole(principalId, roleIds, qualification, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Result: " + hasRole));
        }
        return hasRole;
    }

    public List<String> getPrincipalIdSubListWithRole(List<String> principalIds, String roleNamespaceCode, String roleName, Map<String, String> qualification) throws RiceIllegalStateException {
        this.incomingParamCheck(principalIds, "principalIds");
        this.incomingParamCheck(roleNamespaceCode, "roleNamespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        ArrayList<String> subList = new ArrayList<String>();
        RoleBoLite role = this.getRoleBoLiteByName(roleNamespaceCode, roleName);
        for (String principalId : principalIds) {
            if (!this.getProxiedRoleService().principalHasRole(principalId, Collections.singletonList(role.getId()), qualification)) continue;
            subList.add(principalId);
        }
        return Collections.unmodifiableList(subList);
    }

    public RoleQueryResults findRoles(QueryByCriteria queryByCriteria) throws RiceIllegalStateException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(RoleBoLite.class, queryByCriteria);
        RoleQueryResults.Builder builder = RoleQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<Role.Builder> ims = new ArrayList<Role.Builder>();
        for (RoleBoLite bo : results.getResults()) {
            ims.add(Role.Builder.create((RoleContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public List<RoleMembership> getFirstLevelRoleMembers(List<String> roleIds) throws RiceIllegalStateException {
        this.incomingParamCheck(roleIds, "roleIds");
        if (roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<RoleMemberBo> roleMemberBoList = this.getStoredRoleMembersForRoleIds(roleIds, null, null);
        ArrayList<RoleMembership> roleMemberships = new ArrayList<RoleMembership>();
        for (RoleMemberBo roleMemberBo : roleMemberBoList) {
            RoleMembership roleMembeship = RoleMembership.Builder.create((String)roleMemberBo.getRoleId(), (String)roleMemberBo.getId(), (String)roleMemberBo.getMemberId(), (MemberType)roleMemberBo.getType(), roleMemberBo.getAttributes(), (DateTime)roleMemberBo.getActiveFromDate(), (DateTime)roleMemberBo.getActiveToDate()).build();
            roleMemberships.add(roleMembeship);
        }
        return Collections.unmodifiableList(roleMemberships);
    }

    public RoleMembershipQueryResults findRoleMemberships(QueryByCriteria queryByCriteria) throws RiceIllegalStateException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(RoleMemberBo.class, (QueryByCriteria)AttributeTransform.getInstance().apply((Object)queryByCriteria));
        RoleMembershipQueryResults.Builder builder = RoleMembershipQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<RoleMembership.Builder> ims = new ArrayList<RoleMembership.Builder>();
        for (RoleMemberBo bo : results.getResults()) {
            RoleMembership.Builder roleMembership = RoleMembership.Builder.create((String)bo.getRoleId(), (String)bo.getId(), (String)bo.getMemberId(), (MemberType)bo.getType(), bo.getAttributes(), (DateTime)bo.getActiveFromDate(), (DateTime)bo.getActiveToDate());
            ims.add(roleMembership);
        }
        builder.setResults(ims);
        return builder.build();
    }

    public List<DelegateMember> getDelegationMembersByDelegationId(String delegationId) throws RiceIllegalStateException {
        this.incomingParamCheck(delegationId, "delegationId");
        DelegateTypeBo delegateBo = this.getKimDelegationImpl(delegationId);
        if (delegateBo == null) {
            return Collections.emptyList();
        }
        return this.getDelegateMembersForDelegation(delegateBo);
    }

    public DelegateMember getDelegationMemberByDelegationAndMemberId(String delegationId, String memberId) throws RiceIllegalStateException {
        this.incomingParamCheck(delegationId, "delegationId");
        this.incomingParamCheck(memberId, "memberId");
        DelegateTypeBo delegateBo = this.getKimDelegationImpl(delegationId);
        DelegateMemberBo delegationMember = this.getKimDelegationMemberImplByDelegationAndId(delegationId, memberId);
        return this.getDelegateCompleteInfo(delegateBo, delegationMember);
    }

    public DelegateMember getDelegationMemberById(String delegationMemberId) throws RiceIllegalStateException {
        this.incomingParamCheck(delegationMemberId, "delegationMemberId");
        DelegateMemberBo delegateMemberBo = this.getDelegateMemberBo(delegationMemberId);
        if (delegateMemberBo == null) {
            return null;
        }
        DelegateTypeBo delegateBo = this.getKimDelegationImpl(delegateMemberBo.getDelegationId());
        return this.getDelegateCompleteInfo(delegateBo, delegateMemberBo);
    }

    public List<RoleResponsibility> getRoleResponsibilities(String roleId) throws RiceIllegalStateException {
        this.incomingParamCheck(roleId, "roleId");
        List roleResponsibilityBos = this.getDataObjectService().findMatching(RoleResponsibilityBo.class, QueryByCriteria.Builder.forAttribute((String)"roleId", (Object)roleId).build()).getResults();
        ArrayList<RoleResponsibility> roleResponsibilities = new ArrayList<RoleResponsibility>();
        for (RoleResponsibilityBo roleResponsibilityImpl : roleResponsibilityBos) {
            roleResponsibilities.add(RoleResponsibilityBo.to(roleResponsibilityImpl));
        }
        return Collections.unmodifiableList(roleResponsibilities);
    }

    public DelegateType getDelegateTypeByRoleIdAndDelegateTypeCode(String roleId, DelegationType delegationType) throws RiceIllegalStateException {
        this.incomingParamCheck(roleId, "roleId");
        this.incomingParamCheck(delegationType, "delegationType");
        DelegateTypeBo delegateBo = this.getDelegationOfType(roleId, delegationType);
        return DelegateTypeBo.to(delegateBo);
    }

    public DelegateType getDelegateTypeByDelegationId(String delegationId) throws RiceIllegalStateException {
        this.incomingParamCheck(delegationId, "delegationId");
        DelegateTypeBo delegateBo = this.getKimDelegationImpl(delegationId);
        return DelegateTypeBo.to(delegateBo);
    }

    /*
     * WARNING - void declaration
     */
    protected List<RoleMembership> getRoleMembers(List<String> roleIds, Map<String, String> qualification, boolean followDelegations, Set<String> foundRoleTypeMembers) {
        Map<String, DelegateTypeBo> map;
        RoleTypeService roleTypeService;
        List<Object> results = new ArrayList<RoleMembership>();
        HashSet<String> allRoleIds = new HashSet<String>();
        for (String roleId : roleIds) {
            if (!this.getProxiedRoleService().isRoleActive(roleId)) continue;
            allRoleIds.add(roleId);
        }
        if (allRoleIds.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> matchingRoleIds = new HashSet<String>(allRoleIds.size());
        Map<String, RoleBoLite> roles = this.getRoleBoLiteMap(allRoleIds);
        ArrayList<String> copyRoleIds = new ArrayList<String>(allRoleIds);
        ArrayList<RoleMemberBo> rms = new ArrayList<RoleMemberBo>();
        for (String string : allRoleIds) {
            List attributesForExactMatch;
            RoleTypeService roleTypeService2 = this.getRoleTypeService(string);
            if (roleTypeService2 == null || !CollectionUtils.isNotEmpty((Collection)(attributesForExactMatch = roleTypeService2.getQualifiersForExactMatch()))) continue;
            copyRoleIds.remove(string);
            rms.addAll(this.getStoredRoleMembersForRoleIds(Collections.singletonList(string), null, this.populateQualifiersForExactMatch(qualification, attributesForExactMatch)));
        }
        if (CollectionUtils.isNotEmpty(copyRoleIds)) {
            rms.addAll(this.getStoredRoleMembersForRoleIds(copyRoleIds, null, null));
        }
        HashMap<String, ArrayList<RoleMembership>> roleIdToMembershipMap = new HashMap<String, ArrayList<RoleMembership>>();
        for (RoleMemberBo roleMemberBo : rms) {
            RoleMembership mi = RoleMembership.Builder.create((String)roleMemberBo.getRoleId(), (String)roleMemberBo.getId(), (String)roleMemberBo.getMemberId(), (MemberType)roleMemberBo.getType(), roleMemberBo.getAttributes(), (DateTime)roleMemberBo.getActiveFromDate(), (DateTime)roleMemberBo.getActiveToDate()).build();
            if (qualification == null || qualification.isEmpty()) {
                if (MemberType.ROLE.equals((Object)roleMemberBo.getType())) {
                    Collection<RoleMembership> nestedRoleMembers;
                    Map<String, String> nestedRoleQualification = qualification;
                    RoleTypeService roleTypeService3 = this.getRoleTypeService(roleMemberBo.getRoleId());
                    if (roleTypeService3 != null) {
                        RoleBoLite memberRole = this.getRoleBoLite(mi.getMemberId());
                        nestedRoleQualification = this.getNestedQualification(memberRole, roles.get(roleMemberBo.getRoleId()).getNamespaceCode(), roles.get(roleMemberBo.getRoleId()).getName(), memberRole.getNamespaceCode(), memberRole.getName(), qualification, roleMemberBo.getAttributes());
                    }
                    if (this.getProxiedRoleService().isRoleActive(roleMemberBo.getRoleId()) && !(nestedRoleMembers = this.getNestedRoleMembers(nestedRoleQualification, mi, foundRoleTypeMembers)).isEmpty()) {
                        results.addAll(nestedRoleMembers);
                        matchingRoleIds.add(roleMemberBo.getRoleId());
                    }
                } else {
                    results.add(mi);
                    matchingRoleIds.add(roleMemberBo.getRoleId());
                }
                matchingRoleIds.add(roleMemberBo.getRoleId());
                continue;
            }
            ArrayList<RoleMembership> lrmi = (ArrayList<RoleMembership>)roleIdToMembershipMap.get(mi.getRoleId());
            if (lrmi == null) {
                lrmi = new ArrayList<RoleMembership>();
                roleIdToMembershipMap.put(mi.getRoleId(), lrmi);
            }
            lrmi.add(mi);
        }
        if (!roleIdToMembershipMap.isEmpty()) {
            for (Map.Entry entry : roleIdToMembershipMap.entrySet()) {
                try {
                    roleTypeService = this.getRoleTypeService((String)entry.getKey());
                    List matchingMembers = roleTypeService.getMatchingRoleMemberships(qualification, (List)entry.getValue());
                    for (RoleMembership roleMemberships : matchingMembers) {
                        if (MemberType.ROLE.equals((Object)roleMemberships.getType())) {
                            Map<String, String> nestedRoleQualification;
                            Collection<RoleMembership> nestedRoleMembers;
                            RoleBoLite memberRole = this.getRoleBoLite(roleMemberships.getMemberId());
                            if (!memberRole.isActive() || (nestedRoleMembers = this.getNestedRoleMembers(nestedRoleQualification = this.getNestedQualification(memberRole, roles.get(roleMemberships.getRoleId()).getNamespaceCode(), roles.get(roleMemberships.getRoleId()).getName(), memberRole.getNamespaceCode(), memberRole.getName(), qualification, roleMemberships.getQualifier()), roleMemberships, foundRoleTypeMembers)).isEmpty()) continue;
                            results.addAll(nestedRoleMembers);
                            matchingRoleIds.add(roleMemberships.getRoleId());
                            continue;
                        }
                        results.add(roleMemberships);
                        matchingRoleIds.add(roleMemberships.getRoleId());
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + (String)entry.getKey()), (Throwable)ex);
                }
            }
        }
        for (String string : allRoleIds) {
            roleTypeService = this.getRoleTypeService(string);
            RoleBoLite role = roles.get(string);
            try {
                if (!this.isDerivedRoleType(roleTypeService)) continue;
                List roleMembers = roleTypeService.getRoleMembersFromDerivedRole(role.getNamespaceCode(), role.getName(), qualification);
                if (!roleMembers.isEmpty()) {
                    matchingRoleIds.add(string);
                }
                for (RoleMembership rm : roleMembers) {
                    RoleMembership.Builder builder = RoleMembership.Builder.create((RoleMembershipContract)rm);
                    builder.setRoleId(string);
                    builder.setId("*");
                    builder.setActiveFromDate(rm.getActiveFromDate());
                    builder.setActiveToDate(rm.getActiveToDate());
                    results.add(builder.build());
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + string), (Throwable)ex);
            }
        }
        if (followDelegations && !matchingRoleIds.isEmpty() && !(map = this.getStoredDelegationImplMapFromRoleIds(matchingRoleIds)).isEmpty()) {
            List<RoleMembership.Builder> list = this.applyDelegationsToRoleMembers(results, map.values(), qualification);
            this.resolveDelegationMemberRoles(list, qualification, foundRoleTypeMembers);
            results = ModelObjectUtils.buildImmutableCopy(list);
        }
        if (results.size() > 1) {
            if (matchingRoleIds.size() == 1) {
                String string = (String)matchingRoleIds.iterator().next();
                RoleTypeService roleTypeService3 = this.getRoleTypeService(string);
                try {
                    if (roleTypeService3 != null) {
                        results = roleTypeService3.sortRoleMembers(results);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + string), (Throwable)ex);
                }
            } else if (matchingRoleIds.size() > 1) {
                boolean bl;
                Object var12_20 = null;
                boolean bl2 = false;
                for (String roleId : matchingRoleIds) {
                    void var12_21;
                    String serviceName = KimApiServiceLocator.getKimTypeInfoService().getKimType(this.getRole(roleId).getKimTypeId()).getServiceName();
                    if (var12_21 != null && !StringUtils.equals((String)var12_21, (String)serviceName)) {
                        bl = true;
                        break;
                    }
                    String string = serviceName;
                }
                if (!bl) {
                    String roleId = (String)matchingRoleIds.iterator().next();
                    try {
                        RoleTypeService kimRoleTypeService = this.getRoleTypeService(roleId);
                        if (kimRoleTypeService != null) {
                            results = kimRoleTypeService.sortRoleMembers(results);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + roleId), (Throwable)ex);
                    }
                } else {
                    LOG.warn((Object)("Did not sort role members - multiple role type services found.  Role Ids: " + matchingRoleIds));
                }
            }
        }
        return Collections.unmodifiableList(results);
    }

    protected List<RoleMembership.Builder> applyDelegationsToRoleMembers(List<RoleMembership> roleMemberships, Collection<DelegateTypeBo> delegations, Map<String, String> qualification) {
        LinkedMultiValueMap roleIdToRoleMembershipIds = new LinkedMultiValueMap();
        LinkedMultiValueMap roleMembershipIdToBuilders = new LinkedMultiValueMap();
        ArrayList<RoleMembership.Builder> roleMembershipBuilders = new ArrayList<RoleMembership.Builder>();
        for (RoleMembership roleMembership : roleMemberships) {
            roleIdToRoleMembershipIds.add((Object)roleMembership.getRoleId(), (Object)roleMembership.getId());
            RoleMembership.Builder builder = RoleMembership.Builder.create((RoleMembershipContract)roleMembership);
            builder.setActiveFromDate(roleMembership.getActiveFromDate());
            builder.setActiveToDate(roleMembership.getActiveToDate());
            roleMembershipBuilders.add(builder);
            roleMembershipIdToBuilders.add((Object)roleMembership.getId(), (Object)builder);
        }
        for (DelegateTypeBo delegation : delegations) {
            List candidateRoleMembershipIds = (List)roleIdToRoleMembershipIds.get((Object)delegation.getRoleId());
            if (!CollectionUtils.isNotEmpty((Collection)candidateRoleMembershipIds)) continue;
            DelegationTypeService delegationTypeService = this.getDelegationTypeService(delegation.getDelegationId());
            for (DelegateMemberBo delegationMember : delegation.getMembers()) {
                if (!delegationMember.isActive(DateTime.now()) || delegationTypeService != null && !delegationTypeService.doesDelegationQualifierMatchQualification(qualification, delegationMember.getQualifier())) continue;
                DelegateMember.Builder delegateMemberBuilder = DelegateMember.Builder.create((DelegateMemberContract)delegationMember);
                if (StringUtils.isBlank((String)delegationMember.getRoleMemberId())) {
                    RoleTypeService roleTypeService = this.getRoleTypeService(delegation.getRoleId());
                    for (String roleMembershipId : candidateRoleMembershipIds) {
                        for (RoleMembership.Builder roleMembershipBuilder : (List)roleMembershipIdToBuilders.get((Object)roleMembershipId)) {
                            if (roleTypeService != null && !roleTypeService.doesRoleQualifierMatchQualification(roleMembershipBuilder.getQualifier(), delegationMember.getQualifier())) continue;
                            this.linkDelegateToRoleMembership(delegation, delegateMemberBuilder, roleMembershipBuilder);
                        }
                    }
                    continue;
                }
                if (!candidateRoleMembershipIds.contains(delegationMember.getRoleMemberId())) continue;
                for (RoleMembership.Builder roleMembershipBuilder : (List)roleMembershipIdToBuilders.get((Object)delegationMember.getRoleMemberId())) {
                    this.linkDelegateToRoleMembership(delegation, delegateMemberBuilder, roleMembershipBuilder);
                }
            }
        }
        return roleMembershipBuilders;
    }

    protected void linkDelegateToRoleMembership(DelegateTypeBo delegation, DelegateMember.Builder delegateMemberBuilder, RoleMembership.Builder roleMembershipBuilder) {
        DelegateType.Builder delegateBuilder = null;
        for (DelegateType.Builder existingDelegateBuilder : roleMembershipBuilder.getDelegates()) {
            if (!existingDelegateBuilder.getDelegationId().equals(delegation.getDelegationId())) continue;
            delegateBuilder = existingDelegateBuilder;
        }
        if (delegateBuilder == null) {
            delegateBuilder = DelegateType.Builder.create((DelegateTypeContract)delegation);
            delegateBuilder.setMembers(new ArrayList());
            roleMembershipBuilder.getDelegates().add(delegateBuilder);
        }
        delegateBuilder.getMembers().add(delegateMemberBuilder);
    }

    protected void resolveDelegationMemberRoles(List<RoleMembership.Builder> membershipBuilders, Map<String, String> qualification, Set<String> foundRoleTypeMembers) {
        for (RoleMembership.Builder roleMembership : membershipBuilders) {
            for (DelegateType.Builder delegation : roleMembership.getDelegates()) {
                ArrayList<DelegateMember.Builder> newMembers = new ArrayList<DelegateMember.Builder>();
                for (DelegateMember.Builder member : delegation.getMembers()) {
                    if (MemberType.ROLE.equals((Object)member.getType())) {
                        List<RoleMembership> delegateMembers = this.getRoleMembers(Collections.singletonList(member.getMemberId()), qualification, false, foundRoleTypeMembers);
                        for (RoleMembership rmi : delegateMembers) {
                            DelegateMember.Builder delegateMember = DelegateMember.Builder.create((DelegateMemberContract)member);
                            delegateMember.setMemberId(rmi.getMemberId());
                            delegateMember.setType(rmi.getType());
                            newMembers.add(delegateMember);
                        }
                        continue;
                    }
                    newMembers.add(member);
                }
                delegation.setMembers(newMembers);
            }
        }
    }

    public boolean principalHasRole(String principalId, List<String> roleIds, Map<String, String> qualification, boolean checkDelegations) {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(roleIds, "roleIds");
        return this.principalHasRole(new Context(principalId), principalId, roleIds, qualification, checkDelegations);
    }

    protected boolean principalHasRole(Context context, String principalId, List<String> roleIds, Map<String, String> qualification, boolean checkDelegations) {
        try {
            ArrayList<String> roleIdsToCheck = new ArrayList<String>(roleIds.size());
            for (String roleId : roleIds) {
                Boolean hasRole = this.getPrincipalHasRoleFromCache(principalId, roleId, qualification, checkDelegations);
                if (hasRole != null) {
                    if (!hasRole.booleanValue()) continue;
                    return true;
                }
                roleIdsToCheck.add(roleId);
            }
            List<Role> roles = this.loadRoles(roleIdsToCheck);
            if (roles.isEmpty()) {
                return false;
            }
            LinkedList<Role> sortedRoles = new LinkedList<Role>();
            for (Role role : roles) {
                boolean isDerivedRoleType = context.isDerivedRoleType(role.getKimTypeId());
                if (isDerivedRoleType) {
                    sortedRoles.addLast(role);
                    continue;
                }
                sortedRoles.addFirst(role);
            }
            for (Role role : sortedRoles) {
                boolean hasRole;
                RoleTypeService roleTypeService = null;
                try {
                    roleTypeService = context.getRoleTypeService(role.getKimTypeId());
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Unable to find role type service with id: " + role.getKimTypeId()), (Throwable)ex);
                }
                boolean isDerivedRoleType = context.isDerivedRoleType(role.getKimTypeId());
                if (isDerivedRoleType) {
                    hasRole = this.principalHasDerivedRole(context, principalId, role, qualification, roleTypeService);
                } else {
                    hasRole = this.checkForMatchOnQualifications(context, principalId, role, qualification, roleTypeService);
                    if (!hasRole) {
                        hasRole = this.checkForMatchOnNestedRoles(context, principalId, role, qualification, roleTypeService);
                    }
                }
                if (!hasRole && checkDelegations && this.matchesOnDelegation(role.getId(), principalId, context.getPrincipalGroupIds(), qualification, context)) {
                    hasRole = true;
                }
                if (!isDerivedRoleType || roleTypeService == null || !roleTypeService.dynamicRoleMembership(role.getNamespaceCode(), role.getName())) {
                    this.putPrincipalHasRoleInCache(hasRole, principalId, role.getId(), qualification, checkDelegations);
                }
                if (!hasRole) continue;
                return true;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Caught exception during a principalHasRole check", (Throwable)e);
        }
        return false;
    }

    protected Boolean getPrincipalHasRoleFromCache(String principalId, String roleId, Map<String, String> qualification, boolean checkDelegations) {
        String key = this.buildPrincipalHasRoleCacheKey(principalId, roleId, qualification, checkDelegations);
        Cache.ValueWrapper value = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/RoleType").get((Object)key);
        return value == null ? null : (Boolean)value.get();
    }

    protected boolean putPrincipalHasRoleInCache(boolean principalHasRole, String principalId, String roleId, Map<String, String> qualification, boolean checkDelegations) {
        String key = this.buildPrincipalHasRoleCacheKey(principalId, roleId, qualification, checkDelegations);
        this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/RoleType").put((Object)key, (Object)principalHasRole);
        return principalHasRole;
    }

    private String buildPrincipalHasRoleCacheKey(String principalId, String roleId, Map<String, String> qualification, boolean checkDelegations) {
        return "{principalHasRole}" + "principalId=" + principalId + "|" + "roleId=" + roleId + "|" + "qualification=" + CacheKeyUtils.mapKey(qualification) + "|" + "checkDelegations=" + checkDelegations;
    }

    protected boolean principalHasDerivedRole(Context context, String principalId, Role role, Map<String, String> qualification, RoleTypeService roleTypeService) {
        try {
            if (roleTypeService != null && roleTypeService.hasDerivedRole(principalId, context.getPrincipalGroupIds(), role.getNamespaceCode(), role.getName(), qualification)) {
                return true;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + role.getId()), (Throwable)ex);
        }
        return false;
    }

    protected boolean checkForMatchOnQualifications(Context context, String principalId, Role role, Map<String, String> qualification, RoleTypeService roleTypeService) {
        Map<String, String> qualificationForExactMatch = this.getQualifiersForExactMatch(context, role, qualification);
        if (qualificationForExactMatch != null) {
            List<RoleMemberBo> matchingRoleGroupMembers;
            List<RoleMemberBo> matchingRoleMembers = this.getStoredRolePrincipalsForPrincipalIdAndRoleIds(Collections.singletonList(role.getId()), principalId, qualificationForExactMatch);
            if (CollectionUtils.isNotEmpty(matchingRoleMembers)) {
                return true;
            }
            if (!context.getPrincipalGroupIds().isEmpty() && CollectionUtils.isNotEmpty(matchingRoleGroupMembers = this.getStoredRoleGroupsUsingExactMatchOnQualification(context.getPrincipalGroupIds(), role.getId(), qualification))) {
                return true;
            }
        } else {
            List<RoleMemberBo> matchingPrincipalRoleMembers = this.getRoleMembersForPrincipalId(Collections.singletonList(role.getId()), principalId);
            List<RoleMemberBo> matchingGroupRoleMembers = this.getRoleMembersForGroupIds(role.getId(), context.getPrincipalGroupIds());
            List<RoleMembership> roleMemberships = this.convertToRoleMemberships(matchingPrincipalRoleMembers, matchingGroupRoleMembers);
            try {
                if (roleTypeService != null && !roleMemberships.isEmpty() && !roleTypeService.getMatchingRoleMemberships(qualification, roleMemberships).isEmpty()) {
                    return true;
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to find role type service with id: " + role.getKimTypeId()));
            }
        }
        return false;
    }

    protected Map<String, String> getQualifiersForExactMatch(Context context, Role role, Map<String, String> qualification) {
        Map<String, String> qualificationForExactMatch = null;
        if (qualification == null || qualification.isEmpty()) {
            qualificationForExactMatch = new HashMap<String, String>();
        } else {
            RoleTypeService roleTypeService = context.getRoleTypeService(role.getKimTypeId());
            if (roleTypeService == null) {
                return null;
            }
            List<String> attributesForExactMatch = this.getQualifiersForExactMatchFromRoleType(role.getKimTypeId(), roleTypeService);
            if (CollectionUtils.isNotEmpty(attributesForExactMatch) && (qualificationForExactMatch = this.populateQualifiersForExactMatch(qualification, attributesForExactMatch)).isEmpty()) {
                qualificationForExactMatch = null;
            }
        }
        return qualificationForExactMatch;
    }

    protected boolean checkForMatchOnNestedRoles(Context context, String principalId, Role role, Map<String, String> qualification, RoleTypeService roleTypeService) {
        HashMap<String, Role> roleIndex = new HashMap<String, Role>();
        roleIndex.put(role.getId(), role);
        List<RoleMemberBo> roleMemberBos = this.getStoredRoleMembersForRoleIds(new ArrayList<String>(roleIndex.keySet()), MemberType.ROLE.getCode(), null);
        for (RoleMemberBo roleMemberBo : roleMemberBos) {
            try {
                if (roleTypeService != null) {
                    if (!roleTypeService.doesRoleQualifierMatchQualification(qualification, roleMemberBo.getAttributes())) continue;
                    RoleBoLite memberRole = this.getRoleBoLite(roleMemberBo.getMemberId());
                    Map<String, String> nestedRoleQualification = this.getNestedQualification(memberRole, role.getNamespaceCode(), role.getName(), memberRole.getNamespaceCode(), memberRole.getName(), qualification, roleMemberBo.getAttributes());
                    if (!this.principalHasRole(context, principalId, Collections.singletonList(roleMemberBo.getMemberId()), nestedRoleQualification, true)) continue;
                    return true;
                }
                if (!this.principalHasRole(context, principalId, Collections.singletonList(roleMemberBo.getMemberId()), qualification, true)) continue;
                return true;
            }
            catch (Exception ex) {
                LOG.warn((Object)("Not able to retrieve RoleTypeService from remote system for role Id: " + roleMemberBo.getRoleId()), (Throwable)ex);
            }
        }
        return false;
    }

    protected List<String> getQualifiersForExactMatchFromRoleType(String kimTypeId, RoleTypeService roleTypeService) {
        String cacheKey = "{getQualifiersForExactMatch}kimTypeId=" + kimTypeId;
        Cache cache = this.cacheManager.getCache("http://rice.kuali.org/kim/v2_0/RoleType");
        Cache.ValueWrapper value = cache.get((Object)cacheKey);
        ArrayList<String> qualifiers = new ArrayList();
        if (value == null) {
            try {
                qualifiers = roleTypeService.getQualifiersForExactMatch();
                cache.put((Object)cacheKey, qualifiers);
            }
            catch (Exception e) {
                LOG.warn((Object)"Caught exception when attempting to invoke a role type service", (Throwable)e);
            }
        } else {
            qualifiers = (List)value.get();
        }
        return qualifiers;
    }

    public boolean isDerivedRoleType(RoleTypeService service) {
        return service != null && service.isDerivedRoleType();
    }

    private boolean dynamicRoleMembership(RoleTypeService service, Role role) {
        return service != null && role != null && service.dynamicRoleMembership(role.getNamespaceCode(), role.getName());
    }

    public boolean isDerivedRole(String roleId) {
        this.incomingParamCheck(roleId, "roleId");
        RoleTypeService service = this.getRoleTypeService(roleId);
        return this.isDerivedRoleType(service);
    }

    public boolean isDynamicRoleMembership(String roleId) {
        this.incomingParamCheck(roleId, "roleId");
        RoleTypeService service = this.getRoleTypeService(roleId);
        try {
            return this.dynamicRoleMembership(service, this.getRole(roleId));
        }
        catch (Exception e) {
            LOG.warn((Object)("Caught exception while invoking a role type service for role " + roleId), (Throwable)e);
            return true;
        }
    }

    protected boolean matchesOnDelegation(String roleId, String principalId, List<String> principalGroupIds, Map<String, String> qualification, Context context) {
        HashSet<String> allRoleIds = new HashSet<String>();
        allRoleIds.add(roleId);
        Map<String, DelegateTypeBo> delegations = this.getStoredDelegationImplMapFromRoleIds(allRoleIds);
        if (delegations.isEmpty()) {
            return false;
        }
        HashMap<String, ArrayList<DelegateTypeBo>> roleToDelegations = new HashMap<String, ArrayList<DelegateTypeBo>>();
        for (DelegateTypeBo delegation : delegations.values()) {
            ArrayList<DelegateTypeBo> roleDelegations = (ArrayList<DelegateTypeBo>)roleToDelegations.get(delegation.getRoleId());
            if (roleDelegations == null) {
                roleDelegations = new ArrayList<DelegateTypeBo>();
                roleToDelegations.put(delegation.getRoleId(), roleDelegations);
            }
            roleDelegations.add(delegation);
        }
        for (String delegationRoleId : roleToDelegations.keySet()) {
            boolean matchesOnRoleDelegation = false;
            Role role = this.getRole(delegationRoleId);
            RoleTypeService roleTypeService = context.getRoleTypeService(role.getKimTypeId());
            for (DelegateTypeBo delegation : (List)roleToDelegations.get(delegationRoleId)) {
                if (!delegation.isActive()) continue;
                for (DelegateMemberBo delegateMemberBo : delegation.getMembers()) {
                    block15: {
                        block14: {
                            if (!delegateMemberBo.isActive(new Timestamp(new Date().getTime())) || MemberType.PRINCIPAL.equals((Object)delegateMemberBo.getType()) && !delegateMemberBo.getMemberId().equals(principalId) || MemberType.GROUP.equals((Object)delegateMemberBo.getType()) && !principalGroupIds.contains(delegateMemberBo.getMemberId()) || MemberType.ROLE.equals((Object)delegateMemberBo.getType()) && !this.principalHasRole(principalId, Collections.singletonList(delegateMemberBo.getMemberId()), qualification, false)) continue;
                            try {
                                if (roleTypeService != null && !roleTypeService.doesRoleQualifierMatchQualification(qualification, delegateMemberBo.getQualifier())) {
                                }
                                break block14;
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)("Unable to call doesRoleQualifierMatchQualification on role type service for role Id: " + delegation.getRoleId() + " / " + qualification + " / " + delegateMemberBo.getQualifier()), (Throwable)ex);
                            }
                            continue;
                        }
                        DelegationTypeService delegationTypeService = this.getDelegationTypeService(delegateMemberBo.getDelegationId());
                        if (delegationTypeService != null && !delegationTypeService.doesDelegationQualifierMatchQualification(qualification, delegateMemberBo.getQualifier())) continue;
                        if (StringUtils.isNotBlank((String)delegateMemberBo.getRoleMemberId())) {
                            RoleMemberBo rm = this.getRoleMemberBo(delegateMemberBo.getRoleMemberId());
                            if (rm != null) {
                                if (!rm.isActive(new Timestamp(new Date().getTime()))) continue;
                                Map<String, String> roleQualifier = rm.getAttributes();
                                try {
                                    if (roleTypeService != null && !roleTypeService.doesRoleQualifierMatchQualification(qualification, roleQualifier)) {
                                    }
                                    break block15;
                                }
                                catch (Exception ex) {
                                    LOG.warn((Object)("Unable to call doesRoleQualifierMatchQualification on role type service for role Id: " + delegation.getRoleId() + " / " + qualification + " / " + roleQualifier), (Throwable)ex);
                                }
                                continue;
                            }
                            LOG.warn((Object)"Unknown role member ID cited in the delegateBo member table:");
                            LOG.warn((Object)("       assignedToId: " + delegateMemberBo.getDelegationMemberId() + " / roleMemberId: " + delegateMemberBo.getRoleMemberId()));
                        }
                    }
                    matchesOnRoleDelegation = true;
                    break;
                }
                if (!matchesOnRoleDelegation) continue;
                break;
            }
            if (!matchesOnRoleDelegation) continue;
            return matchesOnRoleDelegation;
        }
        return false;
    }

    protected List<RoleMembership> convertToRoleMemberships(List<RoleMemberBo> ... roleMemberLists) {
        ArrayList<RoleMembership> roleMemberships = new ArrayList<RoleMembership>();
        for (List<RoleMemberBo> roleMembers : roleMemberLists) {
            for (RoleMemberBo roleMember : roleMembers) {
                RoleMembership roleMembership = RoleMembership.Builder.create((String)roleMember.getRoleId(), (String)roleMember.getId(), (String)roleMember.getMemberId(), (MemberType)roleMember.getType(), roleMember.getAttributes(), (DateTime)roleMember.getActiveFromDate(), (DateTime)roleMember.getActiveToDate()).build();
                roleMemberships.add(roleMembership);
            }
        }
        return roleMemberships;
    }

    protected boolean getRoleIdToMembershipMap(Map<String, List<RoleMembership>> roleIdToMembershipMap, List<RoleMemberBo> roleMembers) {
        for (RoleMemberBo roleMemberBo : roleMembers) {
            RoleMembership roleMembership = RoleMembership.Builder.create((String)roleMemberBo.getRoleId(), (String)roleMemberBo.getId(), (String)roleMemberBo.getMemberId(), (MemberType)roleMemberBo.getType(), roleMemberBo.getAttributes(), (DateTime)roleMemberBo.getActiveFromDate(), (DateTime)roleMemberBo.getActiveToDate()).build();
            if (this.getRoleTypeService(roleMemberBo.getRoleId()) == null) {
                return true;
            }
            List<RoleMembership> lrmi = roleIdToMembershipMap.get(roleMembership.getRoleId());
            if (lrmi == null) {
                lrmi = new ArrayList<RoleMembership>();
                roleIdToMembershipMap.put(roleMembership.getRoleId(), lrmi);
            }
            lrmi.add(roleMembership);
        }
        return false;
    }

    protected DelegateTypeBo getKimDelegationImpl(String delegationId) {
        if (StringUtils.isBlank((String)delegationId)) {
            return null;
        }
        return (DelegateTypeBo)((Object)this.getDataObjectService().find(DelegateTypeBo.class, (Object)delegationId));
    }

    protected DelegationTypeService getDelegationTypeService(String delegationId) {
        DelegationTypeService service = null;
        DelegateTypeBo delegateBo = this.getKimDelegationImpl(delegationId);
        KimType delegationType = KimApiServiceLocator.getKimTypeInfoService().getKimType(delegateBo.getKimTypeId());
        if (delegationType != null) {
            KimTypeService tempService = KimFrameworkServiceLocator.getKimTypeService((KimType)delegationType);
            if (tempService != null && tempService instanceof DelegationTypeService) {
                service = (DelegationTypeService)tempService;
            } else {
                LOG.error((Object)("Service returned for type " + delegationType + "(" + delegationType.getName() + ") was not a DelegationTypeService.  Was a " + (tempService != null ? tempService.getClass() : "(null)")));
            }
        } else {
            RoleTypeService roleTypeService = this.getRoleTypeService(delegateBo.getRoleId());
            if (roleTypeService != null && roleTypeService instanceof DelegationTypeService) {
                service = (DelegationTypeService)roleTypeService;
            }
        }
        return service;
    }

    protected Collection<RoleMembership> getNestedRoleMembers(Map<String, String> qualification, RoleMembership rm, Set<String> foundRoleTypeMembers) {
        if (foundRoleTypeMembers.contains(rm.getMemberId())) {
            return new ArrayList<RoleMembership>();
        }
        foundRoleTypeMembers.add(rm.getMemberId());
        ArrayList<String> roleIdList = new ArrayList<String>(1);
        roleIdList.add(rm.getMemberId());
        List<RoleMembership> currentNestedRoleMembers = this.getRoleMembers(roleIdList, qualification, false, foundRoleTypeMembers);
        ArrayList<RoleMembership> returnRoleMembers = new ArrayList<RoleMembership>();
        for (RoleMembership roleMembership : currentNestedRoleMembers) {
            RoleMembership.Builder rmBuilder = RoleMembership.Builder.create((RoleMembershipContract)roleMembership);
            rmBuilder.setId(rm.getId());
            rmBuilder.setRoleId(rm.getRoleId());
            rmBuilder.setEmbeddedRoleId(rm.getMemberId());
            rmBuilder.setActiveFromDate(rm.getActiveFromDate());
            rmBuilder.setActiveToDate(rm.getActiveToDate());
            returnRoleMembers.add(rmBuilder.build());
        }
        return returnRoleMembers;
    }

    protected DelegateMemberBo getKimDelegationMemberImplByDelegationAndId(String delegationId, String delegationMemberId) {
        if (StringUtils.isBlank((String)delegationId) || StringUtils.isBlank((String)delegationMemberId)) {
            return null;
        }
        HashMap<String, String> searchCriteria = new HashMap<String, String>(2);
        searchCriteria.put("delegationId", delegationId);
        searchCriteria.put("delegationMemberId", delegationMemberId);
        QueryResults memberList = this.getDataObjectService().findMatching(DelegateMemberBo.class, QueryByCriteria.Builder.andAttributes(searchCriteria).build());
        if (!memberList.getResults().isEmpty()) {
            return (DelegateMemberBo)((Object)memberList.getResults().get(0));
        }
        return null;
    }

    private List<RoleMemberBo> getStoredRoleMembersUsingExactMatchOnQualification(String principalId, List<String> groupIds, List<String> roleIds, Map<String, String> qualification) {
        ArrayList<String> copyRoleIds = new ArrayList<String>(roleIds);
        ArrayList<RoleMemberBo> roleMemberBoList = new ArrayList<RoleMemberBo>();
        for (String roleId : roleIds) {
            RoleTypeService roleTypeService = this.getRoleTypeService(roleId);
            if (roleTypeService == null) continue;
            List attributesForExactMatch = null;
            try {
                attributesForExactMatch = roleTypeService.getQualifiersForExactMatch();
            }
            catch (Exception e) {
                LOG.warn((Object)("Caught exception when attempting to invoke a role type service for role " + roleId), (Throwable)e);
            }
            if (!CollectionUtils.isNotEmpty((Collection)attributesForExactMatch)) continue;
            copyRoleIds.remove(roleId);
            roleMemberBoList.addAll(this.getStoredRoleMembersForRoleIdsWithFilters(Collections.singletonList(roleId), principalId, groupIds, this.populateQualifiersForExactMatch(qualification, attributesForExactMatch)));
        }
        if (CollectionUtils.isNotEmpty(copyRoleIds)) {
            roleMemberBoList.addAll(this.getStoredRoleMembersForRoleIdsWithFilters(copyRoleIds, principalId, groupIds, null));
        }
        return roleMemberBoList;
    }

    private List<RoleMemberBo> getStoredRoleGroupsUsingExactMatchOnQualification(List<String> groupIds, String roleId, Map<String, String> qualification) {
        HashSet<String> roleIds = new HashSet<String>();
        if (roleId != null) {
            roleIds.add(roleId);
        }
        return this.getStoredRoleGroupsUsingExactMatchOnQualification(groupIds, roleIds, qualification);
    }

    private List<RoleMemberBo> getStoredRoleGroupsUsingExactMatchOnQualification(List<String> groupIds, Set<String> roleIds, Map<String, String> qualification) {
        ArrayList<String> copyRoleIds = new ArrayList<String>(roleIds);
        ArrayList<RoleMemberBo> roleMemberBos = new ArrayList<RoleMemberBo>();
        for (String roleId : roleIds) {
            RoleTypeService roleTypeService = this.getRoleTypeService(roleId);
            if (roleTypeService == null) continue;
            List attributesForExactMatch = null;
            try {
                attributesForExactMatch = roleTypeService.getQualifiersForExactMatch();
            }
            catch (Exception e) {
                LOG.warn((Object)("Caught exception when attempting to invoke a role type service for role " + roleId), (Throwable)e);
            }
            if (!CollectionUtils.isNotEmpty((Collection)attributesForExactMatch)) continue;
            copyRoleIds.remove(roleId);
            roleMemberBos.addAll(this.getStoredRoleGroupsForGroupIdsAndRoleIds(Collections.singletonList(roleId), groupIds, this.populateQualifiersForExactMatch(qualification, attributesForExactMatch)));
        }
        if (CollectionUtils.isNotEmpty(copyRoleIds)) {
            roleMemberBos.addAll(this.getStoredRoleGroupsForGroupIdsAndRoleIds(copyRoleIds, groupIds, null));
        }
        return roleMemberBos;
    }

    private List<DelegateMember> getDelegateMembersForDelegation(DelegateTypeBo delegateBo) {
        if (delegateBo == null || delegateBo.getMembers() == null) {
            return null;
        }
        ArrayList<DelegateMember> delegateMembersReturnList = new ArrayList<DelegateMember>();
        for (DelegateMemberBo delegateMemberBo : delegateBo.getMembers()) {
            DelegateMember delegateMember = this.getDelegateCompleteInfo(delegateBo, delegateMemberBo);
            delegateMembersReturnList.add(DelegateMemberBo.to(delegateMemberBo));
        }
        return Collections.unmodifiableList(delegateMembersReturnList);
    }

    private DelegateMember getDelegateCompleteInfo(DelegateTypeBo delegateBo, DelegateMemberBo delegateMemberBo) {
        if (delegateBo == null || delegateMemberBo == null) {
            return null;
        }
        DelegateMember.Builder delegateMemberBuilder = DelegateMember.Builder.create((DelegateMemberContract)delegateMemberBo);
        delegateMemberBuilder.setType(delegateMemberBo.getType());
        return delegateMemberBuilder.build();
    }

    public RoleMember assignPrincipalToRole(String principalId, String namespaceCode, String roleName, Map<String, String> qualifier) throws RiceIllegalArgumentException {
        this.incomingParamCheck(principalId, "principalId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        this.incomingParamCheck(qualifier, "qualifier");
        RoleBoLite role = this.getRoleBoLiteByName(namespaceCode, roleName);
        List<RoleMember> membersMatchByExactQualifiers = this.doAnyMemberRecordsMatchByExactQualifier(role, principalId, memberTypeToRoleDaoActionMap.get(MemberType.PRINCIPAL.getCode()), qualifier);
        if (CollectionUtils.isNotEmpty(membersMatchByExactQualifiers)) {
            return membersMatchByExactQualifiers.get(0);
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(role.getId());
        List<RoleMemberBo> roleMembers = this.getRoleDao().getRoleMembersForRoleIds(roleIds, MemberType.PRINCIPAL.getCode(), qualifier);
        RoleMember anyMemberMatch = this.doAnyMemberRecordsMatch(roleMembers, principalId, MemberType.PRINCIPAL.getCode(), qualifier);
        if (null != anyMemberMatch) {
            return anyMemberMatch;
        }
        RoleMemberBo newRoleMember = new RoleMemberBo();
        newRoleMember.setRoleId(role.getId());
        newRoleMember.setMemberId(principalId);
        newRoleMember.setType(MemberType.PRINCIPAL);
        this.addMemberAttributeData(newRoleMember, qualifier, role.getKimTypeId());
        return RoleMemberBo.to(this.getResponsibilityInternalService().saveRoleMember(newRoleMember));
    }

    public RoleMember assignGroupToRole(String groupId, String namespaceCode, String roleName, Map<String, String> qualifier) throws RiceIllegalStateException {
        this.incomingParamCheck(groupId, "groupId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        this.incomingParamCheck(qualifier, "qualifier");
        RoleBo role = this.getRoleBoByName(namespaceCode, roleName);
        List<RoleMember> membersMatchByExactQualifiers = this.doAnyMemberRecordsMatchByExactQualifier(role, groupId, memberTypeToRoleDaoActionMap.get(MemberType.GROUP.getCode()), qualifier);
        if (CollectionUtils.isNotEmpty(membersMatchByExactQualifiers)) {
            return membersMatchByExactQualifiers.get(0);
        }
        RoleMember anyMemberMatch = this.doAnyMemberRecordsMatch(role.getMembers(), groupId, MemberType.GROUP.getCode(), qualifier);
        if (null != anyMemberMatch) {
            return anyMemberMatch;
        }
        RoleMemberBo newRoleMember = new RoleMemberBo();
        newRoleMember.setRoleId(role.getId());
        newRoleMember.setMemberId(groupId);
        newRoleMember.setType(MemberType.GROUP);
        this.addMemberAttributeData(newRoleMember, qualifier, role.getKimTypeId());
        return RoleMemberBo.to(this.getResponsibilityInternalService().saveRoleMember(newRoleMember));
    }

    public RoleMember assignRoleToRole(String roleId, String namespaceCode, String roleName, Map<String, String> qualifier) throws RiceIllegalStateException {
        this.incomingParamCheck(roleId, "roleId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        this.incomingParamCheck(qualifier, "qualifier");
        RoleBo roleBo = this.getRoleBoByName(namespaceCode, roleName);
        List<RoleMember> membersMatchByExactQualifiers = this.doAnyMemberRecordsMatchByExactQualifier(roleBo, roleId, memberTypeToRoleDaoActionMap.get(MemberType.ROLE.getCode()), qualifier);
        if (CollectionUtils.isNotEmpty(membersMatchByExactQualifiers)) {
            return membersMatchByExactQualifiers.get(0);
        }
        RoleMember anyMemberMatch = this.doAnyMemberRecordsMatch(roleBo.getMembers(), roleId, MemberType.ROLE.getCode(), qualifier);
        if (null != anyMemberMatch) {
            return anyMemberMatch;
        }
        if (!this.checkForCircularRoleMembership(roleId, roleBo)) {
            throw new IllegalArgumentException("Circular roleBo reference.");
        }
        RoleMemberBo newRoleMember = new RoleMemberBo();
        newRoleMember.setRoleId(roleBo.getId());
        newRoleMember.setMemberId(roleId);
        newRoleMember.setType(MemberType.ROLE);
        this.addMemberAttributeData(newRoleMember, qualifier, roleBo.getKimTypeId());
        return RoleMemberBo.to(this.getResponsibilityInternalService().saveRoleMember(newRoleMember));
    }

    public RoleMember createRoleMember(RoleMember roleMember) throws RiceIllegalStateException {
        this.incomingParamCheck(roleMember, "roleMember");
        if (StringUtils.isNotBlank((String)roleMember.getId()) && this.getRoleMemberBo(roleMember.getId()) != null) {
            throw new RiceIllegalStateException("the roleMember to create already exists: " + roleMember);
        }
        String kimTypeId = this.getRoleBoLite(roleMember.getRoleId()).getKimTypeId();
        List<RoleMemberAttributeDataBo> attrBos = Collections.emptyList();
        attrBos = KimAttributeDataBo.createFrom(RoleMemberAttributeDataBo.class, roleMember.getAttributes(), kimTypeId);
        RoleMemberBo bo = RoleMemberBo.from(roleMember);
        bo.setAttributeDetails(attrBos);
        return RoleMemberBo.to(this.getResponsibilityInternalService().saveRoleMember(bo));
    }

    public RoleMember updateRoleMember(@WebParam(name="roleMember") RoleMember roleMember) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(roleMember, "roleMember");
        RoleMemberBo roleMemberBo = null;
        if (StringUtils.isNotBlank((String)roleMember.getId())) {
            roleMemberBo = this.getRoleMemberBo(roleMember.getId());
        }
        if (StringUtils.isBlank((String)roleMember.getId()) || roleMemberBo == null) {
            throw new RiceIllegalStateException("the roleMember to update does not exists: " + roleMember);
        }
        roleMemberBo.setMemberId(roleMember.getMemberId());
        roleMemberBo.setTypeCode(roleMember.getType().getCode());
        roleMemberBo.setActiveFromDateValue(roleMember.getActiveFromDate() == null ? null : new Timestamp(roleMember.getActiveFromDate().getMillis()));
        roleMemberBo.setActiveToDateValue(roleMember.getActiveToDate() == null ? null : new Timestamp(roleMember.getActiveToDate().getMillis()));
        Iterator<RoleResponsibilityActionBo> actions = roleMemberBo.getRoleRspActions().iterator();
        ArrayList newActionList = new ArrayList(roleMember.getRoleRspActions());
        while (actions.hasNext()) {
            RoleResponsibilityActionBo action = actions.next();
            boolean matched = false;
            Iterator newActions = newActionList.iterator();
            while (newActions.hasNext()) {
                RoleResponsibilityAction newAction = (RoleResponsibilityAction)newActions.next();
                if (!newAction.getId().equals(action.getId())) continue;
                matched = true;
                action.setActionPolicyCode(newAction.getActionPolicyCode());
                action.setActionTypeCode(newAction.getActionTypeCode());
                action.setPriorityNumber(newAction.getPriorityNumber());
                action.setForceAction(newAction.isForceAction());
                newActions.remove();
                break;
            }
            if (matched) continue;
            actions.remove();
        }
        for (RoleResponsibilityAction rra : newActionList) {
            roleMemberBo.getRoleRspActions().add(RoleResponsibilityActionBo.from(rra));
        }
        String kimTypeId = this.getRoleBoLite(roleMember.getRoleId()).getKimTypeId();
        List<RoleMemberAttributeDataBo> newAttributeBos = KimAttributeDataBo.createFrom(RoleMemberAttributeDataBo.class, roleMember.getAttributes(), kimTypeId);
        Iterator<RoleMemberAttributeDataBo> attributes = roleMemberBo.getAttributeDetails().iterator();
        while (attributes.hasNext()) {
            RoleMemberAttributeDataBo attr = attributes.next();
            boolean matched = false;
            Iterator<RoleMemberAttributeDataBo> newAttributes = newAttributeBos.iterator();
            while (newAttributes.hasNext()) {
                RoleMemberAttributeDataBo newAttr = newAttributes.next();
                if (!newAttr.getKimTypeId().equals(attr.getKimTypeId()) || !newAttr.getKimAttributeId().equals(attr.getKimAttributeId())) continue;
                matched = true;
                attr.setAttributeValue(newAttr.getAttributeValue());
                newAttributes.remove();
                break;
            }
            if (matched) continue;
            attributes.remove();
        }
        roleMemberBo.getAttributeDetails().addAll(newAttributeBos);
        return RoleMemberBo.to(this.getResponsibilityInternalService().saveRoleMember(roleMemberBo));
    }

    public DelegateMember updateDelegateMember(@WebParam(name="delegateMember") DelegateMember delegateMember) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(delegateMember, "delegateMember");
        String delegationId = delegateMember.getDelegationId();
        this.incomingParamCheck(delegationId, "delegationId");
        DelegateTypeBo delegate = this.getKimDelegationImpl(delegationId);
        DelegateMemberBo delegateMemberBo = null;
        if (StringUtils.isNotEmpty((String)delegateMember.getDelegationMemberId())) {
            delegateMemberBo = this.getDelegateMemberBo(delegateMember.getDelegationMemberId());
        }
        if (delegateMemberBo == null) {
            throw new RiceIllegalStateException("the delegate does not exist: " + delegationId);
        }
        delegateMemberBo.setActiveFromDateValue(delegateMember.getActiveFromDate() == null ? null : new Timestamp(delegateMember.getActiveFromDate().getMillis()));
        delegateMemberBo.setActiveToDateValue(delegateMember.getActiveToDate() == null ? null : new Timestamp(delegateMember.getActiveToDate().getMillis()));
        delegateMemberBo.setMemberId(delegateMember.getMemberId());
        delegateMemberBo.setRoleMemberId(delegateMember.getRoleMemberId());
        delegateMemberBo.setTypeCode(delegateMember.getType().getCode());
        String kimTypeId = delegate.getKimTypeId();
        List<DelegateMemberAttributeDataBo> newAttributeBos = KimAttributeDataBo.createFrom(DelegateMemberAttributeDataBo.class, delegateMember.getAttributes(), kimTypeId);
        Iterator<DelegateMemberAttributeDataBo> attributes = delegateMemberBo.getAttributeDetails().iterator();
        while (attributes.hasNext()) {
            DelegateMemberAttributeDataBo attr = attributes.next();
            boolean matched = false;
            Iterator<DelegateMemberAttributeDataBo> newAttributes = newAttributeBos.iterator();
            while (newAttributes.hasNext()) {
                DelegateMemberAttributeDataBo newAttr = newAttributes.next();
                if (!newAttr.getKimTypeId().equals(attr.getKimTypeId()) || !newAttr.getKimAttributeId().equals(attr.getKimAttributeId())) continue;
                matched = true;
                attr.setAttributeValue(newAttr.getAttributeValue());
                newAttributes.remove();
                break;
            }
            if (matched) continue;
            attributes.remove();
        }
        delegateMemberBo.getAttributeDetails().addAll(newAttributeBos);
        return DelegateMemberBo.to(this.getResponsibilityInternalService().saveDelegateMember(delegateMemberBo));
    }

    public DelegateMember createDelegateMember(@WebParam(name="delegateMember") DelegateMember delegateMember) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(delegateMember, "delegateMember");
        if (delegateMember.getDelegationMemberId() != null) {
            throw new RiceIllegalStateException("the delegate member already exists: " + delegateMember.getDelegationMemberId());
        }
        String delegationId = delegateMember.getDelegationId();
        this.incomingParamCheck(delegationId, "delegationId");
        DelegateTypeBo delegate = this.getKimDelegationImpl(delegationId);
        if (delegate == null) {
            throw new RiceIllegalStateException("the delegate does not exist: " + delegationId);
        }
        String memberId = delegateMember.getMemberId();
        this.incomingParamCheck(memberId, "memberId");
        Principal kPrincipal = KimApiServiceLocator.getIdentityService().getPrincipal(memberId);
        if (kPrincipal == null) {
            throw new RiceIllegalStateException("the user does not exist: " + memberId);
        }
        String kimTypeId = this.getRoleBoLite(delegate.getRoleId()).getKimTypeId();
        List<DelegateMemberAttributeDataBo> attrBos = Collections.emptyList();
        attrBos = KimAttributeDataBo.createFrom(DelegateMemberAttributeDataBo.class, delegateMember.getAttributes(), kimTypeId);
        DelegateMemberBo bo = DelegateMemberBo.from(delegateMember);
        bo.setAttributeDetails(attrBos);
        return DelegateMemberBo.to(this.getResponsibilityInternalService().saveDelegateMember(bo));
    }

    public void removeDelegateMembers(@WebParam(name="delegateMembers") List<DelegateMember> delegateMembers) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(delegateMembers, "delegateMembers");
        for (DelegateMember delegateMember : delegateMembers) {
            DelegateMember.Builder delegateMemberInfo = DelegateMember.Builder.create();
            delegateMemberInfo.setDelegationMemberId(delegateMember.getDelegationMemberId());
            delegateMemberInfo.setAttributes(delegateMember.getAttributes());
            delegateMemberInfo.setDelegationId(delegateMember.getDelegationId());
            delegateMemberInfo.setMemberId(delegateMember.getMemberId());
            delegateMemberInfo.setRoleMemberId(delegateMember.getRoleMemberId());
            delegateMemberInfo.setType(delegateMember.getType());
            delegateMemberInfo.setActiveFromDate(delegateMember.getActiveFromDate());
            delegateMemberInfo.setActiveToDate(DateTime.now());
            this.updateDelegateMember(delegateMemberInfo.build());
        }
    }

    public RoleResponsibilityAction createRoleResponsibilityAction(RoleResponsibilityAction roleResponsibilityAction) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(roleResponsibilityAction, "roleResponsibilityAction");
        if (StringUtils.isNotBlank((String)roleResponsibilityAction.getId()) && this.getRoleResponsibilityActionBo(roleResponsibilityAction.getId()) != null) {
            throw new RiceIllegalStateException("the roleResponsibilityAction to create already exists: " + roleResponsibilityAction);
        }
        RoleResponsibilityActionBo bo = RoleResponsibilityActionBo.from(roleResponsibilityAction);
        return RoleResponsibilityActionBo.to((RoleResponsibilityActionBo)((Object)this.getDataObjectService().save((Object)bo, new PersistenceOption[0])));
    }

    protected void updateActionRequestsForRoleResponsibilityActionChange(RoleResponsibilityActionBo bo) {
        RoleResponsibilityBo rr = bo.getRoleResponsibility();
        if (rr != null) {
            this.getResponsibilityInternalService().updateActionRequestsForResponsibilityChange(Collections.singleton(rr.getResponsibilityId()));
        }
    }

    public RoleResponsibilityAction updateRoleResponsibilityAction(RoleResponsibilityAction roleResponsibilityAction) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(roleResponsibilityAction, "roleResponsibilityAction");
        if (StringUtils.isBlank((String)roleResponsibilityAction.getId()) || this.getRoleResponsibilityActionBo(roleResponsibilityAction.getId()) == null) {
            throw new RiceIllegalStateException("the roleResponsibilityAction to create does not exist: " + roleResponsibilityAction);
        }
        RoleResponsibilityActionBo bo = RoleResponsibilityActionBo.from(roleResponsibilityAction);
        roleResponsibilityAction = RoleResponsibilityActionBo.to((RoleResponsibilityActionBo)((Object)this.getDataObjectService().save((Object)bo, new PersistenceOption[0])));
        this.updateActionRequestsForRoleResponsibilityActionChange(bo);
        return roleResponsibilityAction;
    }

    public void deleteRoleResponsibilityAction(String roleResponsibilityActionId) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(roleResponsibilityActionId, "roleResponsibilityActionId");
        RoleResponsibilityActionBo bo = this.getRoleResponsibilityActionBo(roleResponsibilityActionId);
        if (StringUtils.isBlank((String)roleResponsibilityActionId) || bo == null) {
            throw new RiceIllegalStateException("the roleResponsibilityAction to delete does not exist: " + roleResponsibilityActionId);
        }
        this.getDataObjectService().delete((Object)bo);
        this.updateActionRequestsForRoleResponsibilityActionChange(bo);
    }

    public DelegateType createDelegateType(DelegateType delegateType) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(delegateType, "delegateType");
        if (StringUtils.isNotBlank((String)delegateType.getDelegationId()) && this.getDelegateTypeByDelegationId(delegateType.getDelegationId()) != null) {
            throw new RiceIllegalStateException("the delegateType to create already exists: " + delegateType);
        }
        DelegateTypeBo bo = DelegateTypeBo.from(delegateType);
        return DelegateTypeBo.to((DelegateTypeBo)((Object)this.getDataObjectService().save((Object)bo, new PersistenceOption[0])));
    }

    public DelegateType updateDelegateType(DelegateType delegateType) throws RiceIllegalArgumentException, RiceIllegalStateException {
        this.incomingParamCheck(delegateType, "delegateType");
        if (StringUtils.isBlank((String)delegateType.getDelegationId()) || this.getDelegateTypeByDelegationId(delegateType.getDelegationId()) == null) {
            throw new RiceIllegalStateException("the delegateType to update does not exist: " + delegateType);
        }
        DelegateTypeBo bo = DelegateTypeBo.from(delegateType);
        return DelegateTypeBo.to((DelegateTypeBo)((Object)this.getDataObjectService().save((Object)bo, new PersistenceOption[0])));
    }

    private void removeRoleMembers(List<RoleMemberBo> members) {
        if (CollectionUtils.isNotEmpty(members)) {
            for (RoleMemberBo rm : members) {
                this.getResponsibilityInternalService().removeRoleMember(rm);
            }
        }
    }

    private List<RoleMemberBo> getRoleMembersByDefaultStrategy(String roleId, String memberId, String memberTypeCode, Map<String, String> qualifier) {
        ArrayList<RoleMemberBo> rms = new ArrayList<RoleMemberBo>();
        List<RoleMemberBo> roleMem = this.getRoleMembershipsForMemberId(memberTypeCode, memberId, qualifier);
        for (RoleMemberBo rm : roleMem) {
            if (!rm.getRoleId().equals(roleId)) continue;
            rms.add(rm);
        }
        return rms;
    }

    public void removePrincipalFromRole(String principalId, String namespaceCode, String roleName, Map<String, String> qualifier) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId is null");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode is null");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName is null");
        }
        if (qualifier == null) {
            throw new RiceIllegalArgumentException("qualifier is null");
        }
        RoleBoLite role = this.getRoleBoLiteByName(namespaceCode, roleName);
        List<RoleMemberBo> rms = this.getRoleMembersByExactQualifierMatch(role, principalId, memberTypeToRoleDaoActionMap.get(MemberType.PRINCIPAL.getCode()), qualifier);
        if (CollectionUtils.isEmpty(rms)) {
            String kimTypeId = role.getKimTypeId();
            HashMap<String, String> attributeQualifierMap = new HashMap<String, String>();
            for (String qualifierKey : qualifier.keySet()) {
                attributeQualifierMap.put(this.getKimAttributeId(kimTypeId, qualifierKey), qualifier.get(qualifierKey));
            }
            rms = this.getRoleMembersByDefaultStrategy(role.getId(), principalId, MemberType.PRINCIPAL.getCode(), attributeQualifierMap);
        }
        this.removeRoleMembers(rms);
    }

    public void removeGroupFromRole(String groupId, String namespaceCode, String roleName, Map<String, String> qualifier) throws RiceIllegalArgumentException {
        if (StringUtils.isBlank((String)groupId)) {
            throw new RiceIllegalArgumentException("groupId is null");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode is null");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName is null");
        }
        if (qualifier == null) {
            throw new RiceIllegalArgumentException("qualifier is null");
        }
        RoleBoLite roleBo = this.getRoleBoLiteByName(namespaceCode, roleName);
        List<RoleMemberBo> rms = this.getRoleMembersByExactQualifierMatch(roleBo, groupId, memberTypeToRoleDaoActionMap.get(MemberType.GROUP.getCode()), qualifier);
        if (CollectionUtils.isEmpty(rms)) {
            rms = this.getRoleMembersByDefaultStrategy(roleBo.getId(), groupId, MemberType.GROUP.getCode(), qualifier);
        }
        this.removeRoleMembers(rms);
    }

    public void removeRoleFromRole(String roleId, String namespaceCode, String roleName, Map<String, String> qualifier) throws RiceIllegalArgumentException {
        this.incomingParamCheck(roleId, "roleId");
        this.incomingParamCheck(namespaceCode, "namespaceCode");
        this.incomingParamCheck(roleName, "roleName");
        this.incomingParamCheck(qualifier, "qualifier");
        RoleBoLite role = this.getRoleBoLiteByName(namespaceCode, roleName);
        List<RoleMemberBo> rms = this.getRoleMembersByExactQualifierMatch(role, roleId, memberTypeToRoleDaoActionMap.get(MemberType.ROLE.getCode()), qualifier);
        if (CollectionUtils.isEmpty(rms)) {
            rms = this.getRoleMembersByDefaultStrategy(role.getId(), roleId, MemberType.ROLE.getCode(), qualifier);
        }
        this.removeRoleMembers(rms);
    }

    public void assignPermissionToRole(String permissionId, String roleId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(permissionId, "permissionId");
        this.incomingParamCheck(roleId, "roleId");
        RolePermissionBo newRolePermission = new RolePermissionBo();
        Long nextSeq = new Long(MaxValueIncrementerFactory.getIncrementer((DataSource)this.getDataSource(), (String)"KRIM_ROLE_PERM_ID_S").nextLongValue());
        newRolePermission.setId(nextSeq.toString());
        newRolePermission.setRoleId(roleId);
        newRolePermission.setPermissionId(permissionId);
        newRolePermission.setActive(true);
        this.getDataObjectService().save((Object)newRolePermission, new PersistenceOption[0]);
    }

    public void revokePermissionFromRole(String permissionId, String roleId) throws RiceIllegalArgumentException {
        this.incomingParamCheck(permissionId, "permissionId");
        this.incomingParamCheck(roleId, "roleId");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("roleId", roleId);
        params.put("permissionId", permissionId);
        params.put("active", Boolean.TRUE);
        QueryResults rolePermissionBos = this.getDataObjectService().findMatching(RolePermissionBo.class, QueryByCriteria.Builder.andAttributes(params).build());
        ArrayList<RolePermissionBo> rolePermsToSave = new ArrayList<RolePermissionBo>();
        for (RolePermissionBo rolePerm : rolePermissionBos.getResults()) {
            rolePerm.setActive(false);
            rolePermsToSave.add(rolePerm);
        }
        this.getDataObjectService().save(rolePermsToSave, new PersistenceOption[0]);
    }

    protected void addMemberAttributeData(RoleMemberBo roleMember, Map<String, String> qualifier, String kimTypeId) {
        ArrayList<RoleMemberAttributeDataBo> attributes = new ArrayList<RoleMemberAttributeDataBo>();
        for (Map.Entry<String, String> entry : qualifier.entrySet()) {
            RoleMemberAttributeDataBo origRoleMemberAttribute;
            RoleMemberAttributeDataBo roleMemberAttrBo = new RoleMemberAttributeDataBo();
            roleMemberAttrBo.setAttributeValue(entry.getValue());
            roleMemberAttrBo.setKimTypeId(kimTypeId);
            roleMemberAttrBo.setAssignedToId(roleMember.getId());
            roleMemberAttrBo.setKimAttributeId(this.getKimAttributeId(kimTypeId, entry.getKey()));
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("id", roleMemberAttrBo.getKimAttributeId());
            criteria.put("assignedToId", roleMember.getId());
            QueryResults origRoleMemberAttributes = this.getDataObjectService().findMatching(RoleMemberAttributeDataBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
            RoleMemberAttributeDataBo roleMemberAttributeDataBo = origRoleMemberAttribute = !origRoleMemberAttributes.getResults().isEmpty() ? (RoleMemberAttributeDataBo)((Object)origRoleMemberAttributes.getResults().get(0)) : null;
            if (origRoleMemberAttribute != null) {
                roleMemberAttrBo.setId(origRoleMemberAttribute.getId());
                roleMemberAttrBo.setVersionNumber(origRoleMemberAttribute.getVersionNumber());
            }
            attributes.add(roleMemberAttrBo);
        }
        roleMember.setAttributeDetails(attributes);
    }

    protected void addDelegationMemberAttributeData(DelegateMemberBo delegationMember, Map<String, String> qualifier, String kimTypeId) {
        ArrayList<DelegateMemberAttributeDataBo> attributes = new ArrayList<DelegateMemberAttributeDataBo>();
        for (Map.Entry<String, String> entry : qualifier.entrySet()) {
            DelegateMemberAttributeDataBo origDelegationMemberAttribute;
            DelegateMemberAttributeDataBo delegateMemberAttrBo = new DelegateMemberAttributeDataBo();
            delegateMemberAttrBo.setAttributeValue(entry.getValue());
            delegateMemberAttrBo.setKimTypeId(kimTypeId);
            delegateMemberAttrBo.setAssignedToId(delegationMember.getDelegationMemberId());
            delegateMemberAttrBo.setKimAttributeId(this.getKimAttributeId(kimTypeId, entry.getKey()));
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("id", delegateMemberAttrBo.getKimAttributeId());
            criteria.put("delegationMemberId", delegationMember.getDelegationMemberId());
            QueryResults origDelegationMemberAttributes = this.getDataObjectService().findMatching(DelegateMemberAttributeDataBo.class, QueryByCriteria.Builder.andAttributes(criteria).build());
            DelegateMemberAttributeDataBo delegateMemberAttributeDataBo = origDelegationMemberAttribute = !origDelegationMemberAttributes.getResults().isEmpty() ? (DelegateMemberAttributeDataBo)((Object)origDelegationMemberAttributes.getResults().get(0)) : null;
            if (origDelegationMemberAttribute != null) {
                delegateMemberAttrBo.setId(origDelegationMemberAttribute.getId());
                delegateMemberAttrBo.setVersionNumber(origDelegationMemberAttribute.getVersionNumber());
            }
            attributes.add(delegateMemberAttrBo);
        }
        delegationMember.setAttributeDetails(attributes);
    }

    private void deleteNullMemberAttributeData(List<RoleMemberAttributeDataBo> attributes) {
        ArrayList<RoleMemberAttributeDataBo> attributesToDelete = new ArrayList<RoleMemberAttributeDataBo>();
        for (RoleMemberAttributeDataBo attribute : attributes) {
            if (attribute.getAttributeValue() != null) continue;
            attributesToDelete.add(attribute);
        }
        this.getDataObjectService().delete(attributesToDelete);
    }

    private void deleteNullDelegationMemberAttributeData(List<DelegateMemberAttributeDataBo> attributes) {
        ArrayList<DelegateMemberAttributeDataBo> attributesToDelete = new ArrayList<DelegateMemberAttributeDataBo>();
        for (DelegateMemberAttributeDataBo attribute : attributes) {
            if (attribute.getAttributeValue() != null) continue;
            attributesToDelete.add(attribute);
        }
        this.getDataObjectService().delete(attributesToDelete);
    }

    protected void logPrincipalHasRoleCheck(String principalId, List<String> roleIds, Map<String, String> roleQualifiers) {
        Principal principal;
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("Has Role     : ").append(roleIds).append('\n');
        if (roleIds != null) {
            for (String roleId : roleIds) {
                Role role = this.getRole(roleId);
                if (role == null) continue;
                sb.append("        Name : ").append(role.getNamespaceCode()).append('/').append(role.getName());
                sb.append(" (").append(roleId).append(')');
                sb.append('\n');
            }
        }
        sb.append("   Principal : ").append(principalId);
        if (principalId != null && (principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId)) != null) {
            sb.append(" (").append(principal.getPrincipalName()).append(')');
        }
        sb.append('\n');
        sb.append("     Details :\n");
        if (roleQualifiers != null) {
            sb.append(roleQualifiers);
        } else {
            sb.append("               [null]\n");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)sb.append(ExceptionUtils.getStackTrace((Throwable)new Throwable())));
        } else {
            LOG.debug((Object)sb.toString());
        }
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    protected RoleService getProxiedRoleService() {
        if (this.proxiedRoleService == null) {
            this.proxiedRoleService = KimApiServiceLocator.getRoleService();
        }
        return this.proxiedRoleService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager must not be null");
        }
        this.cacheManager = cacheManager;
    }

    protected DataSource getDataSource() {
        return KimImplServiceLocator.getDataSource();
    }

    protected VersionedService<RoleTypeService> getVersionedRoleTypeService(KimType typeInfo) {
        QName serviceName = KimTypeUtils.resolveKimTypeServiceName((String)typeInfo.getServiceName());
        if (serviceName != null) {
            String version = "2.0.0";
            RoleTypeService roleTypeService = null;
            try {
                KimTypeService service;
                ServiceBus serviceBus = KsbApiServiceLocator.getServiceBus();
                Endpoint endpoint = serviceBus.getEndpoint(serviceName);
                if (endpoint != null) {
                    version = endpoint.getServiceConfiguration().getServiceVersion();
                }
                roleTypeService = (service = (KimTypeService)GlobalResourceLoader.getService((QName)serviceName)) != null && service instanceof RoleTypeService ? (RoleTypeService)service : (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
            }
            catch (Exception ex) {
                roleTypeService = (RoleTypeService)KimImplServiceLocator.getService("kimNoMembersRoleTypeService");
            }
            return new VersionedService<RoleTypeService>(version, roleTypeService);
        }
        return null;
    }

    private Map<String, String> getNestedQualification(RoleBoLite memberRole, String namespaceCode, String roleName, String memberNamespaceCode, String memberName, Map<String, String> qualification, Map<String, String> memberQualification) {
        boolean versionOk;
        VersionedService<RoleTypeService> versionedRoleTypeService = this.getVersionedRoleTypeService(KimTypeBo.to(memberRole.getKimRoleType()));
        if (versionedRoleTypeService == null) {
            return qualification;
        }
        boolean bl = versionOk = VersionHelper.compareVersion((String)versionedRoleTypeService.getVersion(), (String)"2.3.4") != -1;
        if (versionOk) {
            return versionedRoleTypeService.getService().convertQualificationForMemberRolesAndMemberAttributes(namespaceCode, roleName, memberNamespaceCode, memberName, qualification, memberQualification);
        }
        return versionedRoleTypeService.getService().convertQualificationForMemberRoles(namespaceCode, roleName, memberNamespaceCode, memberName, qualification);
    }

    private static class VersionedService<T> {
        String version;
        T service;

        VersionedService(String version, T service) {
            this.version = version;
            this.service = service;
        }

        T getService() {
            return this.service;
        }

        String getVersion() {
            return this.version;
        }
    }

    private final class Context {
        private String principalId;
        private List<String> principalGroupIds;
        private Map<String, RoleTypeService> roleTypeServiceCache;
        private Map<String, Boolean> isDerivedRoleTypeCache;

        Context(String principalId) {
            this.principalId = principalId;
            this.roleTypeServiceCache = new HashMap<String, RoleTypeService>();
            this.isDerivedRoleTypeCache = new HashMap<String, Boolean>();
        }

        String getPrincipalId() {
            return this.principalId;
        }

        List<String> getPrincipalGroupIds() {
            if (this.principalGroupIds == null) {
                this.principalGroupIds = RoleServiceImpl.this.getGroupService().getGroupIdsByPrincipalId(this.principalId);
            }
            return this.principalGroupIds;
        }

        RoleTypeService getRoleTypeService(String kimTypeId) {
            KimType roleType;
            if (this.roleTypeServiceCache.containsKey(kimTypeId)) {
                return this.roleTypeServiceCache.get(kimTypeId);
            }
            RoleTypeService roleTypeService = null;
            if (kimTypeId != null && (roleType = KimApiServiceLocator.getKimTypeInfoService().getKimType(kimTypeId)) != null && StringUtils.isNotBlank((String)roleType.getServiceName())) {
                roleTypeService = RoleServiceImpl.this.getRoleTypeServiceByName(roleType.getServiceName());
            }
            if (roleTypeService == null) {
                roleTypeService = KimImplServiceLocator.getDefaultRoleTypeService();
            }
            this.roleTypeServiceCache.put(kimTypeId, roleTypeService);
            return roleTypeService;
        }

        boolean isDerivedRoleType(String kimTypeId) {
            Boolean isDerived = this.isDerivedRoleTypeCache.get(kimTypeId);
            if (isDerived == null) {
                isDerived = RoleServiceImpl.this.isDerivedRoleType(this.getRoleTypeService(kimTypeId));
                this.isDerivedRoleTypeCache.put(kimTypeId, isDerived);
            }
            return isDerived;
        }
    }
}

