/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.travel.dataobject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.DataObjectBase;
import org.kuali.rice.krad.data.provider.annotation.Description;
import org.kuali.rice.krad.data.provider.annotation.ForceUppercase;
import org.kuali.rice.krad.data.provider.annotation.InheritProperties;
import org.kuali.rice.krad.data.provider.annotation.InheritProperty;
import org.kuali.rice.krad.data.provider.annotation.KeyValuesFinderClass;
import org.kuali.rice.krad.data.provider.annotation.Label;
import org.kuali.rice.krad.data.provider.annotation.Relationship;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViewType;
import org.kuali.rice.krad.data.provider.annotation.UifAutoCreateViews;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHint;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHintType;
import org.kuali.rice.krad.data.provider.annotation.UifDisplayHints;
import org.kuali.rice.krad.data.provider.annotation.UifValidCharactersConstraintBeanName;
import org.kuali.rice.krad.demo.travel.dataobject.TravelAccountType;
import org.kuali.rice.krad.demo.travel.dataobject.TravelSubAccount;
import org.kuali.rice.krad.demo.travel.options.AccountTypeKeyValues;

@Entity
@Table(name="TRV_ACCT")
@UifAutoCreateViews(value={UifAutoCreateViewType.INQUIRY, UifAutoCreateViewType.LOOKUP})
public class TravelAccount
extends DataObjectBase
implements Serializable {
    private static final long serialVersionUID = -7739303391609093875L;
    @Id
    @Column(name="ACCT_NUM", length=10)
    @Label(value="Travel Account Number")
    @Description(value="Unique identifier for account")
    @UifValidCharactersConstraintBeanName(value="AlphaNumericPatternConstraint")
    private String number;
    @Column(name="ACCT_NAME", length=40)
    @Label(value="Travel Account Name")
    @ForceUppercase
    private String name;
    @Column(name="ACCT_TYPE", length=3)
    @Label(value="Travel Account Type Code")
    @Description(value="Type code grouping for account")
    @KeyValuesFinderClass(value=AccountTypeKeyValues.class)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.RADIO), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_RESULT), @UifDisplayHint(value=UifDisplayHintType.NO_INQUIRY)})
    protected String accountTypeCode;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @PrimaryKeyJoinColumn(name="ACCT_TYPE", referencedColumnName="ACCT_TYPE")
    @InheritProperty(name="codeAndDescription", displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))
    private TravelAccountType accountType;
    @Column(name="SUBSIDIZED_PCT", length=5, precision=2)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)})
    private KualiPercent subsidizedPercent;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATE_DT")
    @Label(value="Date Created")
    private Date createDate;
    @Column(name="ACCT_FO_ID", length=40)
    @Size(max=40)
    @UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.HIDDEN), @UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA), @UifDisplayHint(value=UifDisplayHintType.SECTION, id="fo", label="Fiscal Officer User ID")})
    private String foId;
    @Relationship(foreignKeyFields={"foId"})
    @Transient
    @InheritProperties(value={@InheritProperty(name="principalName", label=@Label(value="Fiscal Officer")), @InheritProperty(name="name", label=@Label(value="Fiscal Officer Name"), displayHints=@UifDisplayHints(value={@UifDisplayHint(value=UifDisplayHintType.NO_LOOKUP_CRITERIA)}))})
    private Person fiscalOfficer;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="account")
    protected List<TravelSubAccount> subAccounts;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Person getFiscalOfficer() {
        if (this.fiscalOfficer == null || !StringUtils.equals((String)this.fiscalOfficer.getPrincipalId(), (String)this.getFoId())) {
            this.fiscalOfficer = KimApiServiceLocator.getPersonService().getPerson(this.getFoId());
            if (this.fiscalOfficer == null) {
                try {
                    this.fiscalOfficer = (Person)KimApiServiceLocator.getPersonService().getPersonImplementationClass().newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.fiscalOfficer;
    }

    public void setFiscalOfficer(Person fiscalOfficer) {
        this.fiscalOfficer = fiscalOfficer;
    }

    public String getFoId() {
        return this.foId;
    }

    public void setFoId(String foId) {
        this.foId = foId;
    }

    public KualiPercent getSubsidizedPercent() {
        return this.subsidizedPercent;
    }

    public void setSubsidizedPercent(KualiPercent subsidizedPercent) {
        this.subsidizedPercent = subsidizedPercent;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public TravelAccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(TravelAccountType accountType) {
        this.accountType = accountType;
    }

    public String getAccountTypeCode() {
        return this.accountTypeCode;
    }

    public void setAccountTypeCode(String accountTypeCode) {
        this.accountTypeCode = accountTypeCode;
    }

    public List<TravelSubAccount> getSubAccounts() {
        if (this.subAccounts == null) {
            this.subAccounts = new ArrayList<TravelSubAccount>();
        }
        return this.subAccounts;
    }

    public void setSubAccounts(List<TravelSubAccount> subAccounts) {
        this.subAccounts = subAccounts;
    }
}

