/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.demo.uif.controller;

import java.beans.PropertyEditor;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kuali.rice.krad.demo.uif.form.KradSampleAppForm;
import org.kuali.rice.krad.demo.uif.form.UITestObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.uif.view.ViewTheme;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.FileControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/kradsampleapp"})
public class KradSampleAppController
extends UifControllerBase {
    protected KradSampleAppForm createInitialForm() {
        return new KradSampleAppForm();
    }

    @RequestMapping(method={RequestMethod.GET}, params={"methodToCall=changeTheme"})
    public ModelAndView changeTheme(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        this.changeTheme(form);
        return this.getModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=validateView"})
    public ModelAndView validateView(@ModelAttribute(value="KualiForm") UifFormBase uiTestForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        KRADServiceLocatorWeb.getViewValidationService().validateView((ViewModel)uiTestForm);
        return this.getModelAndView(uiTestForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addGrowl"})
    public ModelAndView addGrowl(@ModelAttribute(value="KualiForm") UifFormBase uiTestForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String extraInfo = request.getParameter("extraInfo");
        if (extraInfo == null) {
            extraInfo = "none";
        }
        GlobalVariables.getMessageMap().addGrowlMessage("Growl Message", "demo.fakeGrowl", new String[]{extraInfo});
        return this.getModelAndView(uiTestForm);
    }

    private void changeTheme(UifFormBase form) {
        ViewTheme newTheme;
        String theme = ((KradSampleAppForm)form).getThemeName();
        if (theme != null && (newTheme = (ViewTheme)KRADServiceLocatorWeb.getDataDictionaryService().getDictionaryBean(theme)) != null) {
            form.getView().setTheme(newTheme);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=makeReadOnly"})
    public ModelAndView makeReadOnly(@ModelAttribute(value="KualiForm") UifFormBase uifForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        uifForm.getView().setReadOnly(Boolean.valueOf(true));
        return this.getModelAndView(uifForm);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=addStandardSectionsErrors"})
    public ModelAndView addStandardSectionsErrors(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        GlobalVariables.getMessageMap().putError("Demo-ValidationMessages-Section1", "errorSectionTest", new String[0]);
        GlobalVariables.getMessageMap().putError("Demo-ValidationMessages-Section2", "errorSectionTest", new String[0]);
        Set inputFieldIds = form.getViewPostMetadata().getInputFieldIds();
        for (String id : inputFieldIds) {
            if (form.getViewPostMetadata().getComponentPostData(id, "path") == null) continue;
            String key = (String)form.getViewPostMetadata().getComponentPostData(id, "path");
            GlobalVariables.getMessageMap().putError(key, "error1Test", new String[0]);
        }
        return this.getModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=customEditLine"})
    public ModelAndView customEditLine(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        KradSampleAppForm kradSampleAppForm = (KradSampleAppForm)form;
        List<UITestObject> testObjects = kradSampleAppForm.getCollection6();
        int index = 1;
        for (UITestObject testObject : testObjects) {
            testObject.setField1("Custom Edit Line " + Integer.toString(index));
            ++index;
        }
        return this.getModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=refreshProgGroup"})
    public ModelAndView refreshProgGroup(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return this.getModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=refreshWithServerMessages"})
    public ModelAndView refreshWithServerMessages(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        GlobalVariables.getMessageMap().putError("inputField4", "serverTestError", new String[0]);
        GlobalVariables.getMessageMap().putWarning("inputField4", "serverTestWarning", new String[0]);
        GlobalVariables.getMessageMap().putInfo("inputField4", "serverTestInfo", new String[0]);
        return this.getModelAndView(form);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=customRefresh"})
    public ModelAndView customRefresh(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        GlobalVariables.getMessageMap().addGrowlMessage("Test", "serverTestInfo", new String[0]);
        return this.getModelAndView(form);
    }

    @Autowired
    @Qualifier(value="demoFileControllerService")
    public void setFileControllerService(FileControllerService fileControllerService) {
        super.setFileControllerService(fileControllerService);
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) throws Exception {
        binder.registerCustomEditor(List.class, "names", (PropertyEditor)((Object)new UITestObjectEditor()));
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=submitMultiSelect"})
    public ModelAndView submitMultiSelect(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String obj = request.getParameter("names");
        return this.getModelAndView(form);
    }

    protected class UITestObjectEditor
    extends CustomCollectionEditor {
        public UITestObjectEditor() {
            super(List.class);
        }

        protected Object convertElement(Object element) {
            KradSampleAppForm form = new KradSampleAppForm();
            for (UITestObject to : form.getNames()) {
                if (!to.getInputField1().equals(element)) continue;
                return to;
            }
            return null;
        }

        public String getAsText() {
            Object obj = this.getValue();
            if (obj == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            List l = (List)obj;
            for (UITestObject to : l) {
                buf.append(to.getInputField1().charAt(0)).append(",");
            }
            if (buf.toString().length() > 0) {
                return buf.toString().substring(0, buf.toString().length() - 1);
            }
            return buf.toString();
        }
    }
}

