/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.labs.fileUploads;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.impex.xml.CompositeXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.FileXmlDocCollection;
import org.kuali.rice.core.api.impex.xml.XmlDoc;
import org.kuali.rice.core.api.impex.xml.XmlDocCollection;
import org.kuali.rice.core.api.impex.xml.ZipXmlDocCollection;
import org.kuali.rice.krad.labs.fileUploads.XmlIngesterForm;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ingester"})
public class XmlIngesterController
extends UifControllerBase {
    protected XmlIngesterForm createInitialForm() {
        return new XmlIngesterForm();
    }

    @RequestMapping(params={"methodToCall=start"})
    public ModelAndView start(UifFormBase form) {
        XmlIngesterForm ingesterForm = (XmlIngesterForm)form;
        return super.start((UifFormBase)ingesterForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=upload"})
    public ModelAndView upload(@ModelAttribute(value="KualiForm") XmlIngesterForm ingesterForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<File> tempFiles = new ArrayList<File>();
        List<XmlDocCollection> collections = this.copyInputFiles(ingesterForm.getFiles(), tempFiles);
        try {
            if (collections.size() == 0) {
                String message = "No valid files to ingest";
                GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.no.valid.files", new String[0]);
            } else if (this.ingestFiles(collections) == 0) {
                GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.no.xmls", new String[0]);
            }
        }
        finally {
            if (tempFiles.size() > 0) {
                for (File tempFile : tempFiles) {
                    if (tempFile.delete()) continue;
                }
            }
        }
        return this.getModelAndView(ingesterForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<XmlDocCollection> copyInputFiles(List<MultipartFile> fileList, List<File> tempFiles) {
        ArrayList<XmlDocCollection> collections = new ArrayList<XmlDocCollection>();
        for (MultipartFile file : fileList) {
            if (file == null || StringUtils.isBlank((String)file.getOriginalFilename())) continue;
            FileOutputStream fos = null;
            File temp = null;
            try {
                temp = File.createTempFile("ingester", null);
                tempFiles.add(temp);
                fos = new FileOutputStream(temp);
                fos.write(file.getBytes());
            }
            catch (IOException ioe) {
                GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.copy.file.data", new String[]{file.getOriginalFilename(), ExceptionUtils.getFullStackTrace((Throwable)ioe)});
                continue;
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            if (file.getOriginalFilename().toLowerCase().endsWith(".zip")) {
                try {
                    collections.add((XmlDocCollection)new ZipXmlDocCollection(temp));
                }
                catch (IOException ioe) {
                    GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.load.file", new String[]{file.getOriginalFilename()});
                }
                continue;
            }
            if (file.getOriginalFilename().endsWith(".xml")) {
                collections.add((XmlDocCollection)new FileXmlDocCollection(temp, file.getOriginalFilename()));
                continue;
            }
            GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.extraneous.file", new String[]{file.getOriginalFilename()});
        }
        return collections;
    }

    protected int ingestFiles(List<XmlDocCollection> collections) {
        CompositeXmlDocCollection compositeCollection = new CompositeXmlDocCollection(collections);
        int totalProcessed = 0;
        ArrayList<CompositeXmlDocCollection> c = new ArrayList<CompositeXmlDocCollection>(1);
        c.add(compositeCollection);
        try {
            boolean txFailed;
            Collection failed = CoreApiServiceLocator.getXmlIngesterService().ingest(c, GlobalVariables.getUserSession().getPrincipalId());
            boolean bl = txFailed = failed.size() > 0;
            if (txFailed) {
                GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.failed", new String[0]);
            }
            this.collectIngestionMessages(collections, txFailed);
        }
        catch (Exception e) {
            GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.during.inject", new String[]{ExceptionUtils.getFullStackTrace((Throwable)e)});
        }
        return totalProcessed;
    }

    protected int collectIngestionMessages(List<XmlDocCollection> collections, boolean txFailed) {
        int totalProcessed = 0;
        for (XmlDocCollection collection1 : collections) {
            List docs = collection1.getXmlDocs();
            for (XmlDoc doc1 : docs) {
                if (doc1.isProcessed()) {
                    if (!txFailed) {
                        ++totalProcessed;
                        GlobalVariables.getMessageMap().putInfoForSectionId("XmlIngester", "info.ingester.success", new String[]{doc1.getName(), doc1.getProcessingMessage()});
                        continue;
                    }
                    GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.rolledback", new String[]{doc1.getName(), doc1.getProcessingMessage()});
                    continue;
                }
                GlobalVariables.getMessageMap().putErrorForSectionId("XmlIngester", "error.ingester.failed.xml", new String[]{doc1.getName(), doc1.getProcessingMessage()});
            }
        }
        return totalProcessed;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"methodToCall=close"})
    public ModelAndView close(@ModelAttribute(value="KualiForm") XmlIngesterForm ingesterForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }
}

