/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.CollectionGroupBase;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.SelectControlBase;
import org.kuali.rice.krad.uif.control.TextAreaControl;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.field.InputFieldBase;

public class CollectionGroupTest {
    private CollectionGroup group;

    @Before
    public void setup() {
        this.group = new CollectionGroupBase();
        ArrayList<Object> items = new ArrayList<Object>();
        InputFieldBase field = new InputFieldBase();
        field.setControl((Control)new SelectControlBase());
        items.add(field);
        items.add(new TextAreaControl());
        this.group.setItems(items);
    }

    @Test
    public void testPushCollectionGroupToReference() {
        this.group.pushCollectionGroupToReference();
        for (Component component : this.group.getItems()) {
            this.testForCollectionGroupInContext(component, this.group);
        }
        Control innerControl = ((InputField)this.group.getItems().get(0)).getControl();
        this.testForCollectionGroupInContext((Component)innerControl, this.group);
    }

    private void testForCollectionGroupInContext(Component component, CollectionGroup group) {
        Assert.assertTrue((String)"The component does not have the collection group key in the context", (boolean)component.getContext().containsKey("collectionGroup"));
        Assert.assertTrue((String)"The collection group found is not the parent group", (component.getContext().get("collectionGroup") == group ? 1 : 0) != 0);
    }
}

