/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;
import org.kuali.rice.krad.service.impl.RemoteModuleServiceBase;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public class MockModuleService
extends RemoteModuleServiceBase {
    private final List<? extends ExternalizableBusinessObject> instances;
    private final List<Class<?>> lookupable;
    private final List<Class<?>> inquirable;

    public MockModuleService(List<? extends ExternalizableBusinessObject> instances, List<Class<?>> lookupable, List<Class<?>> inquirable) {
        this.instances = instances;
        this.lookupable = lookupable;
        this.inquirable = inquirable;
    }

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        for (ExternalizableBusinessObject externalizableBusinessObject : this.instances) {
            boolean match = true;
            for (Map.Entry<String, Object> fieldValue : fieldValues.entrySet()) {
                Object matchValue = ObjectPropertyUtils.getPropertyValue((Object)externalizableBusinessObject, (String)fieldValue.getKey());
                if (!(matchValue == null ? fieldValue.getValue() != null : !matchValue.equals(fieldValue.getValue()))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return (T)((ExternalizableBusinessObject)businessObjectClass.cast(externalizableBusinessObject));
        }
        return null;
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        ArrayList<T> rv = new ArrayList<T>();
        for (ExternalizableBusinessObject externalizableBusinessObject : this.instances) {
            boolean match = true;
            for (Map.Entry<String, Object> fieldValue : fieldValues.entrySet()) {
                Object matchValue = ObjectPropertyUtils.getPropertyValue((Object)externalizableBusinessObject, (String)fieldValue.getKey());
                if (!(matchValue == null ? fieldValue.getValue() != null : !matchValue.equals(fieldValue.getValue()))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            rv.add(businessObjectClass.cast(externalizableBusinessObject));
        }
        return rv;
    }

    public boolean isExternalizableBusinessObjectLookupable(Class boClass) {
        return this.lookupable.contains(boClass);
    }

    public boolean isExternalizableBusinessObjectInquirable(Class boClass) {
        return this.inquirable.contains(boClass);
    }

    boolean isResponsible(Class<?> boClass) {
        if (this.isExternalizableBusinessObjectInquirable(boClass) || this.isExternalizableBusinessObjectLookupable(boClass)) {
            return true;
        }
        for (ExternalizableBusinessObject externalizableBusinessObject : this.instances) {
            if (!boClass.isInstance(externalizableBusinessObject)) continue;
            return true;
        }
        return false;
    }
}

