/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DictionaryBean;
import org.kuali.rice.krad.datadictionary.DictionaryBeanProcessorBase;
import org.kuali.rice.krad.messages.Message;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.field.ActionField;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ListFactoryBean;

public class MessageBeanProcessor
extends DictionaryBeanProcessorBase {
    private ConfigurableListableBeanFactory beanFactory;
    private DataDictionary dataDictionary;

    public MessageBeanProcessor(DataDictionary dataDictionary, ConfigurableListableBeanFactory beanFactory) {
        this.dataDictionary = dataDictionary;
        this.beanFactory = beanFactory;
    }

    @Override
    public void processRootBeanDefinition(String beanName, BeanDefinition beanDefinition) {
        this.processBeanMessages(beanName, beanDefinition, null);
    }

    @Override
    public void processNestedBeanDefinition(String beanName, BeanDefinition beanDefinition, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        this.processBeanMessages(beanName, beanDefinition, nestedBeanStack);
    }

    @Override
    public String processStringPropertyValue(String propertyName, String propertyValue, Stack<BeanDefinitionHolder> nestedBeanStack) {
        return this.processMessagePlaceholders(propertyValue, nestedBeanStack);
    }

    @Override
    public void processCollectionBeanDefinition(String beanName, BeanDefinition beanDefinition, String propertyName, Stack<BeanDefinitionHolder> nestedBeanStack) {
        this.processBeanMessages(beanName, beanDefinition, nestedBeanStack);
    }

    @Override
    public String processArrayStringPropertyValue(String propertyName, Object[] propertyValue, String elementValue, int elementIndex, Stack<BeanDefinitionHolder> nestedBeanStack) {
        return this.processMessagePlaceholders(elementValue, nestedBeanStack);
    }

    @Override
    public String processListStringPropertyValue(String propertyName, List<?> propertyValue, String elementValue, int elementIndex, Stack<BeanDefinitionHolder> nestedBeanStack) {
        return this.processMessagePlaceholders(elementValue, nestedBeanStack);
    }

    @Override
    public String processSetStringPropertyValue(String propertyName, Set<?> propertyValue, String elementValue, Stack<BeanDefinitionHolder> nestedBeanStack) {
        return this.processMessagePlaceholders(elementValue, nestedBeanStack);
    }

    @Override
    public String processMapStringPropertyValue(String propertyName, Map<?, ?> propertyValue, String elementValue, Object elementKey, Stack<BeanDefinitionHolder> nestedBeanStack) {
        return this.processMessagePlaceholders(elementValue, nestedBeanStack);
    }

    protected void processBeanMessages(String beanName, BeanDefinition beanDefinition, Stack<BeanDefinitionHolder> nestedBeanStack) {
        String extensionParentBeanName;
        String componentCode;
        Class<?> beanClass = this.getBeanClass(beanDefinition, this.beanFactory);
        if (beanClass == null || !DictionaryBean.class.isAssignableFrom(beanClass) && !ListFactoryBean.class.isAssignableFrom(beanClass)) {
            return;
        }
        String namespace = this.getNamespaceForBean(beanName, beanDefinition);
        if (StringUtils.isBlank((String)namespace)) {
            namespace = this.getNamespaceForBeanInStack(nestedBeanStack);
        }
        if (StringUtils.equals((String)(componentCode = this.getComponentForBean(beanName, beanDefinition)), (String)beanName) && this.beanFactory.containsBean(extensionParentBeanName = beanName + "-parentBean")) {
            return;
        }
        if (StringUtils.isNotBlank((String)namespace) && StringUtils.isNotBlank((String)componentCode)) {
            Collection<Message> beanMessages = this.getMessageService().getAllMessagesForComponent(namespace, componentCode);
            for (Message beanMessage : beanMessages) {
                this.applyMessageToBean(beanMessage, beanDefinition, beanClass);
            }
        }
    }

    protected void applyMessageToBean(Message message, BeanDefinition beanDefinition, Class<?> beanClass) {
        String key = message.getKey().trim();
        if (!key.startsWith("#")) {
            return;
        }
        key = StringUtils.stripStart((String)key, (String)"#");
        if (ListFactoryBean.class.isAssignableFrom(beanClass)) {
            MutablePropertyValues pvs = beanDefinition.getPropertyValues();
            PropertyValue propertyValue = (PropertyValue)pvs.getPropertyValueList().get(0);
            List listValue = (List)propertyValue.getValue();
            this.applyMessageToNestedListBean(message, listValue, key);
        } else if (StringUtils.contains((String)key, (String)".")) {
            this.applyMessageToNestedBean(message, beanDefinition, key);
        } else {
            this.applyMessageTextToPropertyValue(key, message.getText(), beanDefinition);
        }
    }

    protected void applyMessageToNestedBean(Message message, BeanDefinition beanDefinition, String propertyPath) {
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        String beanPath = StringUtils.substringBefore((String)propertyPath, (String)".");
        String nestedPropertyPath = StringUtils.substringAfter((String)propertyPath, (String)".");
        boolean foundNestedBean = false;
        while (StringUtils.isNotBlank((String)nestedPropertyPath)) {
            if (pvs.contains(beanPath)) {
                PropertyValue propertyValue = pvs.getPropertyValue(beanPath);
                BeanDefinition propertyBeanDefinition = this.getPropertyValueBeanDefinition(propertyValue);
                if (propertyBeanDefinition != null) {
                    this.applyMessageToNestedBean(message, propertyBeanDefinition, nestedPropertyPath);
                    foundNestedBean = true;
                    break;
                }
                if (propertyValue.getValue() instanceof List) {
                    this.applyMessageToNestedListBean(message, (List)propertyValue.getValue(), nestedPropertyPath);
                    foundNestedBean = true;
                    break;
                }
            }
            beanPath = beanPath + "." + StringUtils.substringBefore((String)nestedPropertyPath, (String)".");
            nestedPropertyPath = StringUtils.substringAfter((String)nestedPropertyPath, (String)".");
        }
        if (!foundNestedBean) {
            this.applyMessageTextToPropertyValue(propertyPath, message.getText(), beanDefinition);
        }
    }

    protected void applyMessageToNestedListBean(Message message, List<?> listPropertyValue, String propertyPath) {
        if (!StringUtils.contains((String)propertyPath, (String)".")) {
            throw new RiceRuntimeException("Key for nested list bean must contain the identifer value followed by the path.");
        }
        String listIdentifierPropertyValue = StringUtils.substringBefore((String)propertyPath, (String)".");
        String listBeanPropertyPath = StringUtils.substringAfter((String)propertyPath, (String)".");
        for (int i = 0; i < listPropertyValue.size(); ++i) {
            BeanDefinition beanDefinition;
            boolean isMatch;
            Object elem = listPropertyValue.get(i);
            if (!(elem instanceof BeanDefinition) && !(elem instanceof BeanDefinitionHolder) || !(isMatch = this.isBeanMessageMatch(listIdentifierPropertyValue, beanDefinition = elem instanceof BeanDefinition ? (BeanDefinition)elem : ((BeanDefinitionHolder)elem).getBeanDefinition()))) continue;
            if (StringUtils.contains((String)listBeanPropertyPath, (String)".")) {
                this.applyMessageToNestedBean(message, beanDefinition, listBeanPropertyPath);
                continue;
            }
            this.applyMessageTextToPropertyValue(listBeanPropertyPath, message.getText(), beanDefinition);
        }
    }

    protected boolean isBeanMessageMatch(String matchListIdentifierPropertyValue, BeanDefinition beanDefinition) {
        String listIdentifierPropertyValue;
        boolean isMatch = false;
        String listIdentifierPropertyName = null;
        Class<?> beanClass = this.getBeanClass(beanDefinition, this.beanFactory);
        if (DataBinding.class.isAssignableFrom(beanClass)) {
            listIdentifierPropertyName = "propertyName";
        } else if (Action.class.isAssignableFrom(beanClass) || ActionField.class.isAssignableFrom(beanClass)) {
            listIdentifierPropertyName = "methodToCall";
        } else if (KeyValue.class.isAssignableFrom(beanClass)) {
            listIdentifierPropertyName = "key";
        }
        if (StringUtils.isNotBlank((String)listIdentifierPropertyName) && (listIdentifierPropertyValue = this.findPropertyValueInBeanDefinition(beanDefinition, listIdentifierPropertyName)) != null) {
            isMatch = StringUtils.equals((String)listIdentifierPropertyValue, (String)matchListIdentifierPropertyValue);
        }
        return isMatch;
    }

    protected String findPropertyValueInBeanDefinition(BeanDefinition beanDefinition, String propertyName) {
        String beanPropertyValue = null;
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.contains(propertyName)) {
            PropertyValue propertyValue = pvs.getPropertyValue(propertyName);
            if (propertyValue.getValue() != null) {
                beanPropertyValue = propertyValue.getValue().toString();
            }
        } else if (StringUtils.isNotBlank((String)beanDefinition.getParentName())) {
            BeanDefinition parentBeanDefinition = this.beanFactory.getBeanDefinition(beanDefinition.getParentName());
            beanPropertyValue = this.findPropertyValueInBeanDefinition(parentBeanDefinition, propertyName);
        }
        return beanPropertyValue;
    }

    protected String processMessagePlaceholders(String propertyValue, Stack<BeanDefinitionHolder> nestedBeanStack) {
        String trimmedPropertyValue = StringUtils.stripStart((String)propertyValue, (String)" ");
        if (StringUtils.isBlank((String)trimmedPropertyValue)) {
            return propertyValue;
        }
        String newPropertyValue = propertyValue;
        if (trimmedPropertyValue.startsWith("@msg{") && StringUtils.contains((String)trimmedPropertyValue, (String)"}")) {
            String messageKeyStr = StringUtils.substringBetween((String)trimmedPropertyValue, (String)"@msg{", (String)"}");
            String messageKeyWithPlaceholder = "@msg{" + messageKeyStr + "}";
            String defaultPropertyValue = StringUtils.substringAfter((String)trimmedPropertyValue, (String)messageKeyWithPlaceholder);
            String messageText = this.getMessageTextForKey(messageKeyStr, nestedBeanStack);
            newPropertyValue = messageText != null ? (StringUtils.isNotBlank((String)defaultPropertyValue) ? this.getMergedMessageText(messageText, defaultPropertyValue) : messageText) : defaultPropertyValue;
        } else if (StringUtils.contains((String)trimmedPropertyValue, (String)"#msg(")) {
            String[] expressionMessageKeys;
            for (String expressionMessageKey : expressionMessageKeys = StringUtils.substringsBetween((String)newPropertyValue, (String)"#msg(", (String)")")) {
                String expressionMessageText = this.getMessageTextForKey(expressionMessageKey, nestedBeanStack);
                newPropertyValue = StringUtils.replace((String)newPropertyValue, (String)("#msg(" + expressionMessageKey + ")"), (String)expressionMessageText);
            }
        }
        return newPropertyValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getMessageTextForKey(String messageKeyStr, Stack<BeanDefinitionHolder> nestedBeanStack) {
        String namespace = null;
        String componentCode = null;
        String key = null;
        if (StringUtils.contains((String)messageKeyStr, (String)":")) {
            String[] messageParams = StringUtils.split((String)messageKeyStr, (String)":");
            if (messageParams.length == 3) {
                namespace = messageParams[0];
                componentCode = messageParams[1];
                key = messageParams[2];
            } else {
                if (messageParams.length != 2) throw new RiceRuntimeException("Message key '" + messageKeyStr + "' has an invalid format");
                componentCode = messageParams[0];
                key = messageParams[1];
            }
        } else {
            key = messageKeyStr;
        }
        if (StringUtils.isBlank(namespace)) {
            namespace = this.getNamespaceForBeanInStack(nestedBeanStack);
        }
        if (StringUtils.isBlank(componentCode)) {
            BeanDefinitionHolder definitionHolder;
            for (int i = nestedBeanStack.size() - 1; i >= 0 && !StringUtils.isNotBlank((String)(componentCode = this.getComponentForBean((definitionHolder = (BeanDefinitionHolder)nestedBeanStack.get(i)).getBeanName(), definitionHolder.getBeanDefinition()))); --i) {
            }
        }
        String messageText = null;
        if (!StringUtils.isNotBlank((String)namespace)) return messageText;
        if (!StringUtils.isNotBlank(componentCode)) return messageText;
        if (!StringUtils.isNotBlank((String)key)) return messageText;
        return this.getMessageService().getMessageText(namespace, componentCode, key);
    }

    protected void applyMessageTextToPropertyValue(String propertyName, String messageText, BeanDefinition beanDefinition) {
        PropertyValue propertyValue;
        String stringPropertyValue;
        String newPropertyValue = messageText;
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.contains(propertyName) && StringUtils.isNotBlank((String)(stringPropertyValue = this.getStringValue((propertyValue = pvs.getPropertyValue(propertyName)).getValue())))) {
            newPropertyValue = this.getMergedMessageText(messageText, stringPropertyValue);
        }
        this.applyPropertyValueToBean(propertyName, newPropertyValue, pvs);
    }

    protected String getMergedMessageText(String messageText, String propertyValue) {
        String mergedText = messageText;
        String[] expressions = StringUtils.substringsBetween((String)propertyValue, (String)"@{", (String)"}");
        if (expressions != null && expressions.length > 0) {
            Object[] messageParameters = new String[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                String expression = expressions[i];
                expression = "@{" + expression + "}";
                messageParameters[i] = expression;
            }
            messageText = messageText.replace("'", "''");
            try {
                mergedText = MessageFormat.format(messageText, messageParameters);
            }
            catch (IllegalArgumentException e) {
                throw new RiceRuntimeException("Unable to merge expressions with message text. Expression count is: " + expressions.length, (Throwable)e);
            }
        }
        return mergedText;
    }

    protected String getNamespaceForBeanInStack(Stack<BeanDefinitionHolder> nestedBeanStack) {
        String namespace = null;
        if (nestedBeanStack != null) {
            BeanDefinitionHolder definitionHolder;
            for (int i = nestedBeanStack.size() - 1; i >= 0 && !StringUtils.isNotBlank((String)(namespace = this.getNamespaceForBean((definitionHolder = (BeanDefinitionHolder)nestedBeanStack.get(i)).getBeanName(), definitionHolder.getBeanDefinition()))); --i) {
            }
        }
        return namespace;
    }

    protected String getNamespaceForBean(String beanName, BeanDefinition beanDefinition) {
        String namespace = null;
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.contains("namespaceCode")) {
            PropertyValue propertyValue = pvs.getPropertyValue("namespaceCode");
            namespace = this.getStringValue(propertyValue.getValue());
        } else if (StringUtils.isNotBlank((String)beanName) && !this.isGeneratedBeanName(beanName)) {
            namespace = this.dataDictionary.getNamespaceForBeanDefinition(beanName);
        }
        return namespace;
    }

    protected String getComponentForBean(String beanName, BeanDefinition beanDefinition) {
        String componentCode = null;
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.contains("componentCode")) {
            PropertyValue propertyValue = pvs.getPropertyValue("componentCode");
            componentCode = this.getStringValue(propertyValue.getValue());
        }
        if (componentCode == null && StringUtils.isNotBlank((String)beanName) && !this.isGeneratedBeanName(beanName)) {
            componentCode = beanName;
        }
        if (StringUtils.isNotBlank(componentCode)) {
            componentCode = StringUtils.removeEnd(componentCode, (String)"-parentBean");
        }
        return componentCode;
    }

    protected MessageService getMessageService() {
        return KRADServiceLocatorWeb.getMessageService();
    }
}

