/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validator;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.ResourceLoader;

public class ValidationController {
    protected static final String endl = System.getProperty("line.separator");
    protected boolean displayWarnings;
    protected boolean displayErrors;
    protected boolean displayXmlPages;
    protected boolean displayErrorMessages;
    protected boolean displayWarningMessages;

    public ValidationController(boolean displayErrors, boolean displayWarnings, boolean displayErrorMessages, boolean displayWarningMessages, boolean displayXmlPages) {
        this.displayErrors = displayErrors;
        this.displayWarnings = displayWarnings;
        this.displayErrorMessages = displayErrorMessages;
        this.displayWarningMessages = displayWarningMessages;
        this.displayXmlPages = displayXmlPages;
    }

    public ValidationController() {
        this.displayErrors = true;
        this.displayWarnings = true;
        this.displayErrorMessages = true;
        this.displayWarningMessages = true;
        this.displayXmlPages = true;
    }

    public boolean validate(String[] xmlFiles, ResourceLoader loader, DefaultListableBeanFactory beans, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, loader, beans, failOnWarning);
        return passed;
    }

    public boolean validate(String[] xmlFiles, ResourceLoader loader, DefaultListableBeanFactory beans, String outputFile, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, loader, beans, failOnWarning);
        this.writeToFile(outputFile, validator, passed);
        return passed;
    }

    public boolean validate(String[] xmlFiles, ResourceLoader loader, DefaultListableBeanFactory beans, PrintStream stream, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, loader, beans, failOnWarning);
        this.writeToStream(stream, validator, passed);
        return passed;
    }

    public boolean validate(String[] xmlFiles, ResourceLoader loader, DefaultListableBeanFactory beans, Log log, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, loader, beans, failOnWarning);
        this.writeToLog(log, validator, passed);
        return passed;
    }

    public boolean validate(String[] xmlFiles, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, failOnWarning);
        return passed;
    }

    public boolean validate(String[] xmlFiles, String outputFile, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, failOnWarning);
        this.writeToFile(outputFile, validator, passed);
        return passed;
    }

    public boolean validate(String[] xmlFiles, PrintStream stream, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, failOnWarning);
        this.writeToStream(stream, validator, passed);
        return passed;
    }

    public boolean validate(String[] xmlFiles, Log log, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(xmlFiles, failOnWarning);
        this.writeToLog(log, validator, passed);
        return passed;
    }

    public boolean validate(Component object, Log log, boolean failOnWarning) {
        Validator validator = new Validator();
        boolean passed = validator.validate(object, failOnWarning);
        this.writeToLog(log, validator, passed);
        return passed;
    }

    protected void writeToFile(String path, Validator validator, boolean passed) {
        try {
            BufferedWriter fout = new BufferedWriter(new FileWriter(path));
            fout.write("Validation Results" + endl);
            fout.write("Passed: " + passed + endl);
            if (this.displayErrors) {
                fout.write("Number of Errors: " + validator.getNumberOfErrors() + endl);
            }
            if (this.displayWarnings) {
                fout.write("Number of Warnings: " + validator.getNumberOfWarnings() + endl);
            }
            if (this.displayErrorMessages) {
                for (int i = 0; i < validator.getErrorReportSize(); ++i) {
                    if (this.displayWarningMessages) {
                        fout.write(endl);
                        fout.write(validator.getErrorReport(i).errorMessage());
                    } else if (validator.getErrorReport(i).getErrorStatus() == 1) {
                        fout.write(endl);
                        fout.write(validator.getErrorReport(i).errorMessage());
                    }
                    if (!this.displayXmlPages) continue;
                    fout.write(validator.getErrorReport(i).errorPageList());
                }
            }
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeToStream(PrintStream stream, Validator validator, boolean passed) {
        stream.println("Validation Results");
        stream.println("Passed: " + passed);
        if (this.displayErrors) {
            stream.println("Number of Errors: " + validator.getNumberOfErrors());
        }
        if (this.displayWarnings) {
            stream.println("Number of Warnings: " + validator.getNumberOfWarnings());
        }
        if (this.displayErrorMessages) {
            for (int i = 0; i < validator.getErrorReportSize(); ++i) {
                stream.println();
                if (this.displayWarningMessages) {
                    stream.println(validator.getErrorReport(i).errorMessage());
                } else if (validator.getErrorReport(i).getErrorStatus() == 1) {
                    stream.println(validator.getErrorReport(i).errorMessage());
                }
                if (!this.displayXmlPages) continue;
                stream.println(validator.getErrorReport(i).errorPageList());
            }
        }
    }

    protected void writeToLog(Log log, Validator validator, boolean passed) {
        log.info((Object)("Passed: " + passed));
        if (this.displayErrors) {
            log.info((Object)("Number of Errors: " + validator.getNumberOfErrors()));
        }
        if (this.displayWarnings) {
            log.info((Object)("Number of Warnings: " + validator.getNumberOfWarnings()));
        }
        if (this.displayErrorMessages) {
            for (int i = 0; i < validator.getErrorReportSize(); ++i) {
                if (validator.getErrorReport(i).getErrorStatus() == 1) {
                    if (this.displayXmlPages) {
                        log.error((Object)(validator.getErrorReport(i).errorMessage() + validator.getErrorReport(i).errorPageList()));
                        continue;
                    }
                    log.error((Object)validator.getErrorReport(i).errorMessage());
                    continue;
                }
                if (!this.displayWarningMessages) continue;
                if (this.displayXmlPages) {
                    log.warn((Object)(validator.getErrorReport(i).errorMessage() + validator.getErrorReport(i).errorPageList()));
                    continue;
                }
                log.warn((Object)validator.getErrorReport(i).errorMessage());
            }
        }
    }

    public void setDisplayWarnings(boolean display) {
        this.displayWarnings = display;
    }

    public void setDisplayErrors(boolean display) {
        this.displayErrors = display;
    }

    public void setDisplayXmlPages(boolean display) {
        this.displayXmlPages = display;
    }

    public void setDisplayErrorMessages(boolean display) {
        this.displayErrorMessages = display;
    }

    public void setDisplayWarningMessages(boolean display) {
        this.displayWarningMessages = display;
    }

    public boolean isDisplayWarnings() {
        return this.displayWarnings;
    }

    public boolean isDisplayErrors() {
        return this.displayErrors;
    }

    public boolean isDisplayXmlPages() {
        return this.displayXmlPages;
    }

    public boolean isDisplayErrorMessages() {
        return this.displayErrorMessages;
    }

    public boolean isDisplayWarningMessages() {
        return this.displayWarningMessages;
    }
}

