/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTags(value={@BeanTag(name="textAreaControl", parent="Uif-TextAreaControl"), @BeanTag(name="smallTextAreaControl", parent="Uif-SmallTextAreaControl"), @BeanTag(name="mediumTextAreaControl", parent="Uif-MediumTextAreaControl"), @BeanTag(name="largeTextAreaControl", parent="Uif-LargeTextAreaControl")})
public class TextAreaControl
extends ControlBase {
    private static final long serialVersionUID = -4664558047325456844L;
    private int rows;
    private int cols;
    private Integer maxLength;
    private Integer minLength;
    private boolean textExpand;
    private String watermarkText = "";

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (parent instanceof InputField) {
            InputField field = (InputField)parent;
            if (this.getMaxLength() == null) {
                this.setMaxLength(field.getMaxLength());
            }
            if (this.getMinLength() == null) {
                this.setMinLength(field.getMinLength());
            }
            if (this.textExpand) {
                field.setRenderInputAddonGroup(true);
            }
        }
    }

    @BeanTagAttribute
    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    @BeanTagAttribute
    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    @BeanTagAttribute
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @BeanTagAttribute
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    @BeanTagAttribute
    public String getWatermarkText() {
        return this.watermarkText;
    }

    public void setWatermarkText(String watermarkText) {
        if (StringUtils.isNotEmpty((String)watermarkText)) {
            watermarkText = watermarkText + "   ";
        }
        this.watermarkText = watermarkText;
    }

    @BeanTagAttribute
    public boolean isTextExpand() {
        return this.textExpand;
    }

    public void setTextExpand(boolean textExpand) {
        this.textExpand = textExpand;
    }
}

