/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBean;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.KeepExpression;
import org.kuali.rice.krad.uif.component.PropertyReplacer;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.layout.LayoutManager;
import org.kuali.rice.krad.uif.util.CopyUtils;
import org.kuali.rice.krad.uif.util.ExpressionFunctions;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DefaultExpressionEvaluator
implements ExpressionEvaluator {
    private static final Logger LOG = Logger.getLogger(DefaultExpressionEvaluator.class);
    protected static final Pattern SERVER_EVALUATION_PATTERN = Pattern.compile("(\\s?!?\\b(#|get|is)(.*?\\(.*?\\)))(\\s|$)");
    private StandardEvaluationContext evaluationContext;
    private Map<String, Expression> cachedExpressions = new HashMap<String, Expression>();
    protected static ExpressionParser parser = new SpelExpressionParser();
    private static Method isAssignableFrom;
    private static Method empty;
    private static Method emptyList;
    private static Method getService;
    private static Method listContains;
    private static Method getName;
    private static Method getParam;
    private static Method getParamAsBoolean;
    private static Method getParamAsInteger;
    private static Method getParamAsDouble;
    private static Method hasPerm;
    private static Method hasPermDtls;
    private static Method hasPermTmpl;
    private static Method sequence;
    private static Method getDataObjectKey;
    private static Method isProductionEnvironment;

    @Override
    public void populatePropertyExpressionsFromGraph(UifDictionaryBean expressionConfigurable, boolean buildRefreshGraphs) {
        if (expressionConfigurable == null || expressionConfigurable.getExpressionGraph() == null) {
            return;
        }
        Map<String, String> expressionGraph = expressionConfigurable.getExpressionGraph();
        for (Map.Entry<String, String> expressionEntry : expressionGraph.entrySet()) {
            String propertyName = expressionEntry.getKey();
            String expression = expressionEntry.getValue();
            UifDictionaryBean configurableWithExpression = expressionConfigurable;
            String adjustedPropertyName = propertyName;
            if (StringUtils.contains((String)propertyName, (String)".")) {
                String configurablePath = StringUtils.substringBeforeLast((String)propertyName, (String)".");
                adjustedPropertyName = StringUtils.substringAfterLast((String)propertyName, (String)".");
                Object nestedObject = ObjectPropertyUtils.getPropertyValue(expressionConfigurable, configurablePath);
                if (nestedObject == null || !(nestedObject instanceof UifDictionaryBean)) {
                    throw new RiceRuntimeException("Object for which expression is configured on is null or does not implement UifDictionaryBean: '" + configurablePath + "'");
                }
                configurableWithExpression = (UifDictionaryBean)nestedObject;
            }
            if (!ObjectPropertyUtils.isWritableProperty(configurableWithExpression, adjustedPropertyName)) continue;
            configurableWithExpression.getPropertyExpressions().put(adjustedPropertyName, expression);
        }
    }

    @Override
    public String parseExpression(String exp, List<String> controlNames, Map<String, Object> context) {
        boolean complexCondition;
        exp = this.cleanUpExpression(exp);
        Map<String, String> serverEvaluations = this.evaluateServerSideVariables(exp, context);
        String conditionJs = exp;
        controlNames.addAll(this.findControlNamesInExpression(exp));
        conditionJs = this.replaceWithJsEquivalents(conditionJs);
        for (String serverEvalToken : serverEvaluations.keySet()) {
            String evaluatedValue = serverEvaluations.get(serverEvalToken);
            conditionJs = conditionJs.replace(serverEvalToken, evaluatedValue);
        }
        ArrayList<String> removeControlNames = new ArrayList<String>();
        ArrayList<String> addControlNames = new ArrayList<String>();
        for (String propertyName : controlNames) {
            if (propertyName.trim().startsWith("{") && propertyName.trim().endsWith("}")) {
                String array = propertyName.trim().replace('{', '[');
                array = array.replace('}', ']');
                conditionJs = conditionJs.replace(propertyName, array);
                removeControlNames.add(propertyName);
                continue;
            }
            if (propertyName.startsWith("!")) {
                String actualPropertyName = StringUtils.removeStart((String)propertyName, (String)"!");
                conditionJs = conditionJs.replace(propertyName, "!coerceValue(\"" + actualPropertyName + "\")");
                removeControlNames.add(propertyName);
                addControlNames.add(actualPropertyName);
                continue;
            }
            conditionJs = conditionJs.replace(propertyName, "coerceValue(\"" + propertyName + "\")");
        }
        controlNames.removeAll(removeControlNames);
        controlNames.addAll(addControlNames);
        boolean bl = complexCondition = conditionJs.contains(" (") || conditionJs.startsWith("(");
        if (conditionJs.contains("true && ") || conditionJs.contains(" && true")) {
            conditionJs = conditionJs.replace(" && true", "");
            conditionJs = conditionJs.replace("true && ", "");
        }
        if (!complexCondition && conditionJs.contains("false &&") || conditionJs.contains("&& false") || conditionJs.contains("|| true") || conditionJs.contains("true ||") || conditionJs.equals("true") || conditionJs.equals("false")) {
            conditionJs = "";
        }
        return conditionJs;
    }

    private String cleanUpExpression(String exp) {
        if ((exp = exp.trim()).startsWith("@{") && (exp = StringUtils.removeStart((String)exp, (String)"@{")).endsWith("}")) {
            exp = StringUtils.removeEnd((String)exp, (String)"}");
        }
        exp = StringUtils.replace((String)exp, (String)"!=", (String)" != ");
        exp = StringUtils.replace((String)exp, (String)"==", (String)" == ");
        exp = StringUtils.replace((String)exp, (String)">", (String)" > ");
        exp = StringUtils.replace((String)exp, (String)"<", (String)" < ");
        exp = StringUtils.replace((String)exp, (String)"<=", (String)" <= ");
        exp = StringUtils.replace((String)exp, (String)">=", (String)" >= ");
        exp = StringUtils.replace((String)exp, (String)"&&", (String)" && ");
        exp = StringUtils.replace((String)exp, (String)"||", (String)" || ");
        exp = StringUtils.replace((String)exp, (String)"  ", (String)" ");
        exp = StringUtils.replace((String)exp, (String)" )", (String)")");
        exp = StringUtils.replace((String)exp, (String)"( ", (String)"(");
        exp = StringUtils.replace((String)exp, (String)" ,", (String)",");
        return exp;
    }

    private Map<String, String> evaluateServerSideVariables(String exp, Map<String, Object> context) {
        HashMap<String, String> serverEvaluations = new HashMap<String, String>();
        Matcher matcher = SERVER_EVALUATION_PATTERN.matcher(exp);
        while (matcher.find()) {
            String spelMethodCall = matcher.group(1);
            Object value = this.evaluateExpression(context, spelMethodCall);
            if (value == null) {
                serverEvaluations.put(spelMethodCall, "null");
                continue;
            }
            if (value instanceof String) {
                serverEvaluations.put(spelMethodCall, "\"" + value + "\"");
                continue;
            }
            if (value instanceof Boolean || NumberUtils.isNumber((String)value.toString())) {
                serverEvaluations.put(spelMethodCall, value.toString());
                continue;
            }
            serverEvaluations.put(spelMethodCall, "\"" + value.toString() + "\"");
        }
        return serverEvaluations;
    }

    private String replaceWithJsEquivalents(String conditionJs) {
        conditionJs = conditionJs.replaceAll("\\s(?i:ne)\\s", " != ");
        conditionJs = conditionJs.replaceAll("\\s(?i:eq)\\s", " == ");
        conditionJs = conditionJs.replaceAll("\\s(?i:gt)\\s", " > ");
        conditionJs = conditionJs.replaceAll("\\s(?i:lt)\\s", " < ");
        conditionJs = conditionJs.replaceAll("\\s(?i:lte)\\s", " <= ");
        conditionJs = conditionJs.replaceAll("\\s(?i:gte)\\s", " >= ");
        conditionJs = conditionJs.replaceAll("\\s(?i:and)\\s", " && ");
        conditionJs = conditionJs.replaceAll("\\s(?i:or)\\s", " || ");
        conditionJs = conditionJs.replaceAll("\\s(?i:not)\\s", " != ");
        conditionJs = conditionJs.replaceAll("\\s(?i:null)\\s?", " '' ");
        conditionJs = conditionJs.replaceAll("\\s?(?i:#empty)\\((.*?)\\)", "isValueEmpty($1)");
        conditionJs = conditionJs.replaceAll("\\s?(?i:#listContains)\\((.*?)\\)", "listContains($1)");
        if ((conditionJs = conditionJs.replaceAll("\\s?(?i:#emptyList)\\((.*?)\\)", "emptyList($1)")).contains("matches")) {
            conditionJs = conditionJs.replaceAll("\\s+(?i:matches)\\s+'.*'", ".match(/$0/) != null ");
            conditionJs = conditionJs.replaceAll("\\(/\\s+(?i:matches)\\s+'", "(/");
            conditionJs = conditionJs.replaceAll("'\\s*/\\)", "/)");
        }
        return conditionJs;
    }

    @Override
    public List<String> findControlNamesInExpression(String exp) {
        ArrayList<String> controlNames = new ArrayList<String>();
        String stack = "";
        boolean expectingSingleQuote = false;
        boolean ignoreNext = false;
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (!(expectingSingleQuote || ignoreNext || c != '(' && c != ' ' && c != ')')) {
                this.evaluateCurrentStack(stack.trim(), controlNames);
                stack = "";
                continue;
            }
            if (!ignoreNext && c == '\'') {
                stack = stack + c;
                expectingSingleQuote = !expectingSingleQuote;
                continue;
            }
            if (c == '\\') {
                stack = stack + c;
                ignoreNext = !ignoreNext;
                continue;
            }
            stack = stack + c;
            ignoreNext = false;
        }
        if (StringUtils.isNotEmpty((String)stack)) {
            this.evaluateCurrentStack(stack.trim(), controlNames);
        }
        return controlNames;
    }

    protected void evaluateCurrentStack(String stack, List<String> controlNames) {
        boolean isNumber;
        if (StringUtils.isBlank((String)stack)) {
            return;
        }
        if (!(stack.equals("==") || stack.equals("!=") || stack.equals(">") || stack.equals("<") || stack.equals(">=") || stack.equals("<=") || stack.equalsIgnoreCase("ne") || stack.equalsIgnoreCase("eq") || stack.equalsIgnoreCase("gt") || stack.equalsIgnoreCase("lt") || stack.equalsIgnoreCase("lte") || stack.equalsIgnoreCase("gte") || stack.equalsIgnoreCase("matches") || stack.equalsIgnoreCase("null") || stack.equalsIgnoreCase("false") || stack.equalsIgnoreCase("true") || stack.equalsIgnoreCase("and") || stack.equalsIgnoreCase("or") || stack.startsWith("#") || stack.equals("!") || stack.startsWith("'") || stack.endsWith("'") || (isNumber = NumberUtils.isNumber((String)stack)))) {
            if (StringUtils.endsWith((String)stack, (String)",")) {
                stack = StringUtils.removeEnd((String)stack, (String)",").trim();
            }
            if (!controlNames.contains(stack)) {
                controlNames.add(stack);
            }
        }
    }

    @Override
    public void initializeEvaluationContext(Object contextObject) {
        this.evaluationContext = new StandardEvaluationContext(contextObject);
        this.addCustomFunctions(this.evaluationContext);
    }

    @Override
    public void evaluateExpressionsOnConfigurable(View view, UifDictionaryBean expressionConfigurable, Map<String, Object> evaluationParameters) {
        if (expressionConfigurable instanceof Component || expressionConfigurable instanceof LayoutManager) {
            this.evaluatePropertyReplacers(view, expressionConfigurable, evaluationParameters);
        }
        this.evaluatePropertyExpressions(view, expressionConfigurable, evaluationParameters);
    }

    @Override
    public Object evaluateExpression(Map<String, Object> evaluationParameters, String expressionStr) {
        Object result = null;
        if (StringUtils.startsWith((String)expressionStr, (String)"@{") && StringUtils.endsWith((String)expressionStr, (String)"}")) {
            expressionStr = StringUtils.removeStart((String)expressionStr, (String)"@{");
            expressionStr = StringUtils.removeEnd((String)expressionStr, (String)"}");
        }
        try {
            Expression expression = this.retrieveCachedExpression(expressionStr);
            if (evaluationParameters != null) {
                this.evaluationContext.setVariables(evaluationParameters);
            }
            result = expression.getValue((EvaluationContext)this.evaluationContext);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception evaluating expression: " + expressionStr));
            throw new RuntimeException("Exception evaluating expression: " + expressionStr, e);
        }
        return result;
    }

    @Override
    public String evaluateExpressionTemplate(Map<String, Object> evaluationParameters, String expressionTemplate) {
        String result = null;
        try {
            Expression expression = this.retrieveCachedExpression(expressionTemplate);
            if (evaluationParameters != null) {
                this.evaluationContext.setVariables(evaluationParameters);
            }
            result = (String)expression.getValue((EvaluationContext)this.evaluationContext, String.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception evaluating expression: " + expressionTemplate));
            throw new RuntimeException("Exception evaluating expression: " + expressionTemplate, e);
        }
        return result;
    }

    @Override
    public void evaluatePropertyExpression(View view, Map<String, Object> evaluationParameters, UifDictionaryBean expressionConfigurable, String propertyName, boolean removeExpression) {
        Map<String, String> propertyExpressions = expressionConfigurable.getPropertyExpressions();
        if (propertyExpressions == null || !propertyExpressions.containsKey(propertyName)) {
            return;
        }
        String expression = propertyExpressions.get(propertyName);
        if (StringUtils.equals((String)propertyName, (String)"defaultValue") && StringUtils.contains((String)expression, (String)"#sequence")) {
            return;
        }
        if (CopyUtils.fieldHasAnnotation(expressionConfigurable.getClass(), propertyName, KeepExpression.class)) {
            ObjectPropertyUtils.setPropertyValue(expressionConfigurable, propertyName, expression);
            return;
        }
        Object propertyValue = null;
        String adjustedExpression = this.replaceBindingPrefixes(view, expressionConfigurable, expression);
        propertyValue = StringUtils.startsWith((String)adjustedExpression, (String)"@{") && StringUtils.endsWith((String)adjustedExpression, (String)"}") && StringUtils.countMatches((String)adjustedExpression, (String)"@{") == 1 ? this.evaluateExpression(evaluationParameters, adjustedExpression) : this.evaluateExpressionTemplate(evaluationParameters, adjustedExpression);
        if (StringUtils.endsWith((String)propertyName, (String)".add")) {
            StringUtils.removeEnd((String)propertyName, (String)".add");
            Collection collectionValue = (Collection)ObjectPropertyUtils.getPropertyValue(expressionConfigurable, propertyName);
            if (collectionValue == null) {
                throw new RuntimeException("Property name: " + propertyName + " with collection type was not initialized. Cannot add expression result");
            }
            collectionValue.add(propertyValue);
        } else {
            ObjectPropertyUtils.setPropertyValue(expressionConfigurable, propertyName, propertyValue);
        }
        if (removeExpression) {
            propertyExpressions.remove(propertyName);
        }
    }

    @Override
    public boolean containsElPlaceholder(String value) {
        String elPlaceholder;
        boolean containsElPlaceholder = false;
        if (StringUtils.isNotBlank((String)value) && StringUtils.isNotBlank((String)(elPlaceholder = StringUtils.substringBetween((String)value, (String)"@{", (String)"}")))) {
            containsElPlaceholder = true;
        }
        return containsElPlaceholder;
    }

    @Override
    public String replaceBindingPrefixes(View view, Object object, String expression) {
        String adjustedExpression = StringUtils.replace((String)expression, (String)"#form.", (String)"");
        if (StringUtils.contains((String)adjustedExpression, (String)"#fp.")) {
            if (object instanceof DataField) {
                BindingInfo bindingInfo = ((DataField)object).getBindingInfo();
                Pattern pattern = Pattern.compile("(" + Pattern.quote("#fp.") + "[\\.\\w]+" + ")");
                Matcher matcher = pattern.matcher(adjustedExpression);
                while (matcher.find()) {
                    String path = matcher.group();
                    String adjustedPath = bindingInfo.getPropertyAdjustedBindingPath(path);
                    adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)path, (String)adjustedPath);
                }
            } else {
                adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#fp.", (String)"");
            }
        }
        if ((adjustedExpression = StringUtils.isNotBlank((String)view.getDefaultBindingObjectPath()) ? StringUtils.replace((String)adjustedExpression, (String)"#dp.", (String)(view.getDefaultBindingObjectPath() + ".")) : StringUtils.replace((String)adjustedExpression, (String)"#dp.", (String)"")).contains("#lp.") && object instanceof Component) {
            String linePath = DefaultExpressionEvaluator.getLinePathPrefixValue((Component)object);
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#lp.", (String)(StringUtils.isEmpty((String)linePath) ? linePath : linePath + "."));
        }
        if (adjustedExpression.contains("#np.") && object instanceof Component) {
            String nodePath = "";
            Map<String, Object> context = ((Component)object).getContext();
            if (context != null && context.containsKey("nodePath")) {
                nodePath = (String)context.get("nodePath");
            }
            adjustedExpression = StringUtils.replace((String)adjustedExpression, (String)"#np.", (String)(nodePath + "."));
        }
        return adjustedExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression retrieveCachedExpression(String expressionTemplate) {
        Expression expression = null;
        if (this.cachedExpressions.containsKey(expressionTemplate)) {
            return this.cachedExpressions.get(expressionTemplate);
        }
        expression = StringUtils.contains((String)expressionTemplate, (String)"@{") ? parser.parseExpression(expressionTemplate, (ParserContext)new TemplateParserContext("@{", "}")) : parser.parseExpression(expressionTemplate);
        Map<String, Expression> map = this.cachedExpressions;
        synchronized (map) {
            this.cachedExpressions.put(expressionTemplate, expression);
        }
        return expression;
    }

    protected void addCustomFunctions(StandardEvaluationContext context) {
        context.registerFunction("isAssignableFrom", isAssignableFrom);
        context.registerFunction("empty", empty);
        context.registerFunction("emptyList", emptyList);
        context.registerFunction("getService", getService);
        context.registerFunction("listContains", listContains);
        context.registerFunction("getName", getName);
        context.registerFunction("getParam", getParam);
        context.registerFunction("getParamAsBoolean", getParamAsBoolean);
        context.registerFunction("getParamAsInteger", getParamAsInteger);
        context.registerFunction("getParamAsDouble", getParamAsDouble);
        context.registerFunction("hasPerm", hasPerm);
        context.registerFunction("hasPermDtls", hasPermDtls);
        context.registerFunction("hasPermTmpl", hasPermTmpl);
        context.registerFunction("sequence", sequence);
        context.registerFunction("getDataObjectKey", getDataObjectKey);
        context.registerFunction("isProductionEnvironment", isProductionEnvironment);
    }

    protected void evaluatePropertyReplacers(View view, UifDictionaryBean expressionConfigurable, Map<String, Object> evaluationParameters) {
        List<PropertyReplacer> replacers = null;
        if (Component.class.isAssignableFrom(expressionConfigurable.getClass())) {
            replacers = ((Component)expressionConfigurable).getPropertyReplacers();
        } else if (LayoutManager.class.isAssignableFrom(expressionConfigurable.getClass())) {
            replacers = ((LayoutManager)expressionConfigurable).getPropertyReplacers();
        }
        if (replacers != null) {
            for (PropertyReplacer propertyReplacer : replacers) {
                String expression = propertyReplacer.getCondition();
                String adjustedExpression = this.replaceBindingPrefixes(view, expressionConfigurable, expression);
                String conditionEvaluation = this.evaluateExpressionTemplate(evaluationParameters, adjustedExpression);
                boolean conditionSuccess = Boolean.parseBoolean(conditionEvaluation);
                if (!conditionSuccess) continue;
                ObjectPropertyUtils.setPropertyValue(expressionConfigurable, propertyReplacer.getPropertyName(), propertyReplacer.getReplacement());
            }
        }
    }

    protected void evaluatePropertyExpressions(View view, UifDictionaryBean expressionConfigurable, Map<String, Object> evaluationParameters) {
        if (expressionConfigurable == null) {
            return;
        }
        Map<String, String> propertyExpressions = expressionConfigurable.getPropertyExpressions();
        if (propertyExpressions == null) {
            return;
        }
        for (String propertyName : propertyExpressions.keySet()) {
            this.evaluatePropertyExpression(view, evaluationParameters, expressionConfigurable, propertyName, false);
        }
    }

    protected static String getLinePathPrefixValue(Component component) {
        Map<String, Object> componentContext = component.getContext();
        if (componentContext == null) {
            return "";
        }
        CollectionGroup collectionGroup = (CollectionGroup)componentContext.get("collectionGroup");
        if (collectionGroup == null) {
            LOG.warn((Object)("collection group not found for " + component + "," + component.getId() + ", " + component.getComponentTypeName()));
            return "";
        }
        String linePath = "";
        Integer indexObj = (Integer)componentContext.get("index");
        if (indexObj != null) {
            int index = indexObj;
            boolean addLine = false;
            Boolean addLineObj = (Boolean)componentContext.get("isAddLine");
            if (addLineObj != null) {
                addLine = addLineObj;
            }
            linePath = addLine ? collectionGroup.getAddLineBindingInfo().getBindingPath() : collectionGroup.getBindingInfo().getBindingPath() + "[" + index + "]";
        }
        return linePath;
    }

    static {
        try {
            isAssignableFrom = ExpressionFunctions.class.getDeclaredMethod("isAssignableFrom", Class.class, Class.class);
            empty = ExpressionFunctions.class.getDeclaredMethod("empty", Object.class);
            emptyList = ExpressionFunctions.class.getDeclaredMethod("emptyList", List.class);
            listContains = ExpressionFunctions.class.getDeclaredMethod("listContains", List.class, Object[].class);
            getName = ExpressionFunctions.class.getDeclaredMethod("getName", Class.class);
            getParam = ExpressionFunctions.class.getDeclaredMethod("getParam", String.class, String.class, String.class);
            getParamAsBoolean = ExpressionFunctions.class.getDeclaredMethod("getParamAsBoolean", String.class, String.class, String.class);
            getParamAsInteger = ExpressionFunctions.class.getDeclaredMethod("getParamAsInteger", String.class, String.class, String.class);
            getParamAsDouble = ExpressionFunctions.class.getDeclaredMethod("getParamAsDouble", String.class, String.class, String.class);
            hasPerm = ExpressionFunctions.class.getDeclaredMethod("hasPerm", String.class, String.class);
            hasPermDtls = ExpressionFunctions.class.getDeclaredMethod("hasPermDtls", String.class, String.class, Map.class, Map.class);
            hasPermTmpl = ExpressionFunctions.class.getDeclaredMethod("hasPermTmpl", String.class, String.class, Map.class, Map.class);
            getService = ExpressionFunctions.class.getDeclaredMethod("getService", String.class);
            sequence = ExpressionFunctions.class.getDeclaredMethod("sequence", String.class);
            getDataObjectKey = ExpressionFunctions.class.getDeclaredMethod("getDataObjectKey", String.class);
            isProductionEnvironment = ExpressionFunctions.class.getDeclaredMethod("isProductionEnvironment", null);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Custom function for el expressions not found: " + e.getMessage()));
            throw new RuntimeException("Custom function for el expressions not found: " + e.getMessage(), e);
        }
    }
}

