/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.krad.web.filter.BootstrapFilterChain;
import org.kuali.rice.krad.web.filter.BootstrapFilterConfig;
import org.kuali.rice.krad.web.filter.FilterMapping;

public class BootstrapFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(BootstrapFilter.class);
    private static final String FILTER_PREFIX = "filter.";
    private static final String CLASS_SUFFIX = ".class";
    private static final String FILTER_MAPPING_PREFIX = "filtermapping.";
    private static final String FILTER_EXCLUDE_PREFIX = "filterexclude.";
    private FilterConfig config;
    private final Map<String, Filter> filters = new HashMap<String, Filter>();
    private final SortedSet<FilterMapping> filterMappings = new TreeSet<FilterMapping>();
    private final Map<String, ArrayList<String>> filterExclusions = new HashMap<String, ArrayList<String>>();
    private boolean initted = false;

    public void init(FilterConfig cfg) throws ServletException {
        this.config = cfg;
    }

    private void addFilter(String name, String classname, Map<String, String> props) throws ServletException {
        LOG.debug((Object)("Adding filter: " + name + "=" + classname));
        Object filterObject = GlobalResourceLoader.getResourceLoader().getObject(new ObjectDefinition(classname));
        if (filterObject == null) {
            throw new ServletException("Filter '" + name + "' class not found: " + classname);
        }
        if (!(filterObject instanceof Filter)) {
            LOG.error((Object)("Class '" + filterObject.getClass() + "' does not implement servlet javax.servlet.Filter"));
            return;
        }
        Filter filter = (Filter)filterObject;
        BootstrapFilterConfig fc = new BootstrapFilterConfig(this.config.getServletContext(), name);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            String prefix;
            String key = entry.getKey().toString();
            if (!key.startsWith(prefix = FILTER_PREFIX + name + ".") || key.equals(FILTER_PREFIX + name + CLASS_SUFFIX)) continue;
            String paramName = key.substring(prefix.length());
            fc.addInitParameter(paramName, entry.getValue());
        }
        try {
            filter.init((FilterConfig)fc);
            this.filters.put(name, filter);
        }
        catch (ServletException se) {
            LOG.error((Object)("Error initializing filter: " + name + " [" + classname + "]"), (Throwable)se);
        }
    }

    private void addFilterMapping(String filterName, String orderNumber, String value) {
        this.filterMappings.add(new FilterMapping(filterName, orderNumber, value));
    }

    private void addFilterExclusion(String filterName, String exclusion) {
        if (this.filterExclusions.containsKey(filterName)) {
            this.filterExclusions.get(filterName).add(exclusion);
        } else {
            this.filterExclusions.put(filterName, new ArrayList<String>(Arrays.asList(exclusion)));
        }
    }

    private synchronized void init() throws ServletException {
        if (this.initted) {
            return;
        }
        LOG.debug((Object)"initializing...");
        Config cfg = ConfigContext.getCurrentContextConfig();
        HashMap<Object, Object> p = new HashMap<Object, Object>(cfg.getProperties());
        for (Map.Entry entry : p.entrySet()) {
            String filterName;
            String[] values;
            String key = ((String)entry.getKey()).toString();
            if (key.startsWith(FILTER_MAPPING_PREFIX)) {
                values = key.split("\\.");
                if (values.length != 2 && values.length != 3) {
                    throw new ServletException("Invalid filter mapping defined.  Should contain 2 or 3 pieces in the form of filtermapping.<<filter name>>.<<order number>> with the last piece optional.");
                }
                filterName = values[1];
                String orderNumber = values.length == 2 ? "0" : values[2];
                String value = (String)entry.getValue();
                this.addFilterMapping(filterName, orderNumber, value);
                continue;
            }
            if (key.startsWith(FILTER_PREFIX) && key.endsWith(CLASS_SUFFIX)) {
                String name = key.substring(FILTER_PREFIX.length(), key.length() - CLASS_SUFFIX.length());
                String value = (String)entry.getValue();
                this.addFilter(name, value, p);
                continue;
            }
            if (!key.startsWith(FILTER_EXCLUDE_PREFIX)) continue;
            values = key.split("\\.");
            if (values.length != 2 && values.length != 3) {
                throw new ServletException("Invalid filter mapping defined.  Should contain 2 or 3 pieces in the form of filterexclusion.<<filter name>>.<<number>> with the last piece optional.");
            }
            filterName = values[1];
            String value = (String)entry.getValue();
            this.addFilterExclusion(filterName, value);
        }
        for (String filterName : this.filters.keySet()) {
            if (this.hasFilterMapping(filterName)) continue;
            LOG.warn((Object)("NO FILTER MAPPING DETECTED.  Filter " + filterName + " has no mapping and will not be called."));
        }
        this.initted = true;
    }

    private boolean hasFilterMapping(String filterName) {
        for (FilterMapping filterMapping : this.filterMappings) {
            if (!filterMapping.getFilterName().equals(filterName)) continue;
            return true;
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug((Object)"Begin BootstrapFilter...");
        this.init();
        if (!this.filterMappings.isEmpty() && request instanceof HttpServletRequest) {
            chain = this.buildChain((HttpServletRequest)request, chain);
        }
        LOG.debug((Object)"...ending BootstrapFilter preperation, executing BootstrapFilter Chain.");
        chain.doFilter(request, response);
    }

    private FilterChain buildChain(HttpServletRequest request, FilterChain targetChain) {
        BootstrapFilterChain chain = new BootstrapFilterChain(targetChain, ClassLoaderUtils.getDefaultClassLoader());
        String requestPath = request.getServletPath();
        for (FilterMapping mapping : this.filterMappings) {
            Filter filter = this.filters.get(mapping.getFilterName());
            if (chain.containsFilter(filter) || !this.matchFiltersURL(mapping.getUrlPattern(), requestPath) || this.excludeFilter(mapping.getFilterName(), request.getRequestURL().toString())) continue;
            chain.addFilter(filter);
        }
        return chain;
    }

    private boolean excludeFilter(String filterName, String requestPath) {
        if (this.filterExclusions.containsKey(filterName)) {
            for (String exclusionString : this.filterExclusions.get(filterName)) {
                if (!requestPath.matches(exclusionString)) continue;
                return true;
            }
        }
        return false;
    }

    public void destroy() {
        for (Filter filter : this.filters.values()) {
            try {
                filter.destroy();
            }
            catch (Exception e) {
                LOG.error((Object)("Error destroying filter: " + filter), (Throwable)e);
            }
        }
    }

    private boolean matchFiltersURL(String urlPattern, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.equals(requestPath)) {
            return true;
        }
        if (urlPattern.equals("/*") || urlPattern.equals("*")) {
            return true;
        }
        if (urlPattern.endsWith("/*")) {
            if (urlPattern.regionMatches(0, requestPath, 0, urlPattern.length() - 2)) {
                if (requestPath.length() == urlPattern.length() - 2) {
                    return true;
                }
                if ('/' == requestPath.charAt(urlPattern.length() - 2)) {
                    return true;
                }
            }
            return false;
        }
        if (urlPattern.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == urlPattern.length() - 1) {
                return urlPattern.regionMatches(2, requestPath, period + 1, urlPattern.length() - 2);
            }
        }
        return false;
    }
}

