/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.listener;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;

public class NonSerializableSessionListener
implements HttpSessionAttributeListener {
    private static final Log LOG = LogFactory.getLog(NonSerializableSessionListener.class);
    private static final String ENABLE_SERIALIZATION_CHECK = "enableSerializationCheck";
    private Boolean serializationCheckEnabled;

    public void attributeAdded(HttpSessionBindingEvent se) {
        this.logSerializationViolations(se, "added");
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
    }

    public void attributeReplaced(HttpSessionBindingEvent se) {
        this.logSerializationViolations(se, "replaced");
    }

    private void logSerializationViolations(HttpSessionBindingEvent se, String action) {
        if (!NonSerializableSessionListener.productionEnvironmentDetected() && this.isSerializationCheckEnabled().booleanValue()) {
            this.checkSerialization(se, action);
        }
    }

    private static boolean productionEnvironmentDetected() {
        Config c = ConfigContext.getCurrentContextConfig();
        return c != null && c.isProductionEnvironment();
    }

    private Boolean isSerializationCheckEnabled() {
        if (this.serializationCheckEnabled == null) {
            Config c = ConfigContext.getCurrentContextConfig();
            this.serializationCheckEnabled = c != null && c.getBooleanProperty(ENABLE_SERIALIZATION_CHECK) != false;
        }
        return this.serializationCheckEnabled;
    }

    protected void checkSerialization(HttpSessionBindingEvent se, String action) {
        Object o = se.getValue();
        if (o != null) {
            if (!NonSerializableSessionListener.isSerializable(o)) {
                LOG.error((Object)("Attribute of class " + o.getClass().getName() + " with name " + se.getName() + " from source " + se.getSource().getClass().getName() + " was " + action + " to session and does not implement " + Serializable.class.getName()));
            } else if (!NonSerializableSessionListener.canBeSerialized((Serializable)o)) {
                LOG.error((Object)("Attribute of class " + o.getClass().getName() + " with name " + se.getName() + " from source " + se.getSource().getClass().getName() + " was " + action + " to session and cannot be Serialized"));
            }
        }
    }

    private static boolean isSerializable(Object o) {
        return o instanceof Serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canBeSerialized(Serializable o) {
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream(512);
            out = new ObjectOutputStream(baos);
            out.writeObject(o);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn((Object)"error serializing object", (Throwable)e);
        }
        finally {
            try {
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"error closing stream", (Throwable)e);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"error closing stream", (Throwable)e);
                    }
                }
            }
        }
        return false;
    }
}

