/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad;

import java.lang.reflect.Method;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krad.bo.DocumentAttachment;
import org.kuali.rice.krad.document.DocumentBase;
import org.kuali.rice.krad.maintenance.MaintenanceLock;
import org.kuali.rice.krad.messages.Message;
import org.reflections.Reflections;

public class StaticWeavingTest {
    private static final String TEST_PACKAGE_PREFIX = "org.kuali.rice.krad.sampleapp";

    @Test
    public void testStaticWeaving() {
        Reflections reflections = new Reflections(new Object[]{DocumentAttachment.class.getPackage().getName(), DocumentBase.class.getPackage().getName(), MaintenanceLock.class.getPackage().getName(), Message.class.getPackage().getName()});
        Set entityTypes = reflections.getTypesAnnotatedWith(Entity.class);
        Set superTypes = reflections.getTypesAnnotatedWith(MappedSuperclass.class);
        Set embeddableTypes = reflections.getTypesAnnotatedWith(Embeddable.class);
        this.assertStaticWeaved(entityTypes, superTypes, embeddableTypes);
    }

    private void assertStaticWeaved(Set<Class<?>> ... types) {
        for (Set<Class<?>> typeSet : types) {
            for (Class<?> type : typeSet) {
                Method[] methods;
                if (!this.hasValidAnnotation(type) || type.getName().startsWith(TEST_PACKAGE_PREFIX)) continue;
                boolean foundWeaved = false;
                for (Method method : methods = type.getDeclaredMethods()) {
                    if (!method.getName().startsWith("_persistence")) continue;
                    foundWeaved = true;
                    break;
                }
                if (foundWeaved) continue;
                Assert.fail((String)("(NOTE: it is expected this test may fail if executed from the IDE instead of command line since the IDE will not execute the static weaving automatically). Found a class which is not bytecode weaved (contains no methods starting with '_persistence'): " + type + " " + "In order to resolve this, please ensure that this type is included in " + "META-INF/persistence-weaving.xml"));
            }
        }
    }

    private boolean hasValidAnnotation(Class<?> type) {
        return type.isAnnotationPresent(Entity.class) || type.isAnnotationPresent(MappedSuperclass.class) || type.isAnnotationPresent(Embeddable.class);
    }
}

