/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.inquiry;

import org.kuali.rice.krad.util.KRADConstants;
import org.kuali.rice.krad.web.controller.UifControllerBase;
import org.kuali.rice.krad.web.form.InquiryForm;
import org.kuali.rice.krad.web.service.ControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Controller for inquiry views which handle initial requests for the inquiry and
 * actions coming from the inquiry view such as export.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Controller
@RequestMapping(value = KRADConstants.ControllerMappings.INQUIRY)
public class InquiryController extends UifControllerBase {

    /**
     * {@inheritDoc}
     */
    @Override
    protected InquiryForm createInitialForm() {
        return new InquiryForm();
    }

    /**
     * @see org.kuali.rice.krad.inquiry.InquiryControllerService#downloadDataObjectAttachment(org.kuali.rice.krad.web.form.InquiryForm,
     * javax.servlet.http.HttpServletResponse)
     */
    @RequestMapping(method = RequestMethod.POST, params = "methodToCall=downloadDataObjectAttachment")
    public ModelAndView downloadDataObjectAttachment(InquiryForm form, HttpServletResponse response) {
        getControllerService().downloadDataObjectAttachment(form, response);

        return null;
    }

    /**
     * @see org.kuali.rice.krad.inquiry.InquiryControllerService#downloadCustomDataObjectAttachment(org.kuali.rice.krad.web.form.InquiryForm,
     * javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @RequestMapping(method = RequestMethod.POST, params = "methodToCall=downloadCustomDataObjectAttachment")
    public ModelAndView downloadCustomDataObjectAttachment(InquiryForm form, HttpServletRequest request,
            HttpServletResponse response) throws Exception {
        getControllerService().downloadCustomDataObjectAttachment(form, request, response);

        return null;
    }

    @RequestMapping(method = RequestMethod.POST, params = "methodToCall=downloadBONote")
    public ModelAndView downloadBONote(InquiryForm form, HttpServletResponse response) {
        getControllerService().downloadBONote(form, response);

        return null;
    }

    @Override
    protected InquiryControllerService getControllerService() {
        return (InquiryControllerService) super.getControllerService();
    }

    @Override
    @Autowired
    @Qualifier("inquiryControllerService")
    public void setControllerService(ControllerService controllerService) {
        super.setControllerService(controllerService);
    }
}
