/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;
import org.kuali.rice.krad.rules.rule.SendAdHocRequestsRule;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;

import java.util.ArrayList;
import java.util.List;

public class SendAdHocRequestsEvent extends DocumentEventBase {

    public SendAdHocRequestsEvent(String errorPathPrefix, Document document) {
        this("creating send adhoc requests event for document " + getDocumentId(document), errorPathPrefix, document);
    }


    public SendAdHocRequestsEvent(Document document) {
        this("", document);
    }

    public SendAdHocRequestsEvent(String description, String errorPathPrefix, Document document) {
    	super(description, errorPathPrefix, document);
    }


	@Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
		return SendAdHocRequestsRule.class;
	}


	@Override
    public boolean invokeRuleMethod(BusinessRule rule) {
		return ((SendAdHocRequestsRule) rule).processSendAdHocRequests(document);
	}

	@Override
	public List<RuleEvent> generateEvents() {
		KualiRuleService ruleService = KRADServiceLocatorWeb.getKualiRuleService();

		List<RuleEvent> events = new ArrayList<RuleEvent>();
        events.addAll(ruleService.generateAdHocRoutePersonEvents(getDocument()));
        events.addAll(ruleService.generateAdHocRouteWorkgroupEvents(getDocument()));
        return events;
	}
}
