/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.component;

/**
 * Components that bind to a model (hold model data) should implement this interface.
 *
 * <p>Provides access to the {@link org.kuali.rice.krad.uif.component.BindingInfo} object for the component that
 * contains binding configuration</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DataBinding extends Component {

	/**
	 * Returns the <code>BindingInfo</code> instance that is configured for the
	 * component
	 *
	 * @return BindingInfo
	 * @see org.kuali.rice.krad.uif.component.BindingInfo
	 */
	BindingInfo getBindingInfo();

    /**
     * Setter for the binding info instance
     *
     * @param bindingInfo
     */
    void setBindingInfo(BindingInfo bindingInfo);

	/**
	 * Name of the property (relative to the parent object) the component binds
	 * to
	 *
	 * @return String property name
	 */
	String getPropertyName();
}
