/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.element;

import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;

import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;

/**
 * Element that presents an Icon.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "icon", parent = "Uif-Icon")})
public class Icon extends ContentElementBase {
    private static final long serialVersionUID = 6771810101056598912L;

    private String iconClass;

    public Icon() {
        super();
    }

    /**
     * Icon Class for the action
     *
     * <p>
     * Bootstrap Icon Class to be rendered on this Action
     * </p>
     *
     * @return label for action
     */
    @BeanTagAttribute
    public String getIconClass() {
        return iconClass;
    }

    /**
     * Setter for the Icon Class
     *
     * @param iconClass
     */
    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void completeValidation(ValidationTrace tracer){
        tracer.addBean(this);

        // Checks that a source is set
        if(getIconClass()==null){
            if(!Validator.checkExpressions(this, "iconClass")){
                String currentValues [] = {"iconClass ="+getIconClass()};
                tracer.createError("iconClass must be set",currentValues);
            }
        }

        super.completeValidation(tracer.getCopy());
    }
}
