/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util;

import org.springframework.aop.MethodBeforeAdvice;

import java.lang.reflect.Method;

/**
 * Prevents calls to "legacy" data framework services if the legacy framework
 * has been disabled
 */
public class LegacyDetectionAdvice implements MethodBeforeAdvice {
    @Override
    public void before(Method method, Object[] args, Object target) throws Throwable {
        if (!LegacyUtils.isLegacyDataFrameworkEnabled()) {
            throw new IllegalStateException("Legacy data framework is disabled.  To use legacy KRAD data services, enable KNS via the KRADConfigurer or set the configuration parameter: " + KRADConstants.Config.ENABLE_LEGACY_DATA_FRAMEWORK);
        }
    }
}
