/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.impl;

import org.kuali.rice.krad.datadictionary.FieldOverride;

import java.util.List;

/**
 * A Field Override used to replace list elements in a Data Dictionary bean.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FieldOverrideForListElementReplaceImpl extends FieldOverrideForListElementBase implements FieldOverride {
    private Object replaceWith;

    public Object getReplaceWith() {
        return replaceWith;
    }

    public void setReplaceWith(Object replaceAt) {
        this.replaceWith = replaceAt;
    }

    protected void varifyConfig() {
        if (replaceWith == null) {
            throw new RuntimeException("Configuration Error, Missing required replaceWith parameter....");
        }
    }

    @Override
    public Object performFieldOverride(Object bean, Object property) {
        varifyConfig();
        List oldList = (List) property;

        int replacePos = getElementPositionInList(getElement(), oldList);

        if (replacePos == -1) {
            throw new RuntimeException("Configuration Error, replace element could not be located.");
        }
        if (replacePos >= 0 && replacePos < oldList.size()) {
            oldList.remove(replacePos);
            oldList.add(replacePos, getReplaceWith());
        }

        return oldList;
    }
}
